<?php

namespace App\Models;

use CodeIgniter\Model;

class Poster_Model extends Model
{
    protected $table = 'poster_tbl';
    protected $primaryKey = 'poster_id';

    protected $allowedFields = ['poster_id', 'doctor_name', 'doctor_img', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];


    public function getRecords()
    {
        return $this->orderBy('region_id', 'ASC')->findAll();
    }
    public function getTotalPosters()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }


    public function getTopUsers()
    {
        return $this->db->table('poster_tbl')
            ->select('poster_tbl.fk_user_id')
            ->groupBy('poster_tbl.fk_user_id')
            ->limit(10)
            ->get()
            ->getNumRows();
    }



    public function getUserData($id)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->where('poster_tbl.fk_user_id', $id)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'DESC')
            ->findAll();
    }


    public function getPosterWithUsersDetails()
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }


    public function getTopUser()
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->limit(10)
            ->findAll();
    }

    public function getUserCount()
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->findAll();
    }

    public function getEentryCountByDate()
    {
        return $this->select('poster_tbl.fk_user_id, poster_tbl.date, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->groupBy('poster_tbl.fk_user_id, poster_tbl.date')
            ->orderBy('poster_tbl.date', 'DESC')
            ->findAll();
    }


    public function getEentrybyDate()
    {
        return $this->select('poster_tbl.fk_user_id, DATE(poster_tbl.date) as entry_date, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", DATE(poster_tbl.date), "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->groupBy('poster_tbl.fk_user_id, entry_date')
            ->orderBy('entry_date', 'DESC')
            ->findAll();
    }

    public function getPosterDate()
    {
        return $this->select('poster_tbl.poster_id, poster_tbl.date')
            ->groupBy(' date')
            ->orderBy('poster_id', 'desc')
            ->findAll();
    }

    public function getTotalPostersByZone($zoneId)
    {
        return $this->select('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->join('tbl_user AS u', 'poster_tbl.fk_user_id = u.user_id', 'left')
            ->where('u.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->countAllResults(false);
    }



    public function getTopUsersByZone($zoneId)
    {
        return $this->db->table('poster_tbl')
            ->select('poster_tbl.fk_user_id')
            ->join('tbl_user u', 'poster_tbl.fk_user_id = u.user_id', 'left')
            ->where('u.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.fk_user_id')
            ->limit(10)
            ->get()
            ->getNumRows(); 
    }

    public function getPosterWithUsersDetailsByZone($zoneId)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->where('tbl_user.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }

    public function getTopUserByZone($zoneId)
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->limit(10)
            ->findAll();
    }

    public function getUserCountByZone($zoneId)
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->findAll();
    }

    public function getEntryByDateByZone($zoneId)
    {
        return $this->select('poster_tbl.fk_user_id, DATE(poster_tbl.date) as entry_date, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", DATE(poster_tbl.date), "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.fk_user_id, entry_date')
            ->orderBy('entry_date', 'DESC')
            ->findAll();
    }

    public function getTotalPostersByRegion($regionId)
    {
        return $this->select('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->join('tbl_user AS u', 'poster_tbl.fk_user_id = u.user_id', 'left')
            ->where('u.fk_region_id', $regionId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->countAllResults(false);
    }

    public function getTopUsersByRegion($regionId)
    {
        return $this->db->table('poster_tbl')
            ->select('poster_tbl.fk_user_id')
            ->join('tbl_user u', 'poster_tbl.fk_user_id = u.user_id', 'left')
            ->where('u.fk_region_id', $regionId)
            ->groupBy('poster_tbl.fk_user_id')
            ->limit(10)
            ->get()
            ->getNumRows(); 
    }

    public function getPosterWithUsersDetailsByRegion($regionId)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->where('tbl_user.fk_region_id', $regionId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }

    public function getTopUserByRegion($regionId)
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_region_id', $regionId)
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->limit(10)
            ->findAll();
    }

    public function getUserCountByRegion($regionId)
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_region_id', $regionId)
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->findAll();
    }

    public function getEntryByDateByRegion($regionId)
    {
        return $this->select('poster_tbl.fk_user_id, DATE(poster_tbl.date) as entry_date, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", DATE(poster_tbl.date), "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_region_id', $regionId)
            ->groupBy('poster_tbl.fk_user_id, entry_date')
            ->orderBy('entry_date', 'DESC')
            ->findAll();
    }

    public function getTotalPostersByHq($hqId)
    {
        return $this->select('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->join('tbl_user AS u', 'poster_tbl.fk_user_id = u.user_id', 'left')
            ->where('u.fk_hq_id', $hqId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->countAllResults(false);
    }

    public function getTopUsersByHq($hqId)
    {
        return $this->db->table('poster_tbl')
            ->select('poster_tbl.fk_user_id')
            ->join('tbl_user u', 'poster_tbl.fk_user_id = u.user_id', 'left')
            ->where('u.fk_hq_id', $hqId)
            ->groupBy('poster_tbl.fk_user_id')
            ->limit(10)
            ->get()
            ->getNumRows();
    }

    public function getPosterWithUsersDetailsByHq($hqId)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->where('tbl_user.fk_hq_id', $hqId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }

    public function getTopUserByHq($hqId)
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_hq_id', $hqId)
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->limit(10)
            ->findAll();
    }

    public function getUserCountByHq($hqId)
    {
        return $this->select('tbl_user.user_id, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone, poster_tbl.date, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_hq_id', $hqId)
            ->groupBy('poster_tbl.date, poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->findAll();
    }

    public function getEntryByDateByHq($hqId)
    {
        return $this->select('poster_tbl.fk_user_id, DATE(poster_tbl.date) as entry_date, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", DATE(poster_tbl.date), "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count, tbl_user.name, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.user_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.fk_hq_id', $hqId)
            ->groupBy('poster_tbl.fk_user_id, entry_date')
            ->orderBy('entry_date', 'DESC')
            ->findAll();
    }




















}


?>