<?php

namespace App\Models;

use CodeIgniter\Model;

class User_Model extends Model
{
    protected $table = 'tbl_user';
    protected $primaryKey = 'user_id';

    protected $allowedFields = ['name', 'phone_no', 'email', 'user_img', 'city', 'fk_usertype_id', 'createdBy', 'emp_no', 'pass', 'fk_hq_id', 'fk_region_id', 'fk_zone_id'];

    public function getRecords()
    {
        return $this->findAll();
    }

    public function getRow($id)
    {
        return $this->where('user_id ', $id)->first();
    }
    public function getTotalUsers()
    {
        return $this->countAllResults();
    }
    public function getUsersWithDetails()
    {
        return $this->select('tbl_user.*, tbl_usertype.user_type, tbl_hq.hq, tbl_region.region, tbl_zone.zone')
            ->join('tbl_usertype', 'tbl_user.fk_usertype_id = tbl_usertype.usertype_id', 'left')
            ->join('tbl_hq', 'tbl_user.fk_hq_id = tbl_hq.hq_id', 'left')
            ->join('tbl_region', 'tbl_user.fk_region_id = tbl_region.region_id', 'left')
            ->join('tbl_zone', 'tbl_user.fk_zone_id = tbl_zone.zone_id', 'left')
            ->orderBy('user_id', 'ASC')
            ->findAll();
    }

    public function getTotalUsersByZone($zoneId)
    {
        $session = session();
        $currentUserId = $session->get('user_id');
        $currentUser = $this->where('user_id', $currentUserId)->first();
        $myUsertypeId = $currentUser['fk_usertype_id'];

        return $this->where('fk_zone_id', $zoneId)
            ->where('user_id !=', $currentUserId)
            ->where('fk_usertype_id <', $myUsertypeId)
            ->countAllResults();
    }


    public function getTotalUsersByRegion($regionId)
    {
        $session = session();
        $currentUserId = $session->get('user_id');
        $currentUser = $this->where('user_id', $currentUserId)->first();
        $myUsertypeId = $currentUser['fk_usertype_id'];

        return $this->where('fk_region_id', $regionId)
            ->where('user_id !=', $currentUserId)
            ->where('fk_usertype_id <', $myUsertypeId)
            ->countAllResults();
    }

    public function getTotalUsersByHq($hqId)
    {
        $session = session();
        $currentUserId = $session->get('user_id');
        $currentUser = $this->where('user_id', $currentUserId)->first();
        $myUsertypeId = $currentUser['fk_usertype_id'];

        return $this->where('fk_hq_id', $hqId)
            ->where('user_id !=', $currentUserId)
            ->where('fk_usertype_id <', $myUsertypeId)
            ->countAllResults();
    }


}




?>