<?php



namespace Config;



// Create a new instance of our RouteCollection class.

$routes = Services::routes();

$routes->setAutoRoute(true);





/*

 * --------------------------------------------------------------------

 * Router Setup

 * --------------------------------------------------------------------

 */

$routes->setDefaultNamespace('App\Controllers');

$routes->setDefaultController('Index_controller');

$routes->setDefaultMethod('index');

$routes->setTranslateURIDashes(false);

$routes->set404Override();

 

// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps

// where controller filters or CSRF chapters_indion are bypassed.

// If you don't want to define all routes, please use the Auto Routing (Improved).

// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.

// $routes->setAutoRoute(false);



/*

 * --------------------------------------------------------------------

 * Route Definitions

 * --------------------------------------------------------------------

 */



// We get a performance increase by specifying the default

// route since we don't have to scan directories.







//*-------------- Admin User --------------*//



// $routes->get('/', 'Home::index');

$routes->get('/index', 'Index_controller::index');

$routes->post('/login', 'Index_controller::login');

$routes->get('/logout', 'Index_controller::logout');

$routes->group("admin", function ($routes) {  
  
    $routes->get('/', 'Index_controller::index');

    $routes->get('index', 'Index_controller::index');
    
    $routes->get('forgot', 'Index_controller::forgot');
    
    $routes->post('forgot_hndl', 'Index_controller::forgot_hndl');
    
    $routes->get('profile', 'Index_controller::admin_profile');
    
    $routes->get('profile_edit/(:num)', 'Index_controller::profile_edit/$1');
    
    
    
    $routes->get('dashboard', 'Index_controller::dashboard');
    
    $routes->get('user_tbl', 'Index_controller::user_tbl');
    
    $routes->post('get_user_by_zone', 'Index_controller::get_user_by_zone');
    
    $routes->post('get_user_by_region', 'Index_controller::get_user_by_region');
    
    $routes->post('get_user_by_hq', 'Index_controller::get_user_by_hq');
    
    $routes->get('add_user', 'Index_controller::add_user');
    
    $routes->post('user_insert', 'Index_controller::user_insert');
    
    $routes->get('user_edit/(:num)', 'Index_controller::user_edit/$1');
    
    $routes->post('user_update', 'Index_controller::user_update');
    
    $routes->get('user_delete/(:num)', 'Index_controller::user_delete/$1');
    
    $routes->get('total_data', 'Index_controller::total_Data');
    
    $routes->post('get_total_data_by_zone', 'Index_controller::get_total_data_by_zone');
    
    $routes->post('get_total_data_by_region', 'Index_controller::get_total_data_by_region');
    
    $routes->post('get_total_data_by_hq', 'Index_controller::get_total_data_by_hq');
    
    $routes->get('total_doctors', 'Index_controller::total_Doctors');
    
    $routes->get('total_patients', 'Index_controller::total_Patients');
    
    $routes->get('total_rx', 'Index_controller::total_rx');
    
    $routes->get('doctor_users_count', 'Index_controller::doctor_users_count');
    
    $routes->get('patient_users_count', 'Index_controller::patient_users_count');
    
    $routes->get('doctor_patients/(:num)', 'Index_controller::doctor_patients/$1');
    
    $routes->get('total_rx', 'Index_controller::total_rx');
    
    $routes->post('get_regions_by_zone', 'Index_controller::get_regions_by_zone');
    
    $routes->post('get_hq_by_region', 'Index_controller::get_hq_by_region');
    
    $routes->post('get_doctor_data_by_zone', 'Index_controller::get_doctor_data_by_zone');
    
    $routes->post('get_doctor_data_by_region', 'Index_controller::get_doctor_data_by_region');
    
    $routes->post('get_doctor_data_by_hq', 'Index_controller::get_doctor_data_by_hq');
    
    $routes->post('get_user_doctor_by_zone', 'Index_controller::get_user_doctor_by_zone');
    
    $routes->post('get_user_doctor_by_region', 'Index_controller::get_user_doctor_by_region');
    
    $routes->post('get_user_doctor_by_hq', 'Index_controller::get_user_doctor_by_hq');
    
    $routes->post('get_patient_data_by_zone', 'Index_controller::get_patient_data_by_zone');
    
    $routes->post('get_patient_data_by_region', 'Index_controller::get_patient_data_by_region');
    
    $routes->post('get_patient_data_by_hq', 'Index_controller::get_patient_data_by_hq');
    
    $routes->post('get_user_patient_by_zone', 'Index_controller::get_user_patient_by_zone');
    
    $routes->post('get_user_patient_by_region', 'Index_controller::get_user_patient_by_region');
    
    $routes->post('get_user_patient_by_hq', 'Index_controller::get_user_patient_by_hq');
    
    $routes->post('get_rx_by_zone', 'Index_controller::get_rx_by_zone');
    
    $routes->post('get_rx_by_region', 'Index_controller::get_rx_by_region');
    
    $routes->post('get_rx_by_hq', 'Index_controller::get_rx_by_hq');
    
    $routes->get('get_data_by_data', 'Index_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Index_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Index_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Index_controller::get_rx_data_by_date');
    
    $routes->get('generate_excel_by_total_data', 'Index_controller::generate_excel_by_total_data');
    $routes->get('generate_excel_by_total_doctors', 'Index_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Index_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Index_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Index_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Index_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Index_controller::generate_excel_by_user_tbl');
 

});

$routes->group("zone", function ($routes) {  
    $routes->get('dashboard', 'Zone_controller::dashboard');
    
    $routes->get('user_tbl', 'Zone_controller::user_tbl');
    
    $routes->get('add_user', 'Zone_controller::add_user');
    
    $routes->post('user_insert', 'Zone_controller::user_insert');
    
    $routes->get('user_edit/(:num)', 'Zone_controller::user_edit/$1');
    
    $routes->post('user_update', 'Zone_controller::user_update');
    
    $routes->get('user_delete/(:num)', 'Zone_controller::user_delete/$1');
    
    $routes->get('profile', 'Zone_controller::admin_profile');
    
    
    
    $routes->get('user_delete/(:num)', 'Zone_controller::user_delete/$1');
    
    $routes->get('total_patients', 'Zone_controller::total_Patients');
    
    $routes->get('total_doctors', 'Zone_controller::total_Doctors');
    
    $routes->get('doctor_users_count', 'Zone_controller::doctor_users_count');
    
    $routes->get('patient_users_count', 'Zone_controller::patient_users_count');
    
    $routes->get('doctor_patients/(:num)', 'Zone_controller::doctor_patients/$1');
    
    $routes->get('total_rx', 'Zone_controller::total_rx');
    
     $routes->get('get_total_rx_data', 'Zone_controller::get_total_rx_data');
    
    $routes->post('get_user_by_region', 'Zone_controller::get_user_by_region');
    
    $routes->post('get_user_by_hq', 'Zone_controller::get_user_by_hq');
    
    
    
    $routes->post('get_hq_by_region', 'Zone_controller::get_hq_by_region');
    
    $routes->post('get_doctor_data_by_region', 'Zone_controller::get_doctor_data_by_region');
    
    $routes->post('get_doctor_data_by_hq', 'Zone_controller::get_doctor_data_by_hq');
    
    $routes->post('get_user_doctor_by_region', 'Zone_controller::get_user_doctor_by_region');
    
    $routes->post('get_user_doctor_by_hq', 'Zone_controller::get_user_doctor_by_hq');
    
    $routes->post('get_patient_data_by_region', 'Zone_controller::get_patient_data_by_region');
    
    $routes->post('get_patient_data_by_hq', 'Zone_controller::get_patient_data_by_hq');
    
    $routes->post('get_user_patient_by_region', 'Zone_controller::get_user_patient_by_region');
    
    $routes->post('get_user_patient_by_hq', 'Zone_controller::get_user_patient_by_hq');
    
    $routes->post('get_rx_by_region', 'Zone_controller::get_rx_by_region');
    
    $routes->post('get_rx_by_hq', 'Zone_controller::get_rx_by_hq');
    
    
    
    $routes->get('get_data_by_data', 'Zone_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Zone_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Zone_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Zone_controller::get_rx_data_by_date');
    
    $routes->get('generate_excel_by_total_data', 'Zone_controller::generate_excel_by_total_data');
    $routes->get('generate_excel_by_total_doctors', 'Zone_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Zone_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Zone_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Zone_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Zone_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Zone_controller::generate_excel_by_user_tbl');
    
});

$routes->group("rbm", function ($routes) {  
    
    $routes->get('dashboard', 'Regional_controller::r_dashboard');
    
    $routes->get('user_tbl', 'Regional_controller::r_user_tbl');
    
    $routes->get('add_user', 'Regional_controller::r_add_user');
    
    $routes->post('user_insert', 'Regional_controller::r_user_insert');
    
    $routes->get('user_edit/(:num)', 'Regional_controller::r_user_edit/$1');
    
    $routes->post('user_update', 'Regional_controller::r_user_update');
    
    $routes->get('user_delete/(:num)', 'Regional_controller::r_user_delete/$1');
    
    $routes->get('profile', 'Regional_controller::r_admin_profile');
    
    $routes->get('user_delete/(:num)', 'Regional_controller::r_user_delete/$1');
    
    
    
    $routes->get('total_doctors', 'Regional_controller::r_total_Doctors');
    
    $routes->get('total_patients', 'Regional_controller::r_total_Patients');
    
    $routes->get('doctor_users_count', 'Regional_controller::r_doctor_users_count');
    
    $routes->get('patient_users_count', 'Regional_controller::r_patient_users_count');
    
    $routes->get('doctor_patients/(:num)', 'Regional_controller::r_doctor_patients/$1');
    
    $routes->get('total_rx', 'Regional_controller::total_rx');
    
    
    
    $routes->post('get_user_by_hq', 'Regional_controller::get_user_by_hq');
    
    
    
    $routes->post('get_doctor_data_by_hq', 'Regional_controller::get_doctor_data_by_hq');
    
    $routes->post('get_user_doctor_by_hq', 'Regional_controller::get_user_doctor_by_hq');
    
    $routes->post('get_patient_data_by_hq', 'Regional_controller::get_patient_data_by_hq');
    
    $routes->post('get_user_patient_by_hq', 'Regional_controller::get_user_patient_by_hq');
    
    $routes->post('get_rx_by_hq', 'Regional_controller::get_rx_by_hq');
    
    
    $routes->get('get_data_by_data', 'Regional_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Regional_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Regional_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Regional_controller::get_rx_data_by_date');
    
    $routes->get('generate_excel_by_total_data', 'Regional_controller::generate_excel_by_total_data');
    $routes->get('generate_excel_by_total_doctors', 'Regional_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Regional_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Regional_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Regional_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Regional_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Regional_controller::generate_excel_by_user_tbl');
    
});

$routes->group("abm", function ($routes) { 
    $routes->get('dashboard', 'Area_controller::a_dashboard');

    $routes->get('user_tbl', 'Area_controller::a_user_tbl');
    
    $routes->get('add_user', 'Area_controller::a_add_user');
    
    $routes->post('user_insert', 'Area_controller::a_user_insert');
    
    $routes->get('user_edit/(:num)', 'Area_controller::a_user_edit/$1');
    
    $routes->post('user_update', 'Area_controller::a_user_update');
    
    $routes->get('user_delete/(:num)', 'Area_controller::a_user_delete/$1');
    
    $routes->get('profile', 'Area_controller::a_admin_profile');
    
    
    
    $routes->get('user_delete/(:num)', 'Area_controller::a_user_delete/$1');
    
    $routes->get('total_patients', 'Area_controller::a_total_Patients');
    
    $routes->get('total_doctors', 'Area_controller::a_total_Doctors');
    
    $routes->get('doctor_users_count', 'Area_controller::a_doctor_users_count');
    
    $routes->get('patient_users_count', 'Area_controller::a_patient_users_count');
    
    $routes->get('doctor_patients/(:num)', 'Area_controller::a_doctor_patients/$1');
    
    $routes->get('total_rx', 'Area_controller::total_rx');
    
    $routes->get('get_data_by_data', 'Area_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Area_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Area_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Area_controller::get_rx_data_by_date');

    $routes->get('generate_excel_by_total_doctors', 'Area_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Area_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Area_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Area_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Area_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Area_controller::generate_excel_by_user_tbl');
    
});


$routes->group("user", function ($routes) {  
    
    $routes->get('dashboard', 'Index_controller::u_dashboard');

    $routes->get('total_doctors', 'Index_controller::u_doctors');
    
    $routes->get('add_doctor', 'Index_controller::doctorform');
    
    $routes->post('check_phone_exists', 'Index_controller::check_phone_exists');
    
    $routes->post('doctor_data', 'Index_controller::dr_data');
    
    $routes->get('doctor_edit/(:num)', 'Index_controller::doctoredit/$1');
    
    $routes->post('check_phone_and_id_exists', 'Index_controller::check_phone_and_id_exists');
    
    $routes->post('doctor_update', 'Index_controller::dr_update');
    
    
    
    $routes->get('total_patients', 'Index_controller::u_patients');
    
    $routes->get('add_patient/(:num)', 'Index_controller::addpatients/$1');
    
    $routes->get('suggest_patients', 'User::suggest_patients');
    
    $routes->post('patient_data', 'Index_controller::patient_data');
    
    
    
    $routes->get('rx_information', 'Index_controller::rx_information');
    
    $routes->get('add_rx', 'Index_controller::addrx');
    
    $routes->post('rx_data', 'Index_controller::rx_data');
    
    $routes->get('total_rx', 'Index_controller::u_rx');
    
    
    
    $routes->get('profile', 'Index_controller::u_profile');
    
    $routes->get('profile_edit', 'Index_controller::u_profile_edit');
    
    $routes->post('profile_update', 'Index_controller::u_profile_update');

});


$routes->get('PrivacyPolicy', 'Index_controller::privacy_policy');


$routes->group("api", function ($routes) {

    $routes->post("login", "Login::index");

    $routes->post("forget", "Login::forget");
    $routes->post("createAccount", "Login::createAccount");
    


    $routes->group("doctor", function ($routes) { 

        $routes->get("/", "Doctor::list", ["filter" => 'authFilter']);

        $routes->get("count", "Users::doctorCount", ["filter" => 'authFilter']);

        $routes->get("code/(:any)", "Doctor::code/$1", ["filter" => 'authFilter']);

        $routes->get("(:num)", "Doctor::show/$1", ["filter" => 'authFilter']);

        $routes->post("/", "Doctor::create", ["filter" => 'authFilter']);

        $routes->put("(:num)", "Doctor::update/$1", ["filter" => 'authFilter']);

        $routes->delete("delete/(:num)", "Doctor::delete/$1", ["filter" => 'authFilter']);  

        $routes->get("dashboard", "Doctor::dashboard", ["filter" => 'authFilter']);

    });

    $routes->group("user", function ($routes) {  

        $routes->post("edit/(:num)", "Users::editUser/$1", ["filter" => 'authFilter']);
        $routes->get("delete", "Users::delateUser", ["filter" => 'authFilter']);

        $routes->post("synchData/(:num)", "Users::synchData/$1", ["filter" => 'authFilter']);

        $routes->get("/", "Users::list", ["filter" => 'authFilter']);
        
  

        $routes->get("me", "Users::myProfile", ["filter" => 'authFilter']);
        
        $routes->get("HQ", "Users::myHQ", ["filter" => 'authFilter']);
        $routes->get("Region", "Users::myRegion", ["filter" => 'authFilter']);
        $routes->get("Zone", "Users::myZone", ["filter" => 'authFilter']);

        $routes->get("(:num)", "Users::show/$1", ["filter" => 'authFilter']);
        
        $routes->post("employee", "Users::savaEmployee", ["filter" => 'authFilter']);

        $routes->post("/", "Users::create", ["filter" => 'authFilter']);

        $routes->put("(:num)", "Users::update/$1", ["filter" => 'authFilter']);

        $routes->delete("delete/(:num)", "Users::delete/$1", ["filter" => 'authFilter']); 

        $routes->get("patientCount", "Users::patientCount", ["filter" => 'authFilter']);

        $routes->get("patientRx/count", "Users::patientRx", ["filter" => 'authFilter']);
        
        $routes->get("patientsByDoctor/(:num)", "Users::patientByDoctor/$1", ["filter" => 'authFilter']);

        $routes->get("patients", "Users::patient", ["filter" => 'authFilter']);
        
        $routes->get("findPatients", "Users::findPatients", ["filter" => 'authFilter']);

        $routes->get("patientsRx", "Users::patientRx", ["filter" => 'authFilter']);

        $routes->post("patients", "Users::savePatient", ["filter" => 'authFilter']);
        
        $routes->post("patients/(:num)", "Users::updatePatient/$1", ["filter" => 'authFilter']);

        $routes->post("patientRx", "Users::savePatientRx", ["filter" => 'authFilter']);
        
        $routes->get("doctorTotal", "Users::getDoctorTotal", ["filter" => 'authFilter']);
        
        $routes->post("uploadimg", "Users::uploadimg", ["filter" => 'authFilter']);

    });

});





/*

 * --------------------------------------------------------------------

 * Additional Routing

 * --------------------------------------------------------------------

 *

 * There will often be times that you need additional routing and you

 * need it to be able to override any defaults in this file. Environment

 * based routes is one such time. require() additional route files here

 * to make that happen.

 *

 * You will have access to the $routes object within that file without

 * needing to reload it.

 */

if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {

    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';

}

