<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();
$routes->setAutoRoute(true);


/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Index_controller');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
 
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF chapters_indion are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.



//*-------------- Admin User --------------*//

// $routes->get('/', 'Home::index');
$routes->get('/index', 'Index_controller::index');
$routes->post('/login', 'Index_controller::login');
$routes->get('/logout', 'Index_controller::logout');
$routes->get('/admin', 'Index_controller::index');
$routes->get('/admin/index', 'Index_controller::index');
$routes->get('/admin/forgot', 'Index_controller::forgot');
$routes->post('/admin/forgot_hndl', 'Index_controller::forgot_hndl');
$routes->get('/admin/profile', 'Index_controller::admin_profile');
$routes->get('/admin/profile_edit/(:num)', 'Index_controller::profile_edit/$1');

$routes->get('/admin/dashboard', 'Index_controller::dashboard');
$routes->get('/admin/user_tbl', 'Index_controller::user_tbl');
$routes->post('/admin/get_user_by_zone', 'Index_controller::get_user_by_zone');
$routes->post('admin/get_user_by_region', 'Index_controller::get_user_by_region');
$routes->post('admin/get_user_by_hq', 'Index_controller::get_user_by_hq');
$routes->get('/admin/add_user', 'Index_controller::add_user');
$routes->post('/admin/user_insert', 'Index_controller::user_insert');
$routes->get('/admin/user_edit/(:num)', 'Index_controller::user_edit/$1');
$routes->post('/admin/user_update', 'Index_controller::user_update');
$routes->get('/admin/user_delete/(:num)', 'Index_controller::user_delete/$1');
$routes->get('/admin/total_data', 'Index_controller::total_Data');
$routes->post('/admin/get_total_data_by_zone', 'Index_controller::get_total_data_by_zone');
$routes->post('/admin/get_total_data_by_region', 'Index_controller::get_total_data_by_region');
$routes->post('/admin/get_total_data_by_hq', 'Index_controller::get_total_data_by_hq');
$routes->get('/admin/total_doctors', 'Index_controller::total_Doctors');
$routes->get('/admin/total_patients', 'Index_controller::total_Patients');
$routes->get('/admin/total_rx', 'Index_controller::total_rx');
$routes->get('/admin/doctor_users_count', 'Index_controller::doctor_users_count');
$routes->get('/admin/patient_users_count', 'Index_controller::patient_users_count');
$routes->get('/admin/doctor_patients/(:num)', 'Index_controller::doctor_patients/$1');
$routes->post('/admin/get_regions_by_zone', 'Index_controller::get_regions_by_zone');
$routes->post('/admin/get_hq_by_region', 'Index_controller::get_hq_by_region');
$routes->post('/admin/get_doctor_data_by_zone', 'Index_controller::get_doctor_data_by_zone');
$routes->post('/admin/get_doctor_data_by_region', 'Index_controller::get_doctor_data_by_region');
$routes->post('/admin/get_doctor_data_by_hq', 'Index_controller::get_doctor_data_by_hq');
$routes->post('/admin/get_user_doctor_by_zone', 'Index_controller::get_user_doctor_by_zone');
$routes->post('/admin/get_user_doctor_by_region', 'Index_controller::get_user_doctor_by_region');
$routes->post('/admin/get_user_doctor_by_hq', 'Index_controller::get_user_doctor_by_hq');
$routes->post('/admin/get_patient_data_by_zone', 'Index_controller::get_patient_data_by_zone');
$routes->post('/admin/get_patient_data_by_region', 'Index_controller::get_patient_data_by_region');
$routes->post('/admin/get_patient_data_by_hq', 'Index_controller::get_patient_data_by_hq');
$routes->post('/admin/get_user_patient_by_zone', 'Index_controller::get_user_patient_by_zone');
$routes->post('/admin/get_user_patient_by_region', 'Index_controller::get_user_patient_by_region');
$routes->post('/admin/get_user_patient_by_hq', 'Index_controller::get_user_patient_by_hq');
$routes->post('/admin/get_rx_by_zone', 'Index_controller::get_rx_by_zone');
$routes->post('/admin/get_rx_by_region', 'Index_controller::get_rx_by_region');
$routes->post('/admin/get_rx_by_hq', 'Index_controller::get_rx_by_hq');

$routes->get('/admin/total_poster', 'Index_controller::total_poster');
$routes->get('/admin/birthday_tbl', 'Index_controller::birthday_tbl');
$routes->get('/admin/anniversary_tbl', 'Index_controller::anniversary_tbl');
$routes->get('/admin/brandreminder_tbl', 'Index_controller::brandreminder_tbl');
$routes->get('/admin/thankyou_tbl', 'Index_controller::thankyou_tbl');

$routes->get('/admin/total_videos', 'Index_controller::total_videos');
$routes->get('/admin/total_birthday_videos', 'Index_controller::total_birthday_videos');
$routes->get('/admin/total_anniversary_videos', 'Index_controller::total_anniversary_videos');

$routes->get('/admin/users_count', 'Index_controller::users_count');
$routes->get('/admin/users_date_count', 'Index_controller::users_date_count');

$routes->get('/admin/brands_form', 'Index_controller::brands_form');
$routes->get('/admin/brands_table', 'Index_controller::brands_table');
$routes->post('/admin/brands_insert', 'Index_controller::brands_insert');
$routes->get('/admin/brands_edit/(:num)', 'Index_controller::brands_edit/$1');
$routes->post('/admin/brands_update', 'Index_controller::brands_update');
$routes->get('/admin/brands_delete/(:num)', 'Index_controller::brands_delete/$1');

$routes->get('/admin/campaign_form', 'Index_controller::campaign_form');
$routes->get('/admin/campaign_table', 'Index_controller::campaign_table');
$routes->post('/admin/campaign_insert', 'Index_controller::campaign_insert');
$routes->get('/admin/campaign_edit/(:num)', 'Index_controller::campaign_edit/$1');
$routes->post('/admin/campaign_update', 'Index_controller::campaign_update');
$routes->get('/admin/campaign_delete/(:num)', 'Index_controller::campaign_delete/$1');

$routes->get('/admin/language_form', 'Index_controller::language_form');
$routes->get('/admin/language_table', 'Index_controller::language_table');
$routes->post('/admin/language_insert', 'Index_controller::language_insert');
$routes->get('/admin/language_edit/(:num)', 'Index_controller::language_edit/$1');
$routes->post('/admin/language_update', 'Index_controller::language_update');
$routes->get('/admin/language_delete/(:num)', 'Index_controller::language_delete/$1');

$routes->get('/admin/frame_form', 'Index_controller::frame_form');
$routes->get('/admin/frame_table', 'Index_controller::frame_table');
$routes->post('/admin/frame_insert', 'Index_controller::frame_insert');
$routes->get('/admin/frame_edit/(:num)', 'Index_controller::frame_edit/$1');
$routes->post('/admin/frame_update', 'Index_controller::frame_update');
$routes->get('/admin/frame_delete/(:num)', 'Index_controller::frame_delete/$1');

$routes->get('/admin/birthday_frame_form', 'Index_controller::birthday_frame_form');
$routes->get('/admin/birthday_frame_table', 'Index_controller::birthday_frame_table');
$routes->post('/admin/birthday_frame_insert', 'Index_controller::birthday_frame_insert');
$routes->get('/admin/birthday_frame_edit/(:num)', 'Index_controller::birthday_frame_edit/$1');
$routes->post('/admin/birthday_frame_update', 'Index_controller::birthday_frame_update');
$routes->get('/admin/birthday_frame_delete/(:num)', 'Index_controller::birthday_frame_delete/$1');

$routes->get('/admin/anniversary_frame_form', 'Index_controller::anniversary_frame_form');
$routes->get('/admin/anniversary_frame_table', 'Index_controller::anniversary_frame_table');
$routes->post('/admin/anniversary_frame_insert', 'Index_controller::anniversary_frame_insert');
$routes->get('/admin/anniversary_frame_edit/(:num)', 'Index_controller::anniversary_frame_edit/$1');
$routes->post('/admin/anniversary_frame_update', 'Index_controller::anniversary_frame_update');
$routes->get('/admin/anniversary_frame_delete/(:num)', 'Index_controller::anniversary_frame_delete/$1');

$routes->get('/admin/brandreminder_frame_form', 'Index_controller::brandreminder_frame_form');
$routes->get('/admin/brandreminder_frame_table', 'Index_controller::brandreminder_frame_table');
$routes->post('/admin/brandreminder_frame_insert', 'Index_controller::brandreminder_frame_insert');
$routes->get('/admin/brandreminder_frame_edit/(:num)', 'Index_controller::brandreminder_frame_edit/$1');
$routes->post('/admin/brandreminder_frame_update', 'Index_controller::brandreminder_frame_update');
$routes->get('/admin/brandreminder_frame_delete/(:num)', 'Index_controller::brandreminder_frame_delete/$1');

$routes->get('/admin/thankyou_frame_form', 'Index_controller::thankyou_frame_form');
$routes->get('/admin/thankyou_frame_table', 'Index_controller::thankyou_frame_table');
$routes->post('/admin/thankyou_frame_insert', 'Index_controller::thankyou_frame_insert');
$routes->get('/admin/thankyou_frame_edit/(:num)', 'Index_controller::thankyou_frame_edit/$1');
$routes->post('/admin/thankyou_frame_update', 'Index_controller::thankyou_frame_update');
$routes->get('/admin/thankyou_frame_delete/(:num)', 'Index_controller::thankyou_frame_delete/$1');


$routes->get('/admin/birthday_video_frame_form', 'Index_controller::birthday_video_frame_form');
$routes->get('/admin/birthday_video_frame_table', 'Index_controller::birthday_video_frame_table');
$routes->post('/admin/birthday_video_frame_insert', 'Index_controller::birthday_video_frame_insert');
$routes->get('/admin/birthday_video_frame_edit/(:num)', 'Index_controller::birthday_video_frame_edit/$1');
$routes->post('/admin/birthday_video_frame_update', 'Index_controller::birthday_video_frame_update');
$routes->get('/admin/birthday_video_frame_delete/(:num)', 'Index_controller::birthday_video_frame_delete/$1');

$routes->get('/admin/anniversary_video_frame_form', 'Index_controller::anniversary_video_frame_form');
$routes->get('/admin/anniversary_video_frame_table', 'Index_controller::anniversary_video_frame_table');
$routes->post('/admin/anniversary_video_frame_insert', 'Index_controller::anniversary_video_frame_insert');
$routes->get('/admin/anniversary_video_frame_edit/(:num)', 'Index_controller::anniversary_video_frame_edit/$1');
$routes->post('/admin/anniversary_video_frame_update', 'Index_controller::anniversary_video_frame_update');
$routes->get('/admin/anniversary_video_frame_delete/(:num)', 'Index_controller::anniversary_video_frame_delete/$1');

$routes->get('/zone/dashboard', 'Zone_controller::dashboard');
$routes->get('/zone/user_tbl', 'Zone_controller::user_tbl');
$routes->get('/zone/add_user', 'Zone_controller::add_user');
$routes->post('/zone/user_insert', 'Zone_controller::user_insert');
$routes->get('/zone/user_edit/(:num)', 'Zone_controller::user_edit/$1');
$routes->post('/zone/user_update', 'Zone_controller::user_update');
$routes->get('/zone/user_delete/(:num)', 'Zone_controller::user_delete/$1');
$routes->get('/zone/profile', 'Zone_controller::admin_profile');

$routes->get('/zone/user_delete/(:num)', 'Zone_controller::user_delete/$1');
$routes->get('/zone/total_patients', 'Zone_controller::total_Patients');
$routes->get('/zone/total_doctors', 'Zone_controller::total_Doctors');
$routes->get('/zone/doctor_users_count', 'Zone_controller::doctor_users_count');
$routes->get('/zone/patient_users_count', 'Zone_controller::patient_users_count');
$routes->get('/zone/doctor_patients/(:num)', 'Zone_controller::doctor_patients/$1');
$routes->get('/zone/total_rx', 'Zone_controller::total_rx');

$routes->post('zone/get_user_by_region', 'Zone_controller::get_user_by_region');
$routes->post('zone/get_user_by_hq', 'Zone_controller::get_user_by_hq');

$routes->post('/zone/get_hq_by_region', 'Zone_controller::get_hq_by_region');
$routes->post('/zone/get_doctor_data_by_region', 'Zone_controller::get_doctor_data_by_region');
$routes->post('/zone/get_doctor_data_by_hq', 'Zone_controller::get_doctor_data_by_hq');
$routes->post('/zone/get_user_doctor_by_region', 'Zone_controller::get_user_doctor_by_region');
$routes->post('/zone/get_user_doctor_by_hq', 'Zone_controller::get_user_doctor_by_hq');
$routes->post('/zone/get_patient_data_by_region', 'Zone_controller::get_patient_data_by_region');
$routes->post('/zone/get_patient_data_by_hq', 'Zone_controller::get_patient_data_by_hq');
$routes->post('/zone/get_user_patient_by_region', 'Zone_controller::get_user_patient_by_region');
$routes->post('/zone/get_user_patient_by_hq', 'Zone_controller::get_user_patient_by_hq');
$routes->post('/zone/get_rx_by_region', 'Zone_controller::get_rx_by_region');
$routes->post('/zone/get_rx_by_hq', 'Zone_controller::get_rx_by_hq');

$routes->get('/zone/total_poster', 'Zone_controller::z_totel_poster');
$routes->get('/zone/total_videos', 'Zone_controller::z_totel_videos');
$routes->get('/zone/users_count', 'Zone_controller::z_users_count');
$routes->get('/zone/users_date_count', 'Zone_controller::z_users_date_count');

$routes->get('/zone/poster_maker/(:num)', 'Zone_controller::poster_maker/$1');
$routes->post('/zone/add_poster', 'Zone_controller::add_poster');
$routes->post('/zone/poster_download_status', 'Zone_controller::poster_download_status');
$routes->post('/zone/poster_share_status', 'Zone_controller::poster_share_status');

$routes->get('/zone/video_maker', 'Zone_controller::video_maker');
$routes->post('/zone/add_video', 'Zone_controller::add_video');
$routes->post('/zone/video_download_status', 'Zone_controller::video_download_status');
$routes->post('/zone/video_share_status', 'Zone_controller::video_share_status');

$routes->get('/rbm/dashboard', 'Regional_controller::r_dashboard');
$routes->get('/rbm/user_tbl', 'Regional_controller::r_user_tbl');
$routes->get('/rbm/add_user', 'Regional_controller::r_add_user');
$routes->post('/rbm/user_insert', 'Regional_controller::r_user_insert');
$routes->get('/rbm/user_edit/(:num)', 'Regional_controller::r_user_edit/$1');
$routes->post('/rbm/user_update', 'Regional_controller::r_user_update');
$routes->get('/rbm/user_delete/(:num)', 'Regional_controller::r_user_delete/$1');
$routes->get('/rbm/profile', 'Regional_controller::r_admin_profile');
$routes->get('/rbm/user_delete/(:num)', 'Regional_controller::r_user_delete/$1');
$routes->get('/rbm/total_doctors', 'Regional_controller::r_total_Doctors');
$routes->get('/rbm/total_patients', 'Regional_controller::r_total_Patients');
$routes->get('/rbm/doctor_users_count', 'Regional_controller::r_doctor_users_count');
$routes->get('/rbm/patient_users_count', 'Regional_controller::r_patient_users_count');
$routes->get('/rbm/doctor_patients/(:num)', 'Regional_controller::r_doctor_patients/$1');
$routes->get('/rbm/total_rx', 'Regional_controller::total_rx');

$routes->post('rbm/get_user_by_hq', 'Regional_controller::get_user_by_hq');

$routes->post('/rbm/get_doctor_data_by_hq', 'Regional_controller::get_doctor_data_by_hq');
$routes->post('/rbm/get_user_doctor_by_hq', 'Regional_controller::get_user_doctor_by_hq');
$routes->post('/rbm/get_patient_data_by_hq', 'Regional_controller::get_patient_data_by_hq');
$routes->post('/rbm/get_user_patient_by_hq', 'Regional_controller::get_user_patient_by_hq');
$routes->post('/rbm/get_rx_by_hq', 'Regional_controller::get_rx_by_hq');


$routes->get('/rbm/total_poster', 'Regional_controller::r_totel_poster');
$routes->get('/rbm/total_videos', 'Regional_controller::r_totel_videos');
$routes->get('/rbm/users_count', 'Regional_controller::r_users_count');
$routes->get('/rbm/users_date_count', 'Regional_controller::r_users_date_count');

$routes->get('/rbm/poster_maker/(:num)', 'Regional_controller::poster_maker/$1');
$routes->post('/rbm/add_poster', 'Regional_controller::add_poster');
$routes->post('/rbm/poster_download_status', 'Regional_controller::poster_download_status');
$routes->post('/rbm/poster_share_status', 'Regional_controller::poster_share_status');

$routes->get('/rbm/video_maker', 'Regional_controller::video_maker');
$routes->post('/rbm/add_video', 'Regional_controller::add_video');
$routes->post('/rbm/video_download_status', 'Regional_controller::video_download_status');
$routes->post('/rbm/video_share_status', 'Regional_controller::video_share_status');



$routes->get('/abm/dashboard', 'Area_controller::a_dashboard');
$routes->get('/abm/user_tbl', 'Area_controller::a_user_tbl');
$routes->get('/abm/add_user', 'Area_controller::a_add_user');
$routes->post('/abm/user_insert', 'Area_controller::a_user_insert');
$routes->get('/abm/user_edit/(:num)', 'Area_controller::a_user_edit/$1');
$routes->post('/abm/user_update', 'Area_controller::a_user_update');
$routes->get('/abm/user_delete/(:num)', 'Area_controller::a_user_delete/$1');
$routes->get('/abm/profile', 'Area_controller::a_admin_profile');

$routes->get('/abm/user_delete/(:num)', 'Area_controller::a_user_delete/$1');
$routes->get('/abm/total_patients', 'Area_controller::a_total_Patients');
$routes->get('/abm/total_doctors', 'Area_controller::a_total_Doctors');
$routes->get('/abm/doctor_users_count', 'Area_controller::a_doctor_users_count');
$routes->get('/abm/patient_users_count', 'Area_controller::a_patient_users_count');
$routes->get('/abm/doctor_patients/(:num)', 'Area_controller::a_doctor_patients/$1');
$routes->get('/abm/total_rx', 'Area_controller::total_rx');

$routes->get('/abm/total_poster', 'Area_controller::a_totel_poster');
$routes->get('/abm/total_videos', 'Area_controller::a_totel_videos');
$routes->get('/abm/users_count', 'Area_controller::a_users_count');
$routes->get('/abm/users_date_count', 'Area_controller::a_users_date_count');

$routes->get('/abm/poster_maker/(:num)', 'Area_controller::poster_maker/$1');
$routes->post('/abm/add_poster', 'Area_controller::add_poster');
$routes->post('/abm/poster_download_status', 'Area_controller::poster_download_status');
$routes->post('/abm/poster_share_status', 'Area_controller::poster_share_status');

$routes->get('/abm/video_maker', 'Area_controller::video_maker');
$routes->post('/abm/add_video', 'Area_controller::add_video');
$routes->post('/abm/video_download_status', 'Area_controller::video_download_status');
$routes->post('/abm/video_share_status', 'Area_controller::video_share_status');


$routes->get('/user/dashboard', 'Index_controller::u_dashboard');
$routes->get('/user/data_dashboard', 'Index_controller::data_dashboard');
$routes->get('/user/total_doctors', 'Index_controller::u_doctors');
$routes->get('/user/add_doctor', 'Index_controller::doctorform');
$routes->post('/user/check_phone_exists', 'Index_controller::check_phone_exists');
$routes->post('/user/doctor_data', 'Index_controller::dr_data');
$routes->get('/user/doctor_edit/(:num)', 'Index_controller::doctoredit/$1');
$routes->post('user/check_phone_and_id_exists', 'Index_controller::check_phone_and_id_exists');
$routes->post('/user/doctor_update', 'Index_controller::dr_update');

$routes->get('/user/total_patients', 'Index_controller::u_patients');
$routes->get('/user/add_patient/(:num)', 'Index_controller::addpatients/$1');
$routes->get('user/suggest_patients', 'User::suggest_patients');
$routes->post('/user/patient_data', 'Index_controller::patient_data');

$routes->get('/user/rx_information', 'Index_controller::rx_information');
$routes->get('/user/add_rx/', 'Index_controller::addrx');
$routes->post('/user/rx_data', 'Index_controller::rx_data');
$routes->get('/user/total_rx', 'Index_controller::u_rx');

$routes->get('/user/profile', 'Index_controller::u_profile');
$routes->get('/user/profile_edit/', 'Index_controller::u_profile_edit');
$routes->post('/user/profile_update', 'Index_controller::u_profile_update');

$routes->get('/user/posters', 'Index_controller::u_select_poster');
$routes->get('user/get_campaigns_by_language/(:num)', 'Index_controller::get_campaigns_by_language/$1');
$routes->get('/user/poster_maker/(:num)', 'Index_controller::poster_maker/$1');
$routes->post('/user/add_poster', 'Index_controller::add_poster');
$routes->post('/user/poster_download_status', 'Index_controller::poster_download_status');
$routes->post('/user/poster_share_status', 'Index_controller::poster_share_status');
$routes->get('/user/poster_table', 'Index_controller::poster_tbl');

$routes->get('/user/birthday_posters', 'Index_controller::birthday_posters');
$routes->get('/user/birthday_poster_maker/(:num)', 'Index_controller::birthday_poster_maker/$1');
$routes->post('/user/add_birthday_poster', 'Index_controller::add_birthday_poster');
$routes->post('/user/birthday_poster_download_status', 'Index_controller::birthday_poster_download_status');
$routes->post('/user/birthday_poster_share_status', 'Index_controller::birthday_poster_share_status');
$routes->get('/user/birthday_poster_table', 'Index_controller::birthday_poster_tbl');

$routes->get('/user/anniversary_posters', 'Index_controller::anniversary_posters');
$routes->get('/user/anniversary_poster_maker/(:num)', 'Index_controller::anniversary_poster_maker/$1');
$routes->post('/user/add_anniversary_poster', 'Index_controller::add_anniversary_poster');
$routes->post('/user/anniversary_poster_download_status', 'Index_controller::anniversary_poster_download_status');
$routes->post('/user/anniversary_poster_share_status', 'Index_controller::anniversary_poster_share_status');
$routes->get('/user/anniversary_poster_table', 'Index_controller::anniversary_poster_tbl');

$routes->get('/user/brandreminder_posters', 'Index_controller::brandreminder_posters');
$routes->get('/user/brandreminder_poster_maker/(:num)', 'Index_controller::brandreminder_poster_maker/$1');
$routes->post('/user/add_brandreminder_poster', 'Index_controller::add_brandreminder_poster');
$routes->post('/user/brandreminder_poster_download_status', 'Index_controller::brandreminder_poster_download_status');
$routes->post('/user/brandreminder_poster_share_status', 'Index_controller::brandreminder_poster_share_status');
$routes->get('/user/brandreminder_poster_table', 'Index_controller::brandreminder_poster_tbl');

$routes->get('/user/thankyou_posters', 'Index_controller::thankyou_posters');
$routes->get('/user/thankyou_poster_maker/(:num)', 'Index_controller::thankyou_poster_maker/$1');
$routes->post('/user/add_thankyou_poster', 'Index_controller::add_thankyou_poster');
$routes->post('/user/thankyou_poster_download_status', 'Index_controller::thankyou_poster_download_status');
$routes->post('/user/thankyou_poster_share_status', 'Index_controller::thankyou_poster_share_status');
$routes->get('/user/thankyou_poster_table', 'Index_controller::thankyou_poster_tbl');

$routes->get('/user/video_type_selection', 'Index_controller::video_type_selection');

$routes->get('/user/video_maker', 'Index_controller::video_maker');
$routes->post('/user/add_video', 'Index_controller::add_video');
$routes->post('/user/video_download_status', 'Index_controller::video_download_status');
$routes->post('/user/video_share_status', 'Index_controller::video_share_status');
$routes->get('/user/video_table', 'Index_controller::video_tbl');

$routes->get('/user/birthday_video', 'Index_controller::birthday_video');
$routes->get('/user/birthday_video_maker/(:num)', 'Index_controller::birthday_video_maker/$1');
$routes->post('/user/add_birthday_video', 'Index_controller::add_birthday_video');
$routes->post('/user/birthday_video_download_status', 'Index_controller::birthday_video_download_status');
$routes->post('/user/birthday_video_share_status', 'Index_controller::birthday_video_share_status');
$routes->get('/user/birthday_video_table', 'Index_controller::birthday_video_tbl');

$routes->get('/user/anniversary_video', 'Index_controller::anniversary_video');
$routes->get('/user/anniversary_video_maker/(:num)', 'Index_controller::anniversary_video_maker/$1');
$routes->post('/user/add_anniversary_video', 'Index_controller::add_anniversary_video');
$routes->post('/user/anniversary_video_download_status', 'Index_controller::anniversary_video_download_status');
$routes->post('/user/anniversary_video_share_status', 'Index_controller::anniversary_video_share_status');
$routes->get('/user/anniversary_video_table', 'Index_controller::anniversary_video_tbl');

$routes->group("api", function ($routes) {
    $routes->post("login", "Login::index");
    $routes->post("forget", "Login::forget");
    $routes->group("doctor", function ($routes) { 
        $routes->get("/", "Doctor::list", ["filter" => 'authFilter']);
        $routes->get("code/(:any)", "Doctor::code/$1", ["filter" => 'authFilter']);
        $routes->get("(:num)", "Doctor::show/$1", ["filter" => 'authFilter']);
        $routes->post("/", "Doctor::create", ["filter" => 'authFilter']);
        $routes->put("(:num)", "Doctor::update/$1", ["filter" => 'authFilter']);
        $routes->delete("delete/(:num)", "Doctor::delete/$1", ["filter" => 'authFilter']);  
    });
    $routes->group("user", function ($routes) {  
        $routes->get("/", "Users::list", ["filter" => 'authFilter']);
        $routes->get("me", "Users::myProfile", ["filter" => 'authFilter']);
        $routes->get("(:num)", "Users::show/$1", ["filter" => 'authFilter']);
        $routes->post("/", "Users::create", ["filter" => 'authFilter']);
        $routes->put("(:num)", "Users::update/$1", ["filter" => 'authFilter']);
        $routes->delete("delete/(:num)", "Users::delete/$1", ["filter" => 'authFilter']); 
        $routes->get("patient", "Users::patient", ["filter" => 'authFilter']);
        $routes->get("patientRx", "Users::patientRx", ["filter" => 'authFilter']);
        $routes->post("patient", "Users::savePatient", ["filter" => 'authFilter']);
        $routes->post("patientRx", "Users::savePatientRx", ["filter" => 'authFilter']);
    });
});


/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
