<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Area_controller extends BaseController
{
  
    public function a_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $patient = new Patient_Model;
            $rx = new Rx_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }
            $hq = $hq_id;
            $data = [
                'totalUsers' => $user->where('HQ', $hq)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->countAllResults(),
                'totalDoctors' => $doctor->where('hq_id', $hq_id)->countAllResults(),
                'totalPatients' => $patient->where('hq_id', $hq_id)->countAllResults(),
                'totalrx' => $rx->where('hq_id', $hq_id)->countAllResults(),
                'controller' => 'abm'
            ];
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['userType'] = $session->get('userType');
            
            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function a_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data ['page'] = (int)($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data ['perPage'] = 20;
                // Get total number of items
                $data ['total'] = $user->where('tbl_user.HQ', $hq_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->countAllResults();
            
                $user_array = $user->where('tbl_user.HQ', $hq_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUser(20,$data["page"]);
                $data['data'] = $user_array;

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'abm';

                $data['userType'] = $session->get('userType');
                return view('admin/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function a_total_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int)($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data['total'] = $doctor->where('doctor_data.hq_id', $row['HQ'])->countAllResults();
            
                $data['data'] = $doctor->getTotalDoctor($data['perPage'],$data['page'],0,0,$row['HQ']);

                $data['Name'] = $user->where('UserID', $id)->first();

                $data['controller'] = 'abm';
                $data['userType'] = $session->get('userType');

                return view('admin/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function a_total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int)($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data['total'] = $patient->where('patient_data.hq_id', $hq_id)->countAllResults();
            
                $data['data'] = $patient->getTotalPatients($data['perPage'],$data['page'],0,0,$hq_id);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'abm';
                $data['userType'] = $session->get('userType');
                return view('admin/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function total_rx(){
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;

            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            foreach ($row as $zrow) {
                $hq_id = $zrow['HQ'];
            }

            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $rx->where('rx_data.hq_id', $hq_id)->countAllResults();
            
            $data['data'] = $rx->getTotalPatientsrx($data['perPage'],$data['page'],0,0,$hq_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');
            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }
            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $doctor->where('hq_id', $hq_id)->countAllResults();
            
            $data['data'] = $doctor->gettotalDoctorEentry($data['perPage'],$data["page"],0,0,$hq_id);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $patient->where('hq_id', $hq_id)->countAllResults();
            
            $data['data'] = $patient->gettotalPatientEentry($data['perPage'],$data["page"],0,0,$hq_id);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['userType'] = $session->get('userType');
            return view('admin/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');
            return view('admin/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }
    
    public function a_add_user()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['data'] = $user->where('UserID', $id)->getRecords();


                $data['Name'] = $user->where('UserID', $id)->first();

                return view('abm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function a_user_insert()
    {
        $user_insert = new User_Model;

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => 'BO',
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
        ];
        $user_insert->save($data);
        return redirect()->to('abm/add_user');
    }

    public function a_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $data['Name'] = $user->where('UserID', $id)->first();

        return view('abm/user_edit', $data);
    }

    public function a_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'DESIG' => $this->request->getVar('desig'),
            'pass' => 'telminorm',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('abm/user_tbl');
    }

    public function a_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('abm/user_tbl');
    }

    public function get_doctor_data_by_date()
    {
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $doctor = new Doctor_Model();

        $hq_id = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $doctor = new Doctor_Model();
        $table_data = $doctor->getTotalDoctor($pagesize,$page,0,0,$hq_id,$startDate,$endDate,$searchText);

        $total = count($doctor->getTotalDoctor(0,0,0,0,$hq_id,$startDate,$endDate,$searchText));
 
        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }

    public function get_patient_data_by_date()
    {
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
        
       $hq_id = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $patient = new Patient_Model();
        $table_data = $patient->getTotalPatients($pagesize,$page,0,0,$hq_id,$startDate,$endDate,$searchText);
        
        $total = count($patient->getTotalPatients(0,0,0,0,$hq_id,$startDate,$endDate,$searchText));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }

    public function get_rx_data_by_date()
    {
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
        
        $hq_id = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $rx = new Rx_Model();
        $table_data = $rx->getTotalPatientsrx($pagesize,$page,0,0,$hq_id,$startDate,$endDate,$searchText);
        
        $total = count($rx->getTotalPatientsrx(0,0,0,0,$hq_id,$startDate,$endDate,$searchText));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }
  

    public function generate_excel_by_total_doctors()
    {
        try {
    
            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $doctor = new Doctor_Model();
    
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            
            
    
            $data = $doctor->getTotalDoctor(0,0,0,0,$hq,$startDate,$endDate);
    
            // CSV Header
            $header = ['Doctor Name', 'Cln./Hosp. Name', 'SBU Code', 'Phone','E-mail','Place','District','State','Country','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalDoctors.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['doctor'], $row['hospital'], $row['registration_no'], $row['phone'], $row['email'], $row['place'], $row['district'], $row['state'], $row['country'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
        
            // Close the output stream
            fclose($file);
        
            exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_total_patients()
    {
        try {
            
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
        
        $patient = new Patient_Model();

        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];

        $data = $patient->getTotalPatients(0,0,0,0,$hq,$startDate,$endDate);
          
        // CSV Header
        $header = ['Doctor', 'Name', 'Phone', 'Place','Gender','Age','Examination Date','Hypertension','Hypertension Drugs','Drugs Combination','ARB Prescription','ARB Dose','ACE-I Prescription','ACE-I Dose','BB Prescription','BB Dose','CCB Prescription','CCB Dose','Diuretic Prescription','Diuretic Dose','Other Prescription','Other Dose','SBP','DBP','Average SBP','Average DBP','Co-morbid Condition','Drugs for co-morbidity','Date','Employee','Emp. ID','Area','Region','Zone'];

        // Create a file pointer connected to the output stream
        $file = fopen('php://output', 'w');

        // Set headers to prompt download
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename="TotalPatient.csv"');

        // Output the header
         fputcsv($file, $header);
     

        //print_r(count($data));
        // Output each row of the data
        foreach ($data as $row) {
            fputcsv($file, [$row['doctor'], $row['name'], $row['phone'], $row['place'], $row['gender'], $row['age'], $row['examination'], $row['hypertension'], $row['hypertension_drugs'], 
                                            $row['drugs_combination'], $row['arb'], $row['arb_dose'], $row['ace_i'], $row['ace_i_dose'], $row['bb'], $row['bb_dose'], $row['ccb'], $row['ccb_dose'], $row['diuretic'], 
                                            $row['diuretic_dose'], $row['other'], $row['other_dose'], $row['sbp1'], $row['dbp1'], $row['average_sbp'], $row['average_dbp'], $row['co_morbid_conditions'], 
                                            $row['drugs_co_morbidity'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
        }
    
        // Close the output stream
        fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_total_rx()
    {
        try {
            
            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
        
            $rx = new Rx_Model();
    
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
            
            $data = $rx->getTotalPatientsrx(0,0,0,0,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Patient Name', 'Patient Phone', 'Doctor Name', 'Quantity of Strips','Indication','Secondary','Prescription Information','Co-Morbidity Prescription','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalRx.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['patient_name'], $row['phone_no'], $row['doctor_name'], $row['strips'], $row['indication'], $row['secondary'], $row['prescription_information'], $row['co_morbidity_prescription'], 
                $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
            }
        
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_doctor_users_count()
    {
        try {
         

        $doctor = new Doctor_Model();
        
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
            
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];

        $data =  $doctor->gettotalDoctorEentry(0,0,0,0,$hq,$startDate,$endDate);
          
          // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Doctors'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="DoctorsUserCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_patient_users_count()
    {
        try {

        $patient = new Patient_Model;

         $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
            
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
        
        $data = $patient->gettotalPatientEentry(0,0,0,0,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Patients'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="PatientUsersCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_user_tbl()
    {
        try {
            
            $rx = new Rx_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
                
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):$row['HQ'];
    
            $user = new User_Model;
            $data = $user->getTotalUser(0,0,0,0,$hq);
        
                
            // CSV Header
            $header = ['Employee Name', 'Phone', 'Email', 'Emp. ID','Designation','City','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
              header('Content-Type: text/csv');
              header('Content-Disposition: attachment;filename="TotalUser.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['Name'], $row['phoneNO'], $row['mail'], $row['empNO'], $row['DESIG'], $row['city'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
            
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    
    
}