<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Frame_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Index_controller extends BaseController
{

    public function index()
    {
        return view('admin/index');
    }

    public function login()
    {
        $model = new User_Model();
        $result = $model->where('empNO', $this->request->getVar('emp_no'))->
            where('pass', $this->request->getVar('password'))->
            first();
        $session = session();
        if ($result != null) {
            $session = session();
            $sessionData = [
                'UserID' => $result['UserID'],
                'userType' => $result['userType'],

                'isLoggedIn' => true
            ];
            $session->set($sessionData);

            // Redirect to the appropriate dashboard based on the user's access level
            switch ($result['userType']) {
                case '5':
                    return redirect()->to('/admin/dashboard');
                case '4':
                    return redirect()->to('/zone/dashboard');
                case '3':
                    return redirect()->to('/rbm/dashboard');
                case '2':
                    return redirect()->to('/abm/dashboard');
                case '1':
                    return redirect()->to('/user/dashboard');
                default:
                    return redirect()->back()->withInput()->with('error', 'Invalid access level.');
            }

        } else {
            echo "
            <script type='text/javascript'>
                alert('Your Email or Password is incorect');
            </script>";
            echo "
            <script>
                function pageRedirect() {
                    window.location.replace('/admin');
                }      
                setTimeout('pageRedirect()', 100); 
            </script>";
        }
    }

    public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('/admin');
    }

    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $data = [
                'totalUsers' => $user->getTotalUsers(),
                'totalDoctors' => $doctor->getTotalDoctors(),
                'totalPatients' => $patient->getTotalPatient(),
            ];



            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $patient = new Patient_Model();

            $emp_array = $user->getTotalUser();
            $data['data'] = $emp_array;


            return view('admin/user_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function totel_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();

            $data['data'] = $doctor->getTotalDoctor();



            return view('admin/total_doctors', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function totel_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model();

            $data['data'] = $patient->getTotalPatients();



            return view('admin/total_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $data['data'] = $doctor->getTotelDoctorEentry();

            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $data['data'] = $patient->getTotelPatientEentry();

            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctor_patients($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $data['data'] = $patient->where('dr_id', $id)->getTotalPatients();

            return view('admin/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $emp = new User_Model;

            $data['admin'] = $emp->where('UserID', $id)->getProfile();


            return view('admin/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function add_user()
    {

        $session = session();
        if ($session->has('UserID')) {

            $hq = new Hq_Model;
            $hq_array = $hq->getRecords();
            $data['hq'] = $hq_array;

            $region = new Region_Model;
            $region_array = $region->getRecords();
            $data['region'] = $region_array;

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/add_user', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function user_insert()
    {
        $user = new User_Model;
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('desig'),
            'REGIONId' => $this->request->getVar('region'),
            'pass' => $this->request->getVar('emp_no'),
            'zoneId' => $this->request->getVar('zone'),
        ];
        $user->save($data);
        return redirect()->to('admin/add_user');
    }

    public function user_edit($UserID)
    {
        $user = new User_Model;
        $data['user'] = $user->where('UserID', $UserID)->first();

        $hq = new Hq_Model;
        $hq_array = $hq->getRecords();
        $data['hq'] = $hq_array;

        $region = new Region_Model;
        $region_array = $region->getRecords();
        $data['region'] = $region_array;

        $zone = new Zone_Model;
        $zone_array = $zone->getRecords();
        $data['zone'] = $zone_array;

        return view('admin/user_edit', $data);
    }

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('desig'),
            'REGIONId' => $this->request->getVar('region'),
            'pass' => $this->request->getVar('emp_no'),
            'zoneId' => $this->request->getVar('zone'),

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('admin/user_tbl');
    }

    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('admin/user_tbl');
    }

    /////////////////////////////////////////////////////////////////////////
    /////////////////////////////// Zonal  Panel /////////////////////////////

    public function z_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zoneId = $zrow['zoneId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('zoneId', $zoneId)->getTotalUsers(),
                'totalDoctors' => $doctor->where('zone_id', $zoneId)->getTotalDoctors(),
                'totalPatients' => $patient->where('zone_id', $zoneId)->getTotalPatient(),
            ];

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function z_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $id = $session->get('UserID');

            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_Id = $zrow['zoneId'];
                }
            }

            $data['data'] = $user->where('tbl_user.zoneId', $zone_Id)->getTotalUser();

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/user_table', $data);
        } else {
            return redirect()->to('/index');
        }

    }

    public function z_totel_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();
            $user = new User_Model;
            $id = $session->get('UserID');

            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_Id = $zrow['zoneId'];
                }
            }

            $data['data'] = $doctor->where('zone_Id', $zone_Id)->getTotalDoctor();

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/total_doctors', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function z_totel_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_Id = $zrow['zoneId'];
                }
            }

            $data['data'] = $patient->where('patient_data.zone_Id', $zone_Id)->getTotalPatients();

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/total_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function z_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_Id = $zrow['zoneId'];
                }
            }

            $data['data'] = $doctor->where('zone_Id', $zone_Id)->getTotelDoctorEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function z_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_Id = $zrow['zoneId'];
                }
            }

            $data['data'] = $patient->where('zone_Id', $zone_Id)->getTotelPatientEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function z_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            
            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function z_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function z_add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $region = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $row['row'] = $user->where('UserID', $id)->first();
                if (!empty($row)) {
                    foreach ($row as $zrow) {
                        $zone_id = $zrow['zoneId'];
                    }
                }

                $hq = new Hq_Model;
                $hq_array = $hq->getRecords();
                $data['hq'] = $hq_array;

                $region = new Region_Model;
                $region_array = $region->where('ZONEId', $zone_id)->getRecords();
                $data['region'] = $region_array;

                $data['zone_id'] = $zone_id;

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('zone/add_user', $data);
            } else {
                return redirect()->to('/index');
            }

        }
    }

    public function z_user_insert()
    {
        $user_insert = new User_Model;

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('desig'),
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => $this->request->getVar('emp_no'),
        ];
        $user_insert->save($data);
        return redirect()->to('zone/add_user');
    }

    public function z_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $region = new Region_Model;

        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {

            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $REGIONId = $zrow['REGIONId'];
                }
            }

            $reg['region'] = $region->where('REGIONId', $REGIONId)->first();
            if (!empty($reg)) {
                foreach ($reg as $zregion) {
                    $zone_id = $zregion['ZONEId'];
                }

                $hq = new Hq_Model;
                $hq_array = $hq->getRecords();
                $data['hq'] = $hq_array;

                $region = new Region_Model;
                $region_array = $region->where('ZONEId', $zone_id)->getRecords();
                $data['region'] = $region_array;
            }
        }

        $data['Name'] = $user->where('UserID', $id)->first();

        return view('zone/user_edit', $data);
    }

    public function z_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('userType'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('DESIG'),
            'REGIONId' => $this->request->getVar('region'),
            'pass' => $this->request->getVar('emp_no'),

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('zone/user_tbl');
    }
    public function z_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('zone/user_tbl');
    }

    /////////////////////////////////////////////////////////////////////////
    ////////////////////////// Regional Panel ////////////////////////////////

    public function r_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $poster = new Patient_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('REGIONId', $region_id)->where('DESIG !=', 'ZBM')->getTotalUsers(),
                'totalDoctors' => $doctor->where('region_id', $region_id)->getTotalDoctors(),
                'totalPatients' => $patient->where('region_id', $region_id)->getTotalPatient(),
            ];

            $data['Name'] = $user->where('UserID', $id)->first();


            return view('rbm/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                $data['data'] = $user->where('tbl_user.REGIONId', $region_id)->where('DESIG !=', 'ZBM')->getTotalUser();

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('rbm/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }
    public function r_totel_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                $data['data'] = $doctor->where('region_id', $region_id)->getTotalDoctor();

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('rbm/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_totel_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                $data['data'] = $patient->where('patient_data.region_id', $region_id)->getTotalPatients();

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('rbm/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $doctor->where('region_id', $region_id)->getTotelDoctorEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('rbm/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $patient->where('region_id', $region_id)->getTotelPatientEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('rbm/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            
            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('rbm/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function r_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('rbm/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['region'] = $user->where('UserID', $id)->getRecords();


                $hq = new Hq_Model;
                $hq_array = $hq->getRecords();
                $data['hq'] = $hq_array;

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('rbm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_user_insert()
    {
        $user_insert = new User_Model;

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('desig'),
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => $this->request->getVar('emp_no'),
        ];
        $user_insert->save($data);
        return redirect()->to('rbm/add_user');
    }

    public function r_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $hq = new Hq_Model;
        $hq_array = $hq->getRecords();
        $data['hq'] = $hq_array;

        $data['Name'] = $user->where('UserID', $id)->first();



        return view('rbm/user_edit', $data);
    }

    public function r_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('desig'),
            'pass' => $this->request->getVar('emp_no'),

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('rbm/user_tbl');
    }
    public function r_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('rbm/user_tbl');
    }

    ////////////////////////////////////////////////////////////
    ///////////////////////// ABM Panel /////////////////////////////

    public function a_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $patient = new Patient_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }
            $hq = $hq_id;
            $data = [
                'totalUsers' => $user->where('HQ', $hq)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUsers(),
                'totalDoctors' => $doctor->where('hq_id', $hq_id)->getTotalDoctors(),
                'totalPatients' => $patient->where('hq_id', $hq_id)->getTotalPatient(),
             ];
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('abm/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function a_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                $user_array = $user->where('tbl_user.HQ', $hq_id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUser();
                $data['data'] = $user_array;

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('abm/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function a_totel_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
                

                $data['data'] = $doctor->where('doctor_data.hq_id', $hq_id)->getTotalDoctor();

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('abm/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function a_totel_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
                
                $data['data'] = $patient->where('patient_data.hq_id', $hq_id)->getTotalPatients();

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('abm/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function a_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $doctor->where('hq_id', $hq_id)->getTotelDoctorEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('abm/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $patient->where('hq_id', $hq_id)->getTotelPatientEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('abm/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            
            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('abm/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function a_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();

            return view('abm/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }
    public function a_add_user()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['data'] = $user->where('UserID', $id)->getRecords();


                $data['Name'] = $user->where('UserID', $id)->first();

                return view('abm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function a_user_insert()
    {
        $user_insert = new User_Model;

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $this->request->getVar('desig'),
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => $this->request->getVar('emp_no'),
        ];
        $user_insert->save($data);
        return redirect()->to('abm/add_user');
    }

    public function a_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $data['Name'] = $user->where('UserID', $id)->first();

        return view('abm/user_edit', $data);
    }

    public function a_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'DESIG' => $this->request->getVar('desig'),
            'pass' => $this->request->getVar('emp_no'),

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('abm/user_tbl');
    }
    public function a_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('abm/user_tbl');
    }

    //////////////////////////////////////////////////////////////
    ///////////////////////// User Panel //////////////////////////////  


    public function u_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();

            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();
            $data['totaldoctor'] = $doctor->where('user_id', $id)->getTotalDoctorUser();
            $data['totalpatient'] = $patient->where('user_id', $id)->getTotalPatientUser();


            return view('user/dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_doctors()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $doctor = new Doctor_Model;
            $data['data'] = $doctor->where('user_id', $id)->getDoctorUser();

            return view('user/doctor_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctorform()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');


            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/doctorform', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function dr_data()
    {
        $doctor = new Doctor_Model();

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
            'user' => $this->request->getPost('user'),
            'user_id' => $this->request->getPost('user_id'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $doctor->save($data);
        return redirect()->to('user/total_doctors');
    }

    public function doctoredit($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();

            $data['row'] = $doctor->where('id', $id)->first();

            return view('user/doctoredit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function dr_update()
    {
        $doctor = new Doctor_Model();
        $id = $this->request->getPost('id');

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
        ];

        $doctor->where('id', $id)->set($data)->update();
        return redirect()->to('user/total_doctors');
    }

    public function addpatients($id)
    {
        $session = session();
        if ($session->has('UserID')) {

            $doctor = new Doctor_Model();

            $data['row'] = $doctor->where('id', $id)->first();

            return view('user/patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_data()
    {
        $patient = new Patient_Model();

        $combination = $this->request->getPost('combination');

        if (!empty($combination)) {
            $combinationStr = implode(', ', $combination);
        } else {
            $combinationStr = "No";
        }

        $data = [
            'name' => $this->request->getPost('name'),
            'phone' => $this->request->getPost('phone'),
            'place' => $this->request->getPost('place'),
            'examination' => $this->request->getPost('examination'),
            'age' => $this->request->getPost('age'),
            'gender' => $this->request->getPost('gender'),
            'hypertension' => $this->request->getPost('hypertension'),
            'hypertension_drugs' => $this->request->getPost('drugs'),
            'drugs_combination' => $combinationStr,
            'sbp1' => $this->request->getPost('sbp1'),
            'sbp2' => $this->request->getPost('sbp2'),
            'sbp3' => $this->request->getPost('sbp3'),
            'dbp1' => $this->request->getPost('dbp1'),
            'dbp2' => $this->request->getPost('dbp2'),
            'dbp3' => $this->request->getPost('dbp3'),
            'average_sbp' => $this->request->getPost('average_sbp'),
            'average_dbp' => $this->request->getPost('average_dbp'),
            'monotherapy' => $this->request->getPost('monotherapy'),
            'combination_therapy' => $this->request->getPost('combinationtherapy'),
            'co_morbid_conditions' => $this->request->getPost('comorbid_con'),
            'drugs_co_morbidity' => $this->request->getPost('drg_comorbid'),
            'dr_id' => $this->request->getPost('dr_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $patient->save($data);
        return redirect()->to('user/dashboard');
    }


    public function u_patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $patient = new Patient_Model;
            $data['data'] = $patient->where('patient_data.user_id', $id)->getPatientUser();

            return view('user/patient_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_three()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $region = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $REGIONId = $zrow['REGIONId'];
                }
            }

            $reg['region'] = $region->where('REGIONId', $REGIONId)->first();
            if (!empty($reg)) {
                foreach ($reg as $zregion) {
                    $zone_id = $zregion['ZONEId'];
                }
            }

            $data['row'] = $user->where('UserID', $id)->first();
            $data['zone'] = $region->where('ZONEId', $zone_id)->first();

            return view('user/home_three', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_four()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $region = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $REGIONId = $zrow['REGIONId'];
                }
            }

            $reg['region'] = $region->where('REGIONId', $REGIONId)->first();
            if (!empty($reg)) {
                foreach ($reg as $zregion) {
                    $zone_id = $zregion['ZONEId'];
                }
            }

            $data['row'] = $user->where('UserID', $id)->first();
            $data['zone'] = $region->where('ZONEId', $zone_id)->first();

            return view('user/home_four', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_five()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $region = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $REGIONId = $zrow['REGIONId'];
                }
            }

            $reg['region'] = $region->where('REGIONId', $REGIONId)->first();
            if (!empty($reg)) {
                foreach ($reg as $zregion) {
                    $zone_id = $zregion['ZONEId'];
                }
            }

            $data['row'] = $user->where('UserID', $id)->first();
            $data['zone'] = $region->where('ZONEId', $zone_id)->first();

            return view('user/home_five', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function u_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;

            $data['admin'] = $user->where('UserID', $id)->getProfile();

            return view('user/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

}