<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Index_controller extends BaseController
{

    public function index()
    {
        return view('admin/index');
    }
    public function privacy_policy()
    {
        return view('welcome_message');
    }

    public function login()
    {
        $model = new User_Model();
        $result = $model->where('empNO', $this->request->getVar('emp_no'))
            ->where('pass', $this->request->getVar('password'))->where('isActive', 1)
            ->first();
        $session = session();
        if ($result != null) {
            $sessionData = [
                'UserID' => $result['UserID'],
                'userType' => $result['userType'],
                'isLoggedIn' => true
            ];
            $session->set($sessionData);

            switch ($result['userType']) {
                case '5':
                    return redirect()->to('/admin/dashboard');
                case '4':
                    return redirect()->to('/zone/dashboard');
                case '3':
                    return redirect()->to('/rbm/dashboard');
                case '2':
                    return redirect()->to('/abm/dashboard');
                case '1':
                    return redirect()->to('/user/dashboard');
                default:
                    return redirect()->back()->withInput()->with('error', 'Invalid access level.');
            }

        } else {
            $session->setFlashdata('error', 'Your ID or Password is incorrect.');
            return redirect()->back()->withInput();
        }
    }

    public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('/admin');
    }

    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();
            
            $data = [
                'totalUsers' => $user->countAllResults(),
                'totalDoctors' => $doctor->countAllResults(),
                'totalPatients' => $patient->countAllResults(),
                'totalrx' => $rx->countAllResults(),
                'controller' => 'admin'
            ];
            $data['userType'] = $session->get('userType');
            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function total_Data()
    {
        $session = session();
         $pager = service('pager');
        if ($session->has('UserID')) {
            $rx = new Rx_Model();
            $zone = new Zone_Model();

            // Get the current page from the URL, otherwise default to page 1
            //$data ['page'] = (int)($this->request->getGet('page') ?? 1);
              $data['page'] = $this->request->getVar('page') ?? 1;
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $rx->where('rx_data.prescription_information !=', 'Non-Prescriber')
            ->orWhere('rx_data.co_morbidity_prescription !=', 'Non-Prescriber')->countAllResults();
  
            $data['data'] = $rx->getTotalData($data['perPage'],$data['page']);
            
            $zone_array = $zone->getRecords();
            
            $data['zone'] = $zone_array;
            
            $data['pager'] = $rx->pager;

            $data['controller'] = 'admin';
            
            $data['userType'] = $session->get('userType');
            return view('admin/total_data', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();
            $zone = new Zone_Model();
            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $doctor->countAllResults();
            
            $data['data'] = $doctor->getTotalDoctor($data['perPage'],$data['page']);

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';
            $data['userType'] = $session->get('userType');
            return view('admin/total_doctors', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model();
            $zone = new Zone_Model();

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $patient->countAllResults();
            
            $patient_array = $patient->getTotalPatients($data ['perPage'],$data['page']);
            $data['data'] = $patient_array;

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';
            $data['userType'] = $session->get('userType');
            return view('admin/total_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            
             // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $rx->countAllResults();
            
            $data['data'] = $rx->getTotalPatientsrx($data ['perPage'],$data["page"]);

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';
            $data['userType'] = $session->get('userType');
            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            
             // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = count($doctor->gettotalDoctorEentry(0,0));
            
            $data['data'] = $doctor->gettotalDoctorEentry($data['perPage'],$data["page"]);

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';
            
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            
             // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = count($patient->gettotalPatientEentry(0,0));
            
            $data['data'] = $patient->gettotalPatientEentry($data['perPage'],$data['page']);

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';

            $data['userType'] = $session->get('userType');
            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $zone = new Zone_Model();

            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $user->countAllResults();
            
            $emp_array = $user->getTotalUser($data['perPage'],$data['page']);
            $data['data'] = $emp_array;

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';

            $data['userType'] = $session->get('userType');

            return view('admin/user_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $emp = new User_Model;

            $data['admin'] = $emp->where('UserID', $id)->getProfile();
            $data['controller'] = 'admin';
            $data['userType'] = $session->get('userType');
            return view('admin/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
   
    public function add_user()
    {

        $session = session();
        if ($session->has('UserID')) {


            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;
            $data['controller'] = 'admin';
            return view('admin/add_user', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function user_edit($UserID)
    {
        $user = new User_Model;
        $data['user'] = $user->where('UserID', $UserID)->first();

        $zone = new Zone_Model;
        $zone_array = $zone->getRecords();
        $data['zone'] = $zone_array;
        $data['controller'] = 'admin';
        return view('admin/user_edit', $data);
    }
  

    public function get_user_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $user_model = new User_Model();
        $user_data = $user_model->getUserDataByZone($zone_id);
        $total = count($user_model->getUserDataByZone($zone_id,0,0));
        return $this->response->setJSON(['table_data' => $user_data,"total"=>$total]);
    }

    public function get_user_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $user_model = new User_Model();
        $user_data = $user_model->getUserDataByRegion($region_id, $zone_id);
        $total = count($user_model->getUserDataByRegion($region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $user_data,"total"=>$total]);
    }

    public function get_user_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getUserDataByHQ($hq_id, $region_id, $zone_id);
        $total = count($user_model->getUserDataByHQ($hq_id, $region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $user_data,"total"=>$total]);
    }


    public function user_insert()
    {
        $user = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } elseif ($userType == 2) {
            $desig = 'ABM';
        } elseif ($userType == 3) {
            $desig = 'RBM';
        } else {
            $desig = 'ZBM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'pass' => 'telminorm',
            'zoneId' => $this->request->getVar('zone'),
        ];
        $user->save($data);
        return redirect()->to('admin/add_user');
    }

   

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } elseif ($userType == 2) {
            $desig = 'ABM';
        } elseif ($userType == 3) {
            $desig = 'RBM';
        } else {
            $desig = 'ZBM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'pass' => 'telminorm',
            'zoneId' => $this->request->getVar('zone'),
        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('admin/user_tbl');
    }

    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('admin/user_tbl');
    }

   
    
    public function get_data_by_data()
    {
        $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $rx = new Rx_Model();
        $table_data = $rx->getTotalData($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);

        $total = count($rx->getTotalData(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }

    public function get_doctor_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $doctor = new Doctor_Model();
        $table_data = $doctor->getTotalDoctor($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);

        $total = count($doctor->getTotalDoctor(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));
 
        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }

    public function get_patient_data_by_date()
    {
       $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $patient = new Patient_Model();
        $table_data = $patient->getTotalPatients($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        
        $total = count($patient->getTotalPatients(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }

    public function get_rx_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $rx = new Rx_Model();
        $table_data = $rx->getTotalPatientsrx($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        
        $total = count($rx->getTotalPatientsrx(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }
     public function get_total_data_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $rx = new Rx_Model();
        $table_data = $rx->getTotalData(500,1,$zone_id);
        $total = count($rx->getTotalData(0,0,$zone_id));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }
    
    public function get_total_data_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $rx = new Rx_Model();
        $table_data = $rx->getTotalData(500,1,$zone_id,$region_id);
        
        $total = count($rx->getTotalData(0,0,$zone_id,$region_id));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }

    public function get_total_data_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $rx = new Rx_Model();
        $table_data = $rx->getTotalData(500,1,$zone_id,$region_id,$hq_id);

        $total = count($rx->getTotalData(0,0,$zone_id,$region_id));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }


    public function get_regions_by_zone()
    {
        $zone_id = $this->request->getVar('zone_id');
        $region_model = new Region_Model();
        $regions = $region_model->getRegionsByZone($zone_id);
        echo json_encode($regions);
    }
    public function get_hq_by_region()
    {
        $region_id = $this->request->getVar('region_id');
        $hq_model = new Hq_Model();
        $hqs = $hq_model->getHqByRegion($region_id);
        echo json_encode($hqs);
    }



    public function get_doctor_data_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getTableDataByZone($zone_id);
        $total = count($doctor_model->getTableDataByZone($zone_id));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_doctor_data_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getTableDataByRegion($region_id, $zone_id);
        $total = count($doctor_model->getTableDataByRegion($region_id, $zone_id));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_doctor_data_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getTableDataByHQ($hq_id, $region_id, $zone_id);
        $total = count($doctor_model->getTableDataByHQ($hq_id, $region_id, $zone_id));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }




    public function get_user_doctor_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getUserDoctorByZone($zone_id);
        $total = count($doctor_model->getUserDoctorByZone($zone_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_user_doctor_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getUserDoctorByRegion($region_id, $zone_id);
        $total = count($doctor_model->getUserDoctorByRegion($region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_user_doctor_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getUserDoctorByHQ($hq_id, $region_id, $zone_id);
        $total = count($doctor_model->getUserDoctorByHQ($hq_id, $region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

  

    public function get_patient_data_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getPatientDataByZone($zone_id);
        $total = count($patient_model->getPatientDataByZone($zone_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function get_patient_data_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getPatientDataByRegion($region_id, $zone_id);
        $total = count($patient_model->getPatientDataByRegion($region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function get_patient_data_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getPatientDataByHQ($hq_id, $region_id, $zone_id);
        $total = count($patient_model->getPatientDataByHQ($hq_id, $region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

  

    public function get_user_patient_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getUserPatientByZone($zone_id);
        $total = count($patient_model->getUserPatientByZone($zone_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function get_user_patient_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getUserPatientByRegion($region_id, $zone_id);
        $total = count($patient_model->getUserPatientByRegion($region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function get_user_patient_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getUserPatientByHQ($hq_id, $region_id, $zone_id);
        $total = count($patient_model->getUserPatientByHQ($hq_id, $region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }


    public function doctor_patients($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $data['data'] = $patient->where('dr_id', $id)->getTotalPatients();

            return view('admin/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

  

    public function get_rx_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRxByZone($zone_id);
        $total = count($rx_model->getRxByZone($zone_id,0,0));

        return $this->response->setJSON(['table_data' => $rx_data,"total"=>$total]);
    }

    public function get_rx_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRxByRegion($region_id, $zone_id);
        $total = count($rx_model->getRxByRegion($region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $rx_data,"total"=>$total]);
    }

    public function get_rx_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRxByHQ($hq_id, $region_id, $zone_id);
        $total = count($rx_model->getRxByHQ($hq_id, $region_id, $zone_id,0,0));
        return $this->response->setJSON(['table_data' => $rx_data,"total"=>$total]);
    }


    public function generate_excel_by_total_data()
    {
        try {

        $rx = new Rx_Model();

        
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
        
        $page = $rx->where('rx_data.prescription_information !=', 'Non-Prescriber')
            ->orWhere('rx_data.co_morbidity_prescription !=', 'Non-Prescriber')->countAllResults();
            
        $data = $rx->getTotalData($page,1,$zone,$region,$hq,$startDate,$endDate);
            
        // CSV Header
        $header = ['Zone', 'Region', 'Area', 'HQ','Employee ID','Employee','Date','Doctors','SBU Code','Total No. of Patients','Total No. of Telminorm Rx','Total No. of RXtor Rx','Total No. of Suitglip Rx','Total No. of Glyree Rx'];

        // Create a file pointer connected to the output stream
        $file = fopen('php://output', 'w');

        // Set headers to prompt download
          header('Content-Type: text/csv');
          header('Content-Disposition: attachment;filename="TotalData.csv"');

        // Output the header
         fputcsv($file, $header);
     

        //print_r(count($data));
        // Output each row of the data
        foreach ($data as $row) {
            fputcsv($file, [$row['ZONE'], $row['REGION'], $row['HQ'], $row['city'], $row['empno'], $row['user'], $row['rx_date'], $row['doctor_name'], $row['registration_no'], $row['total_patients'], $row['total_prescription'], $row['total_rxtor'], $row['total_suitglip'], $row['total_glyree']]);
           
        }
        
        // Close the output stream
        fclose($file);

          exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
     public function generate_excel_by_total_doctors()
    {
        try {
    
            $doctor = new Doctor_Model();
    
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
            $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            
    
            $data = $doctor->getTotalDoctor(0,0,$zone,$region,$hq,$startDate,$endDate);
    
            // CSV Header
            $header = ['Doctor Name', 'Cln./Hosp. Name', 'SBU Code', 'Phone','E-mail','Place','District','State','Country','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalDoctors.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['doctor'], $row['hospital'], $row['registration_no'], $row['phone'], $row['email'], $row['place'], $row['district'], $row['state'], $row['country'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
        
            // Close the output stream
            fclose($file);
        
            exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
     public function generate_excel_by_total_patients()
    {
        try {
        $patient = new Patient_Model();

        $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;

        $data = $patient->getTotalPatients(0,0,$zone,$region,$hq,$startDate,$endDate);
          
        // CSV Header
        $header = ['Doctor', 'Name', 'Phone', 'Place','Gender','Age','Examination Date','Hypertension','Hypertension Drugs','Drugs Combination','ARB Prescription','ARB Dose','ACE-I Prescription','ACE-I Dose','BB Prescription','BB Dose','CCB Prescription','CCB Dose','Diuretic Prescription','Diuretic Dose','Other Prescription','Other Dose','SBP','DBP','Average SBP','Average DBP','Co-morbid Condition','Drugs for co-morbidity','Date','Employee','Emp. ID','Area','Region','Zone'];

        // Create a file pointer connected to the output stream
        $file = fopen('php://output', 'w');

        // Set headers to prompt download
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename="TotalPatient.csv"');

        // Output the header
         fputcsv($file, $header);
     

        //print_r(count($data));
        // Output each row of the data
        foreach ($data as $row) {
            fputcsv($file, [$row['doctor'], $row['name'], $row['phone'], $row['place'], $row['gender'], $row['age'], $row['examination'], $row['hypertension'], $row['hypertension_drugs'], 
                                            $row['drugs_combination'], $row['arb'], $row['arb_dose'], $row['ace_i'], $row['ace_i_dose'], $row['bb'], $row['bb_dose'], $row['ccb'], $row['ccb_dose'], $row['diuretic'], 
                                            $row['diuretic_dose'], $row['other'], $row['other_dose'], $row['sbp1'], $row['dbp1'], $row['average_sbp'], $row['average_dbp'], $row['co_morbid_conditions'], 
                                            $row['drugs_co_morbidity'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
        }
    
        // Close the output stream
        fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_total_rx()
    {
        try {

            $rx = new Rx_Model();
    
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
            
            $data = $rx->getTotalPatientsrx(0,0,$zone,$region,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Patient Name', 'Patient Phone', 'Doctor Name', 'Quantity of Strips','Indication','Secondary','Prescription Information','Co-Morbidity Prescription','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalRx.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['patient_name'], $row['phone_no'], $row['doctor_name'], $row['strips'], $row['indication'], $row['secondary'], $row['prescription_information'], $row['co_morbidity_prescription'], 
                $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
            }
        
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_doctor_users_count()
    {
        try {
         

         $doctor = new Doctor_Model();
        
        $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;

        $data =  $doctor->gettotalDoctorEentry(0,0,$zone,$region,$hq,$startDate,$endDate);
          
          // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Doctors'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="DoctorsUserCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_patient_users_count()
    {
        try {

        $patient = new Patient_Model;

        $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
        
        $data = $patient->gettotalPatientEentry(0,0,$zone,$region,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Patients'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="patientUsersCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_user_tbl()
    {
        try {
            
            $rx = new Rx_Model();

            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):0;
            $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
    
            $user = new User_Model;
            $data = $user->getTotalUser(0,0,$zone,$region,$hq);
        
                
            // CSV Header
            $header = ['Employee Name', 'Phone', 'Email', 'Emp. ID','Designation','City','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
              header('Content-Type: text/csv');
              header('Content-Disposition: attachment;filename="TotalUser.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['Name'], $row['phoneNO'], $row['mail'], $row['empNO'], $row['DESIG'], $row['city'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
            
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    //////////////////////////////////////////////////////////////
    ///////////////////////// User Panel //////////////////////////////  


    public function u_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();

            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();
            $data['totaldoctor'] = $doctor->where('user_id', $id)->getTotalDoctorUser();
            $data['totalpatient'] = $patient->where('user_id', $id)->getTotalPatientUser();
            $data['totalrx'] = $rx->where('user_id', $id)->getTotalRxUser();

            return view('user/dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $doctor = new Doctor_Model;
            $data['data'] = $doctor->where('user_id', $id)->getDoctorUser();

            return view('user/doctor_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctorform()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/doctorform', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function check_phone_exists()
    {
        $phone = $this->request->getPost('phone');
        $doctor = new Doctor_Model();
        $exists = $doctor->checkPhoneExists($phone);
        if ($exists) {
            echo "exists";
        } else {
            echo "not_exists";
        }
    }

    public function dr_data()
    {
        $doctor = new Doctor_Model();

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
            'user' => $this->request->getPost('user'),
            'user_id' => $this->request->getPost('user_id'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $doctor->save($data);
        return redirect()->to('user/total_doctors');
    }

    public function doctoredit($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();

            $data['row'] = $doctor->where('id', $id)->first();

            return view('user/doctoredit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function check_phone_and_id_exists()
    {
        $phone = $this->request->getPost('phone');
        $id = $this->request->getPost('id');

        $doctorModel = new Doctor_Model();
        $result = $doctorModel->checkPhoneAndIdExists($phone, $id);

        return $this->response->setJSON($result);
    }

    public function dr_update()
    {
        $doctor = new Doctor_Model();
        $id = $this->request->getPost('id');

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
        ];

        $doctor->where('id', $id)->set($data)->update();
        return redirect()->to('user/total_doctors');
    }

    public function addpatients($id)
    {
        $session = session();
        if ($session->has('UserID')) {

            $doctor = new Doctor_Model();
            $patient = new Patient_Model();

            $data['row'] = $doctor->where('id', $id)->first();
            $data['patients'] = $patient->where('dr_id', $id)->findAll();

            return view('user/patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    
    public function patient_data()
    {
        $patient = new Patient_Model();

        $id = $this->request->getPost('id');

        $combination = $this->request->getPost('combination');
        if (!empty($combination)) {
            $combinationStr = implode(', ', $combination);
        } else {
            $combinationStr = "No";
        }

        $ARB = $this->request->getPost('ARB');
        if (!empty($ARB)) {
            $StrARB = implode(', ', $ARB);
        } 
        $ARB_other = $this->request->getPost('ARB_other');
        if (!empty($StrARB)) {
            if (!empty($ARB_other)) {
                $ARBStr = $StrARB . ", " . $ARB_other;
            } else {
                $ARBStr = $StrARB;
            }
        } else {
            $ARBStr = $ARB_other;
        }

        $ACEI = $this->request->getPost('ACE-I');
        if (!empty($ACEI)) {
            $StrACEI = implode(', ', $ACEI);
        } 
        $ACE_other = $this->request->getPost('ACE_other');
        if (!empty($StrACEI)) {
            if (!empty($ACE_other)) {
                $ACEIStr = $StrACEI . ", " . $ACE_other;
            } else {
                $ACEIStr = $StrACEI;
            }
        } else {
            $ACEIStr = $ACE_other;
        }

        $BB = $this->request->getPost('BB');
        if (!empty($BB)) {
            $StrBB = implode(', ', $BB);
        }         
        $BB_other = $this->request->getPost('BB_other');
        if (!empty($StrBB)) {
            if (!empty($BB_other)) {
                $BBStr = $StrBB . ", " . $BB_other;
            } else {
                $BBStr = $StrBB;
            }
        } else {
            $BBStr = $BB_other;
        }

        $CCB = $this->request->getPost('CCB');
        if (!empty($CCB)) {
            $StrCCB = implode(', ', $CCB);
        }
        $CCB_other = $this->request->getPost('CCB_other');
        if (!empty($StrCCB)) {
            if (!empty($CCB_other)) {
                $CCBStr = $StrCCB . ", " . $CCB_other;
            } else {
                $CCBStr = $StrCCB;
            }
        } else {
            $CCBStr = $CCB_other;
        }

        $Diuretic = $this->request->getPost('Diuretic');
        if (!empty($Diuretic)) {
            $StrDiuretic = implode(', ', $Diuretic);
        }
        $Diuretic_other = $this->request->getPost('Diuretic_other');
        if (!empty($StrDiuretic)) {
            if (!empty($Diuretic_other)) {
                $DiureticStr = $StrDiuretic . ", " . $Diuretic_other;
            } else {
                $DiureticStr = $StrDiuretic;
            }
        } else {
            $DiureticStr = $Diuretic_other;
        }

        $comorbid_con = $this->request->getPost('comorbid_con');
        if (!empty($comorbid_con)) {
            $comorbid_conStr = implode(', ', $comorbid_con);
        }
        $comorbid_other = $this->request->getPost('comorbid_other');
        if (!empty($comorbid_conStr)) {
            if (!empty($comorbid_other)) {
                $comorbid = $comorbid_conStr . ", " . $comorbid_other;
            } else {
                $comorbid = $comorbid_conStr;
            }
        } else {
            $comorbid = $comorbid_other;
        }

        $data = [
            'name' => $this->request->getPost('name'),
            'phone' => $this->request->getPost('phone'),
            'place' => $this->request->getPost('place'),
            'examination' => $this->request->getPost('examination'),
            'age' => $this->request->getPost('age'),
            'gender' => $this->request->getPost('gender'),
            'hypertension' => $this->request->getPost('hypertension'),
            'hypertension_drugs' => $this->request->getPost('drugs'),
            'drugs_combination' => $combinationStr,
            'arb' => $ARBStr,
            'arb_dose' => $this->request->getPost('ARB_dose'),
            'ace_i' => $ACEIStr,
            'ace_i_dose' => $this->request->getPost('ACE_dose'),
            'bb' => $BBStr,
            'bb_dose' => $this->request->getPost('BB_dose'),
            'ccb' => $CCBStr,
            'ccb_dose' => $this->request->getPost('CCB_dose'),
            'diuretic' => $DiureticStr,
            'diuretic_dose' => $this->request->getPost('Diuretic_dose'),
            'other' => $this->request->getPost('Other'),
            'other_dose' => $this->request->getPost('Other_dose'),
            'sbp1' => $this->request->getPost('sbp1'),
            'sbp2' => $this->request->getPost('sbp2'),
            'sbp3' => $this->request->getPost('sbp3'),
            'dbp1' => $this->request->getPost('dbp1'),
            'dbp2' => $this->request->getPost('dbp2'),
            'dbp3' => $this->request->getPost('dbp3'),
            'average_sbp' => $this->request->getPost('average_sbp'),
            'average_dbp' => $this->request->getPost('average_dbp'),
            'co_morbid_conditions' => $comorbid,
            'drugs_co_morbidity' => $this->request->getPost('drg_comorbid'),
            'dr_id' => $this->request->getPost('dr_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d H:i:s'),
        ];

        if (!empty($id)) {
            $data['id'] = $id;
        }

        $patient->save($data);
        $name = urlencode($this->request->getPost('name'));
        $date = urlencode($data['date']);
    
        return redirect()->to('user/rx_information?name=' . $name . '&date=' . $date);
    }


    public function u_patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $patient = new Patient_Model;
            $data['data'] = $patient->where('patient_data.user_id', $id)->getPatientUser();

            return view('user/patient_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function rx_information()
    {
        $name = $this->request->getVar('name');
        $date = $this->request->getVar('date');

        if (!$name || !$date) {
            return redirect()->to('/user/dashboard');
        }

        $patientModel = new Patient_model();
        $data['patientData']  = $patientModel->getPatientData($name, $date);

        return view('user/rx_information', $data);
    }

    public function addrx()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');
            $patient = new Patient_Model();
            $data['patients'] = $patient->where('patient_data.user_id', $id)->getPatientsbyUser();

            return view('user/rx_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function rx_data()
    {
        $rx = new Rx_Model();

        $patient_name = str_replace(' ', '_', $this->request->getPost('patient_name'));
        $phone_no = $this->request->getPost('phone_number');
        $folder = $patient_name . "_" . $phone_no;
        $file = $this->request->getFile('image');
        $image = "Prescription Not Uploaded";

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $randomName = $file->getRandomName();
            $destination = 'assets/patient_data/' . $folder . '/';
            if (!is_dir($destination)) {
                mkdir($destination, 0777, true);
            }
            $file->move($destination, $randomName);
            $image = $folder . "/" . $randomName;
        }

        $indication = $this->request->getPost('indication');
        $indicationStr = !empty($indication) ? $indication : "";

        $prescription = $this->request->getPost('prescription_information');
        if (!empty($prescription)) {
            $prescriptionStr = implode(', ', $prescription);
        } else {
            $prescriptionStr = "";
        }

        $co_morbidity = $this->request->getPost('co_morbidity_prescription');
        if (!empty($co_morbidity)) {
            $co_morbidityStr = implode(', ', $co_morbidity);
        } else {
            $co_morbidityStr = "";
        }

        $data = [
            'image' => $image,
            'doctor_name' => $this->request->getPost('doctor_name'),
            'patient_name' => $this->request->getPost('patient_name'),
            'phone_no' => $this->request->getPost('phone_number'),
            'quantity' => 'Null',
            'strips' => $this->request->getPost('strips'),
            'indication' => $indicationStr,
            'secondary' => $this->request->getPost('secondary'),
            'prescription_information' => $prescriptionStr,
            'co_morbidity_prescription' => $co_morbidityStr,
            'patient_id' => $this->request->getPost('patient_id'),
            'doctor_id' => $this->request->getPost('doctor_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $rx->save($data);
        return redirect()->to('user/total_rx');
    }

    public function u_rx()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $rx = new Rx_Model;
            $data['data'] = $rx->where('user_id', $id)->getRecord();

            return view('user/rx_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;

            $data['admin'] = $user->where('UserID', $id)->getProfile();
            $data['userid'] = $id ;
            return view('user/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_profile_edit()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model();
            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/profile_edit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_profile_update()
    {
        $user = new User_Model();
        $id = $this->request->getPost('id');

        $data = [
            'Name' => $this->request->getPost('name'),
            'phoneNO' => $this->request->getPost('phone'),
            'mail' => $this->request->getPost('email'),
            'city' => $this->request->getPost('city'),
        ];

        $user->where('UserID', $id)->set($data)->update();
        return redirect()->to('user/profile');
    }
}