<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Video_Model;
use App\Models\Birthday_Frame_Model;
use App\Models\Anniversary_Frame_Model;
use App\Models\Brandreminder_Frame_Model;
use App\Models\Thankyou_Frame_Model;
use App\Models\Birthday_Poster_Model;
use App\Models\Anniversary_Poster_Model;
use App\Models\Brandreminder_Poster_Model;
use App\Models\Thankyou_Poster_Model;
use App\Models\Brands_Model;
use App\Models\Birthday_Video_Frame_Model;
use App\Models\Anniversary_Video_Frame_Model;
use App\Models\Birthday_Video_Model;
use App\Models\Anniversary_Video_Model;


date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Index_controller extends BaseController
{

    public function index()
    {
        return view('admin/index');
    }

    public function login()
    {
        $model = new User_Model();
        $result = $model->where('empNO', $this->request->getVar('emp_no'))
            ->where('pass', $this->request->getVar('password'))
            ->first();
        $session = session();
        if ($result != null) {
            $sessionData = [
                'UserID' => $result['UserID'],
                'userType' => $result['userType'],
                'isLoggedIn' => true
            ];
            $session->set($sessionData);

            switch ($result['userType']) {
                case '5':
                    return redirect()->to('/admin/dashboard');
                case '4':
                    return redirect()->to('/zone/dashboard');
                case '3':
                    return redirect()->to('/rbm/dashboard');
                case '2':
                    return redirect()->to('/abm/dashboard');
                case '1':
                    return redirect()->to('/user/dashboard');
                default:
                    return redirect()->back()->withInput()->with('error', 'Invalid access level.');
            }

        } else {
            $session->setFlashdata('error', 'Your ID or Password is incorrect.');
            return redirect()->back()->withInput();
        }
    }

    public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('/admin');
    }

    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();
            $posterModel = new Poster_Model;
            $videosModel = new Video_Model;
            $data = [
                'totalUsers' => $user->getTotalUsers(),
                'totalDoctors' => $doctor->getTotalDoctors(),
                'totalPatients' => $patient->getTotalPatient(),
                'totalrx' => $rx->getTotalRxUser(),
                'totalPosters' => $posterModel->getTotalPosters(),
                'totalVideos' => $videosModel->getTotalVideos(),
            ];
            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $emp = new User_Model;

            $data['admin'] = $emp->where('UserID', $id)->getProfile();

            return view('admin/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function add_user()
    {

        $session = session();
        if ($session->has('UserID')) {


            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/add_user', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $zone = new Zone_Model();

            $emp_array = $user->getTotalUser();
            $data['data'] = $emp_array;

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/user_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_user_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $user_model = new User_Model();
        $user_data = $user_model->getUserDataByZone($zone_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_user_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $user_model = new User_Model();
        $user_data = $user_model->getUserDataByRegion($region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_user_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getUserDataByHQ($hq_id, $region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }


    public function user_insert()
    {
        $user = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } elseif ($userType == 2) {
            $desig = 'ABM';
        } elseif ($userType == 3) {
            $desig = 'RBM';
        } else {
            $desig = 'ZBM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'pass' => 'telminorm',
            'zoneId' => $this->request->getVar('zone'),
        ];
        $user->save($data);
        return redirect()->to('admin/add_user');
    }

    public function user_edit($UserID)
    {
        $user = new User_Model;
        $data['user'] = $user->where('UserID', $UserID)->first();

        $zone = new Zone_Model;
        $zone_array = $zone->getRecords();
        $data['zone'] = $zone_array;

        return view('admin/user_edit', $data);
    }

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } elseif ($userType == 2) {
            $desig = 'ABM';
        } elseif ($userType == 3) {
            $desig = 'RBM';
        } else {
            $desig = 'ZBM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'pass' => 'telminorm',
            'zoneId' => $this->request->getVar('zone'),
        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('admin/user_tbl');
    }

    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('admin/user_tbl');
    }

    public function total_Data()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new Rx_Model();
            $zone = new Zone_Model();

            $data['data'] = $rx->getTotalData();

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/total_data', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_total_data_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $rx = new Rx_Model();
        $table_data = $rx->where('rx_data.zone_id', $zone_id)->getTotalData();

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_total_data_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $rx = new Rx_Model();
        $table_data = $rx->where('rx_data.zone_id', $zone_id)
            ->where('rx_data.region_id', $region_id)->getTotalData();

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_total_data_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $rx = new Rx_Model();
        $table_data = $rx->where('rx_data.zone_id', $zone_id)
            ->where('rx_data.region_id', $region_id)
            ->where('rx_data.hq_id', $hq_id)->getTotalData();

        return $this->response->setJSON(['table_data' => $table_data]);
    }


    public function get_regions_by_zone()
    {
        $zone_id = $this->request->getVar('zone_id');
        $region_model = new Region_Model();
        $regions = $region_model->getRegionsByZone($zone_id);
        echo json_encode($regions);
    }
    public function get_hq_by_region()
    {
        $region_id = $this->request->getVar('region_id');
        $hq_model = new Hq_Model();
        $hqs = $hq_model->getHqByRegion($region_id);
        echo json_encode($hqs);
    }

    public function total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();
            $zone = new Zone_Model();

            $data['data'] = $doctor->getTotalDoctor();

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/total_doctors', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_doctor_data_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getTableDataByZone($zone_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_doctor_data_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getTableDataByRegion($region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_doctor_data_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getTableDataByHQ($hq_id, $region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }


    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $data['data'] = $doctor->gettotalDoctorEentry();

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_user_doctor_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getUserDoctorByZone($zone_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_user_doctor_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getUserDoctorByRegion($region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_user_doctor_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getUserDoctorByHQ($hq_id, $region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model();
            $zone = new Zone_Model();

            $patient_array = $patient->getTotalPatients();
            $data['data'] = $patient_array;

            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/total_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_patient_data_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getPatientDataByZone($zone_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_patient_data_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getPatientDataByRegion($region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_patient_data_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getPatientDataByHQ($hq_id, $region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $data['data'] = $patient->gettotalPatientEentry();

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_user_patient_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getUserPatientByZone($zone_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_user_patient_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getUserPatientByRegion($region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_user_patient_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getUserPatientByHQ($hq_id, $region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }


    public function doctor_patients($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $data['data'] = $patient->where('dr_id', $id)->getTotalPatients();

            return view('admin/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $data['data'] = $rx->getTotalPatientsrx();

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_rx_by_zone()
    {
        $zone_id = $this->request->getPost('zone_id');
        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRxByZone($zone_id);

        return $this->response->setJSON(['table_data' => $rx_data]);
    }

    public function get_rx_by_region()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRxByRegion($region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $rx_data]);
    }

    public function get_rx_by_hq()
    {
        $zone_id = $this->request->getPost('zone_id');
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRxByHQ($hq_id, $region_id, $zone_id);

        return $this->response->setJSON(['table_data' => $rx_data]);
    }



    public function total_poster()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Poster_Model;

            $data['data'] = $poster->getPosterWithUsersDetails();

            return view('admin/poster', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_videos()
    {
        $session = session();
        if ($session->has('UserID')) {
            $video = new Video_Model;

            $data['data'] = $video->getVideosWithUsersDetails();

            return view('admin/videos', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_birthday_videos()
    {
        $session = session();
        if ($session->has('UserID')) {
            $video = new Birthday_Video_Model;

            $data['data'] = $video->getVideosWithUsersDetails();

            return view('admin/birthday_videos', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

        public function total_anniversary_videos()
    {
        $session = session();
        if ($session->has('UserID')) {
            $video = new Anniversary_Video_Model;

            $data['data'] = $video->getVideosWithUsersDetails();

            return view('admin/anniversary_videos', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Poster_Model;
            $data['data'] = $poster->getUserCount();

            return view('admin/usercount', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function users_date_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Poster_Model;
            $data['data'] = $poster->getEntrybyDate();

            return view('admin/user_datecount', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function birthday_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Birthday_Poster_Model;
            $data['data'] = $poster->getPosterWithUsersDetails();

            return view('admin/birthday_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function anniversary_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Anniversary_Poster_Model;
            $data['data'] = $poster->getPosterWithUsersDetails();

            return view('admin/anniversary_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function brandreminder_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Brandreminder_Poster_Model;
            $data['data'] = $poster->getPosterWithUsersDetails();

            return view('admin/brandreminder_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function thankyou_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $poster = new Thankyou_Poster_Model;
            $data['data'] = $poster->getPosterWithUsersDetails();

            return view('admin/thankyou_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    
    public function brands_form()
    {
        $session = session();
        if ($session->has('UserID')) {
            return view('admin/brands_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function brands_insert()
    {
        $brands_tbl = new Brands_Model;
        $data = [
            'brand_name' => $this->request->getVar('brand_name')
        ];
        // print_r($data)  ;
        $brands_tbl->save($data);
        return redirect()->to('admin/brands_form');
    }

    public function brands_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $brands = new Brands_Model;

            $brands_array = $brands->getRecords();
            $data['data'] = $brands_array;
            return view('admin/brands_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function brands_edit($id)
    {
        $User = new Brands_Model;
        $data['brands_row'] = $User->where('brand_id', $id)->first();

        return view('admin/brands_edit', $data);
    }
    public function brands_update()
    {
        $brands_tbl = new Brands_Model;
        $brand_id = $this->request->getVar('brand_id');
        $data = [
            'brand_name' => $this->request->getVar('brand_name')
        ];
        $brands_tbl->update($brand_id, $data);
        return redirect()->to('admin/brands_table');
    }

    public function brands_delete($id)
    {
        $user = new Brands_Model;
        $user->where('brand_id', $id)->delete();
        return redirect()->to('admin/brands_table');
    }
    
    public function campaign_form()
    {
        $session = session();
        if ($session->has('UserID')) {

            return view('admin/campaign_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function campaign_insert()
    {
        $campaign = new Campaign_Model;
        $data = [
            'campaign_name' => $this->request->getVar('campaign_name')
        ];
        $campaign->save($data);
        return redirect()->to('admin/campaign_form');
    }

    public function campaign_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $campaign = new Campaign_Model;
            $poster = new Poster_Model;

            $camp_array = $campaign->getRecords();
            $data['data'] = $camp_array;
            return view('admin/campaign_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function campaign_edit($id)
    {
        $User = new Campaign_Model;
        $data['campaign_row'] = $User->where('campaign_id', $id)->first();



        return view('admin/campaign_edit', $data);
    }
    public function campaign_update()
    {
        $campaign = new Campaign_Model;
        $campaign_id = $this->request->getVar('campaign_id');
        $data = [
            'campaign_name' => $this->request->getVar('campaign_name')
        ];
        $campaign->update($campaign_id, $data);
        return redirect()->to('admin/campaign_table');
    }

    public function campaign_delete($id)
    {
        $user = new Campaign_Model;
        $user->where('campaign_id', $id)->delete();
        return redirect()->to('admin/campaign_table');
    }

    public function language_form()
    {

        $session = session();
        if ($session->has('UserID')) {

            return view('admin/language_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function language_insert()
    {
        $language = new Language_Model;
        $data = [
            'language' => $this->request->getVar('language')
        ];
        $language->save($data);
        return redirect()->to('admin/language_form');
    }
    public function language_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $language = new Language_Model;
            $poster = new Poster_Model;

            $language_array = $language->getRecords();
            $data['data'] = $language_array;
            return view('admin/language_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function language_edit($id)
    {
        $User = new Language_Model;
        $data['language_row'] = $User->where('language_id', $id)->first();



        return view('admin/language_edit', $data);
    }
    public function language_update()
    {
        $language = new Language_Model;
        $language_id = $this->request->getVar('language_id');
        $data = [
            'language' => $this->request->getVar('language')
        ];
        $language->update($language_id, $data);
        return redirect()->to('admin/language_table');
    }

    public function language_delete($id)
    {
        $user = new Language_Model;
        $user->where('language_id', $id)->delete();
        return redirect()->to('admin/language_table');
    }
    public function frame_form()
    {

        $session = session();
        if ($session->has('UserID')) {

            $campaign = new Campaign_Model();
            $campaign_array = $campaign->getRecords();
            $data['campaign'] = $campaign_array;

            $language = new Language_Model();
            $language_array = $language->getRecords();
            $data['language'] = $language_array;

            return view('admin/frame_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function frame_insert()
    {
        $frame = new Frame_Model;
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "frame_" . $RandomName;
            $img_file->move('assets/frame/', $image);
        }

        $data = [
            'frame_name' => $image,
            'fk_campaign_id' => $this->request->getVar('fk_campaign_id'),
            'fk_language_id' => $this->request->getVar('fk_language_id'),
        ];
        $frame->save($data);
        return redirect()->to('admin/frame_form');
    }
    public function frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Frame_Model;
            $poster = new Poster_Model;

            $emp_array = $frame->getFrames();
            $data['data'] = $emp_array;
            return view('admin/frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function frame_edit($id)
    {
        $User = new Frame_Model;
        $data['frame_row'] = $User->where('frame_id', $id)->first();

        $campaign = new Campaign_Model();
        $campaign_array = $campaign->getRecords();
        $data['campaign'] = $campaign_array;

        $language = new Language_Model();
        $language_array = $language->getRecords();
        $data['language'] = $language_array;



        return view('admin/frame_edit', $data);
    }

    public function frame_update()
    {
        $frame = new Frame_Model;
        $frame_id = $this->request->getVar('frame_id');
        $oldimage = $this->request->getPost('old_image');
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "frame_" . $RandomName;
            $img_file->move('assets/frame/', $image);

            if (!empty($oldimage)) {
                $oldImagePath = 'assets/frame/' . $oldimage;
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        } else {
            $image = $oldimage;
        }

        $data = [
            'frame_name' => $image,
            'fk_campaign_id' => $this->request->getVar('fk_campaign_id'),
            'fk_language_id' => $this->request->getVar('fk_language_id'),
        ];
        $frame->update($frame_id, $data);
        return redirect()->to('admin/frame_table');
    }

    public function frame_delete($id)
    {
        $frame = new Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/frame/" . $datafile)) {
            unlink("assets/frame/" . $datafile);
        }

        $frame->where('frame_id', $id)->delete();
        return redirect()->to('admin/frame_table');
    }

    public function birthday_frame_form()
    {

        $session = session();
        if ($session->has('UserID')) {
            return view('admin/birthday_frame_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_frame_insert()
    {
        $frame = new Birthday_Frame_Model;
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "birthday_frame_" . $RandomName;
            $img_file->move('assets/birthday_frame/', $image);
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->save($data);
        return redirect()->to('admin/birthday_frame_form');
    }
    public function birthday_frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Birthday_Frame_Model();

            $frame_array = $frame->getRecords();
            $data['data'] = $frame_array;
            return view('admin/birthday_frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_frame_edit($id)
    {
        $frame = new Birthday_Frame_Model;
        $data['frame_row'] = $frame->getRow($id);

        return view('admin/birthday_frame_edit', $data);
    }

    public function birthday_frame_update()
    {
        $frame = new Birthday_Frame_Model;
        $birthday_frame_id = $this->request->getVar('frame_id');
        $oldimage = $this->request->getPost('old_image');
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "birthday_frame_" . $RandomName;
            $img_file->move('assets/birthday_frame/', $image);

            if (!empty($oldimage)) {
                $oldImagePath = 'assets/birthday_frame/' . $oldimage;
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        } else {
            $image = $oldimage;
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->update($birthday_frame_id, $data);
        return redirect()->to('admin/birthday_frame_table');
    }

    public function birthday_frame_delete($id)
    {
        $frame = new Birthday_Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/birthday_frame/" . $datafile)) {
            unlink("assets/birthday_frame/" . $datafile);
        }

        $frame->where('birthday_frame_id', $id)->delete();
        return redirect()->to('admin/birthday_frame_table');
    }

    public function anniversary_frame_form()
    {
        $session = session();
        if ($session->has('UserID')) {
            return view('admin/anniversary_frame_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_frame_insert()
    {
        $frame = new Anniversary_Frame_Model;
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "anniversary_frame_" . $RandomName;
            $img_file->move('assets/anniversary_frame/', $image);
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->save($data);
        return redirect()->to('admin/anniversary_frame_form');
    }
    public function anniversary_frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Anniversary_Frame_Model();

            $frame_array = $frame->getRecords();
            $data['data'] = $frame_array;
            return view('admin/anniversary_frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_frame_edit($id)
    {
        $frame = new Anniversary_Frame_Model;
        $data['frame_row'] = $frame->getRow($id);

        return view('admin/anniversary_frame_edit', $data);
    }

    public function anniversary_frame_update()
    {
        $frame = new Anniversary_Frame_Model;
        $anniversary_frame_id = $this->request->getVar('frame_id');
        $oldimage = $this->request->getPost('old_image');
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "anniversary_frame_" . $RandomName;
            $img_file->move('assets/anniversary_frame/', $image);

            if (!empty($oldimage)) {
                $oldImagePath = 'assets/anniversary_frame/' . $oldimage;
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        } else {
            $image = $oldimage;
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->update($anniversary_frame_id, $data);
        return redirect()->to('admin/anniversary_frame_table');
    }

    public function anniversary_frame_delete($id)
    {
        $frame = new Anniversary_Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/anniversary_frame/" . $datafile)) {
            unlink("assets/anniversary_frame/" . $datafile);
        }

        $frame->where('anniversary_frame_id', $id)->delete();
        return redirect()->to('admin/anniversary_frame_table');
    }

    public function brandreminder_frame_form()
    {
        $session = session();
        if ($session->has('UserID')) {
            return view('admin/brandreminder_frame_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function brandreminder_frame_insert()
    {
        $frame = new Brandreminder_Frame_Model;
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "brandreminder_frame_" . $RandomName;
            $img_file->move('assets/brandreminder_frame/', $image);
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->save($data);
        return redirect()->to('admin/brandreminder_frame_form');
    }
    public function brandreminder_frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Brandreminder_Frame_Model();

            $frame_array = $frame->getRecords();
            $data['data'] = $frame_array;
            return view('admin/brandreminder_frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function brandreminder_frame_edit($id)
    {
        $frame = new Brandreminder_Frame_Model;
        $data['frame_row'] = $frame->getRow($id);

        return view('admin/brandreminder_frame_edit', $data);
    }

    public function brandreminder_frame_update()
    {
        $frame = new Brandreminder_Frame_Model;
        $brandreminder_frame_id = $this->request->getVar('frame_id');
        $oldimage = $this->request->getPost('old_image');
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "brandreminder_frame_" . $RandomName;
            $img_file->move('assets/brandreminder_frame/', $image);

            if (!empty($oldimage)) {
                $oldImagePath = 'assets/brandreminder_frame/' . $oldimage;
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        } else {
            $image = $oldimage;
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->update($brandreminder_frame_id, $data);
        return redirect()->to('admin/brandreminder_frame_table');
    }

    public function brandreminder_frame_delete($id)
    {
        $frame = new Brandreminder_Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/brandreminder_frame/" . $datafile)) {
            unlink("assets/brandreminder_frame/" . $datafile);
        }

        $frame->where('brandreminder_frame_id', $id)->delete();
        return redirect()->to('admin/brandreminder_frame_table');
    }

    public function thankyou_frame_form()
    {
        $session = session();
        if ($session->has('UserID')) {
            return view('admin/thankyou_frame_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function thankyou_frame_insert()
    {
        $frame = new Thankyou_Frame_Model;
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "thankyou_frame_" . $RandomName;
            $img_file->move('assets/thankyou_frame/', $image);
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->save($data);
        return redirect()->to('admin/thankyou_frame_form');
    }
    public function thankyou_frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Thankyou_Frame_Model();

            $frame_array = $frame->getRecords();
            $data['data'] = $frame_array;
            return view('admin/thankyou_frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function thankyou_frame_edit($id)
    {
        $frame = new Thankyou_Frame_Model;
        $data['frame_row'] = $frame->getRow($id);

        return view('admin/thankyou_frame_edit', $data);
    }

    public function thankyou_frame_update()
    {
        $frame = new Thankyou_Frame_Model;
        $thankyou_frame_id = $this->request->getVar('frame_id');
        $oldimage = $this->request->getPost('old_image');
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "thankyou_frame_" . $RandomName;
            $img_file->move('assets/thankyou_frame/', $image);

            if (!empty($oldimage)) {
                $oldImagePath = 'assets/thankyou_frame/' . $oldimage;
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        } else {
            $image = $oldimage;
        }

        $data = [
            'frame_name' => $image,
        ];
        $frame->update($thankyou_frame_id, $data);
        return redirect()->to('admin/thankyou_frame_table');
    }

    public function thankyou_frame_delete($id)
    {
        $frame = new Thankyou_Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/thankyou_frame/" . $datafile)) {
            unlink("assets/thankyou_frame/" . $datafile);
        }

        $frame->where('thankyou_frame_id', $id)->delete();
        return redirect()->to('admin/thankyou_frame_table');
    }

    public function birthday_video_frame_form()
    {

        $session = session();
        if ($session->has('UserID')) {
            return view('admin/birthday_video_frame_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_video_frame_insert()
    {
        $frame = new Birthday_Video_Frame_Model;
        $vdo_file = $this->request->getFile('frame_vdo');

        if ($vdo_file->isValid() && !$vdo_file->hasMoved()) {
            $RandomName = $vdo_file->getRandomName();
            $video = "birthday_frame_" . $RandomName;
            $vdo_file->move('assets/birthday_video_frame/', $video);
        }

        $data = [
            'frame_name' => $video,
            'frame_title' => $this->request->getPost('frame_title'),

        ];
        $frame->save($data);
        return redirect()->to('admin/birthday_video_frame_form');
    }
    public function birthday_video_frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Birthday_Video_Frame_Model();

            $frame_array = $frame->getRecords();
            $data['data'] = $frame_array;
            return view('admin/birthday_video_frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_video_frame_edit($id)
    {
        $frame = new Birthday_Video_Frame_Model;
        $data['frame_row'] = $frame->getRow($id);

        return view('admin/birthday_video_frame_edit', $data);
    }

    public function birthday_video_frame_update()
    {
        $frame = new Birthday_Video_Frame_Model;
        $birthday_frame_id = $this->request->getVar('frame_id');
        $oldvideo = $this->request->getPost('old_video');
        $vdo_file = $this->request->getFile('frame_vdo');

        if ($vdo_file->isValid() && !$vdo_file->hasMoved()) {
            $RandomName = $vdo_file->getRandomName();
            $video = "birthday_frame_" . $RandomName;
            $vdo_file->move('assets/birthday_video_frame/', $video);

            if (!empty($oldvideo)) {
                $oldvideoPath = 'assets/birthday_video_frame/' . $oldvideo;
                if (file_exists($oldvideoPath)) {
                    unlink($oldvideoPath);
                }
            }
        } else {
            $video = $oldvideo;
        }

        $data = [
            'frame_name' => $video,
            'frame_title' => $this->request->getPost('frame_title'),

        ];
        $frame->update($birthday_frame_id, $data);
        return redirect()->to('admin/birthday_video_frame_table');
    }

    public function birthday_video_frame_delete($id)
    {
        $frame = new Birthday_Video_Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/birthday_video_frame/" . $datafile)) {
            unlink("assets/birthday_video_frame/" . $datafile);
        }

        $frame->where('video_frame_id', $id)->delete();
        return redirect()->to('admin/birthday_video_frame_table');
    }

    public function anniversary_video_frame_form()
    {
        $session = session();
        if ($session->has('UserID')) {
            return view('admin/anniversary_video_frame_form');
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_video_frame_insert()
    {
        $frame = new Anniversary_Video_Frame_Model;
        $vdo_file = $this->request->getFile('frame_vdo');

        if ($vdo_file->isValid() && !$vdo_file->hasMoved()) {
            $RandomName = $vdo_file->getRandomName();
            $video = "anniversary_frame_" . $RandomName;
            $vdo_file->move('assets/anniversary_video_frame/', $video);
        }

        $data = [
            'frame_name' => $video,
            'frame_title' => $this->request->getPost('frame_title'),

        ];
        $frame->save($data);
        return redirect()->to('admin/anniversary_video_frame_form');
    }
    public function anniversary_video_frame_table()
    {
        $session = session();
        if ($session->has('UserID')) {
            $frame = new Anniversary_Video_Frame_Model();

            $frame_array = $frame->getRecords();
            $data['data'] = $frame_array;
            return view('admin/anniversary_video_frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_video_frame_edit($id)
    {
        $frame = new Anniversary_Video_Frame_Model;
        $data['frame_row'] = $frame->getRow($id);

        return view('admin/anniversary_video_frame_edit', $data);
    }

    public function anniversary_video_frame_update()
    {
        $frame = new Anniversary_Video_Frame_Model;
        $anniversary_frame_id = $this->request->getVar('frame_id');
        $oldvideo = $this->request->getPost('old_video');
        $vdo_file = $this->request->getFile('frame_vdo');

        if ($vdo_file->isValid() && !$vdo_file->hasMoved()) {
            $RandomName = $vdo_file->getRandomName();
            $video = "anniversary_frame_" . $RandomName;
            $vdo_file->move('assets/anniversary_video_frame/', $video);

            if (!empty($oldvideo)) {
                $oldvideoPath = 'assets/anniversary_video_frame/' . $oldvideo;
                if (file_exists($oldvideoPath)) {
                    unlink($oldvideoPath);
                }
            }
        } else {
            $video = $oldvideo;
        }

        $data = [
            'frame_name' => $video,
            'frame_title' => $this->request->getPost('frame_title'),

        ];
        $frame->update($anniversary_frame_id, $data);
        return redirect()->to('admin/anniversary_video_frame_table');
    }

    public function anniversary_video_frame_delete($id)
    {
        $frame = new Anniversary_Video_Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/anniversary_video_frame/" . $datafile)) {
            unlink("assets/anniversary_video_frame/" . $datafile);
        }

        $frame->where('video_frame_id', $id)->delete();
        return redirect()->to('admin/anniversary_video_frame_table');
    }
    //////////////////////////////////////////////////////////////
    ///////////////////////// User Panel //////////////////////////////  


    public function u_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

             return view('user/dashboard', );
        } else {
            return redirect()->to('/admin/index');
        }
    }

        public function data_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();

            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();
            $data['totaldoctor'] = $doctor->where('user_id', $id)->getTotalDoctorUser();
            $data['totalpatient'] = $patient->where('user_id', $id)->getTotalPatientUser();
            $data['totalrx'] = $rx->where('user_id', $id)->getTotalRxUser();

            return view('user/data_dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $doctor = new Doctor_Model;
            $data['data'] = $doctor->where('user_id', $id)->getDoctorUser();

            return view('user/doctor_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctorform()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/doctorform', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function check_phone_exists()
    {
        $phone = $this->request->getPost('phone');
        $doctor = new Doctor_Model();
        $exists = $doctor->checkPhoneExists($phone);
        if ($exists) {
            echo "exists";
        } else {
            echo "not_exists";
        }
    }

    public function dr_data()
    {
        $doctor = new Doctor_Model();

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
            'user' => $this->request->getPost('user'),
            'user_id' => $this->request->getPost('user_id'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $doctor->save($data);
        return redirect()->to('user/total_doctors');
    }

    public function doctoredit($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();

            $data['row'] = $doctor->where('id', $id)->first();

            return view('user/doctoredit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function check_phone_and_id_exists()
    {
        $phone = $this->request->getPost('phone');
        $id = $this->request->getPost('id');

        $doctorModel = new Doctor_Model();
        $result = $doctorModel->checkPhoneAndIdExists($phone, $id);

        return $this->response->setJSON($result);
    }

    public function dr_update()
    {
        $doctor = new Doctor_Model();
        $id = $this->request->getPost('id');

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
        ];

        $doctor->where('id', $id)->set($data)->update();
        return redirect()->to('user/total_doctors');
    }

    public function addpatients($id)
    {
        $session = session();
        if ($session->has('UserID')) {

            $doctor = new Doctor_Model();
            $patient = new Patient_Model();

            $data['row'] = $doctor->where('id', $id)->first();
            $data['patients'] = $patient->where('dr_id', $id)->findAll();

            return view('user/patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_data()
    {
        $patient = new Patient_Model();

        $id = $this->request->getPost('id');

        $combination = $this->request->getPost('combination');
        if (!empty($combination)) {
            $combinationStr = implode(', ', $combination);
        } else {
            $combinationStr = "No";
        }

        $ARB = $this->request->getPost('ARB');
        if (!empty($ARB)) {
            $StrARB = implode(', ', $ARB);
        }
        $ARB_other = $this->request->getPost('ARB_other');
        if (!empty($StrARB)) {
            if (!empty($ARB_other)) {
                $ARBStr = $StrARB . ", " . $ARB_other;
            } else {
                $ARBStr = $StrARB;
            }
        } else {
            $ARBStr = $ARB_other;
        }

        $ACEI = $this->request->getPost('ACE-I');
        if (!empty($ACEI)) {
            $StrACEI = implode(', ', $ACEI);
        }
        $ACE_other = $this->request->getPost('ACE_other');
        if (!empty($StrACEI)) {
            if (!empty($ACE_other)) {
                $ACEIStr = $StrACEI . ", " . $ACE_other;
            } else {
                $ACEIStr = $StrACEI;
            }
        } else {
            $ACEIStr = $ACE_other;
        }

        $BB = $this->request->getPost('BB');
        if (!empty($BB)) {
            $StrBB = implode(', ', $BB);
        }
        $BB_other = $this->request->getPost('BB_other');
        if (!empty($StrBB)) {
            if (!empty($BB_other)) {
                $BBStr = $StrBB . ", " . $BB_other;
            } else {
                $BBStr = $StrBB;
            }
        } else {
            $BBStr = $BB_other;
        }

        $CCB = $this->request->getPost('CCB');
        if (!empty($CCB)) {
            $StrCCB = implode(', ', $CCB);
        }
        $CCB_other = $this->request->getPost('CCB_other');
        if (!empty($StrCCB)) {
            if (!empty($CCB_other)) {
                $CCBStr = $StrCCB . ", " . $CCB_other;
            } else {
                $CCBStr = $StrCCB;
            }
        } else {
            $CCBStr = $CCB_other;
        }

        $Diuretic = $this->request->getPost('Diuretic');
        if (!empty($Diuretic)) {
            $StrDiuretic = implode(', ', $Diuretic);
        }
        $Diuretic_other = $this->request->getPost('Diuretic_other');
        if (!empty($StrDiuretic)) {
            if (!empty($Diuretic_other)) {
                $DiureticStr = $StrDiuretic . ", " . $Diuretic_other;
            } else {
                $DiureticStr = $StrDiuretic;
            }
        } else {
            $DiureticStr = $Diuretic_other;
        }

        $comorbid_con = $this->request->getPost('comorbid_con');
        if (!empty($comorbid_con)) {
            $comorbid_conStr = implode(', ', $comorbid_con);
        }
        $comorbid_other = $this->request->getPost('comorbid_other');
        if (!empty($comorbid_conStr)) {
            if (!empty($comorbid_other)) {
                $comorbid = $comorbid_conStr . ", " . $comorbid_other;
            } else {
                $comorbid = $comorbid_conStr;
            }
        } else {
            $comorbid = $comorbid_other;
        }

        $data = [
            'name' => $this->request->getPost('name'),
            'phone' => $this->request->getPost('phone'),
            'place' => $this->request->getPost('place'),
            'examination' => $this->request->getPost('examination'),
            'age' => $this->request->getPost('age'),
            'gender' => $this->request->getPost('gender'),
            'hypertension' => $this->request->getPost('hypertension'),
            'hypertension_drugs' => $this->request->getPost('drugs'),
            'drugs_combination' => $combinationStr,
            'arb' => $ARBStr,
            'arb_dose' => $this->request->getPost('ARB_dose'),
            'ace_i' => $ACEIStr,
            'ace_i_dose' => $this->request->getPost('ACE_dose'),
            'bb' => $BBStr,
            'bb_dose' => $this->request->getPost('BB_dose'),
            'ccb' => $CCBStr,
            'ccb_dose' => $this->request->getPost('CCB_dose'),
            'diuretic' => $DiureticStr,
            'diuretic_dose' => $this->request->getPost('Diuretic_dose'),
            'other' => $this->request->getPost('Other'),
            'other_dose' => $this->request->getPost('Other_dose'),
            'sbp1' => $this->request->getPost('sbp1'),
            'sbp2' => $this->request->getPost('sbp2'),
            'sbp3' => $this->request->getPost('sbp3'),
            'dbp1' => $this->request->getPost('dbp1'),
            'dbp2' => $this->request->getPost('dbp2'),
            'dbp3' => $this->request->getPost('dbp3'),
            'average_sbp' => $this->request->getPost('average_sbp'),
            'average_dbp' => $this->request->getPost('average_dbp'),
            'co_morbid_conditions' => $comorbid,
            'drugs_co_morbidity' => $this->request->getPost('drg_comorbid'),
            'dr_id' => $this->request->getPost('dr_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d H:i:s'),
        ];

        if (!empty($id)) {
            $data['id'] = $id;
        }

        $patient->save($data);
        $name = urlencode($this->request->getPost('name'));
        $date = urlencode($data['date']);

        return redirect()->to('user/rx_information?name=' . $name . '&date=' . $date);
    }


    public function u_patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $patient = new Patient_Model;
            $data['data'] = $patient->where('patient_data.user_id', $id)->getPatientUser();

            return view('user/patient_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function rx_information()
    {
        $name = $this->request->getVar('name');
        $date = $this->request->getVar('date');

        if (!$name || !$date) {
            return redirect()->to('/user/dashboard');
        }

        $patientModel = new Patient_model();
        $data['patientData'] = $patientModel->getPatientData($name, $date);

        return view('user/rx_information', $data);
    }

    public function addrx()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');
            $patient = new Patient_Model();
            $data['patients'] = $patient->where('patient_data.user_id', $id)->getPatientsbyUser();

            return view('user/rx_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function rx_data()
    {
        $rx = new Rx_Model();

        $patient_name = str_replace(' ', '_', $this->request->getPost('patient_name'));
        $phone_no = $this->request->getPost('phone_number');
        $folder = $patient_name . "_" . $phone_no;
        $file = $this->request->getFile('image');
        $image = "Prescription Not Uploaded";

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $randomName = $file->getRandomName();
            $destination = 'assets/patient_data/' . $folder . '/';
            if (!is_dir($destination)) {
                mkdir($destination, 0777, true);
            }
            $file->move($destination, $randomName);
            $image = $folder . "/" . $randomName;
        }

        $indication = $this->request->getPost('indication');
        $indicationStr = !empty($indication) ? $indication : "";

        $prescription = $this->request->getPost('prescription_information');
        if (!empty($prescription)) {
            $prescriptionStr = implode(', ', $prescription);
        } else {
            $prescriptionStr = "";
        }

        $co_morbidity = $this->request->getPost('co_morbidity_prescription');
        if (!empty($co_morbidity)) {
            $co_morbidityStr = implode(', ', $co_morbidity);
        } else {
            $co_morbidityStr = "";
        }

        $data = [
            'image' => $image,
            'doctor_name' => $this->request->getPost('doctor_name'),
            'patient_name' => $this->request->getPost('patient_name'),
            'phone_no' => $this->request->getPost('phone_number'),
            'quantity' => 'Null',
            'strips' => $this->request->getPost('strips'),
            'indication' => $indicationStr,
            'secondary' => $this->request->getPost('secondary'),
            'prescription_information' => $prescriptionStr,
            'co_morbidity_prescription' => $co_morbidityStr,
            'patient_id' => $this->request->getPost('patient_id'),
            'doctor_id' => $this->request->getPost('doctor_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $rx->save($data);
        return redirect()->to('user/total_rx');
    }

    public function u_rx()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $rx = new Rx_Model;
            $data['data'] = $rx->where('user_id', $id)->getRecord();

            return view('user/rx_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;

            $data['admin'] = $user->where('UserID', $id)->getProfile();
            $data['userid'] = $id;
            return view('user/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_profile_edit()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model();
            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/profile_edit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function u_profile_update()
    {
        $user = new User_Model();
        $id = $this->request->getPost('id');

        $data = [
            'Name' => $this->request->getPost('name'),
            'phoneNO' => $this->request->getPost('phone'),
            'mail' => $this->request->getPost('email'),
            'city' => $this->request->getPost('city'),
        ];

        $user->where('UserID', $id)->set($data)->update();
        return redirect()->to('user/profile');
    }

    public function u_select_poster()
    {
        $session = session();
        if ($session->has('UserID')) {

            $language = new Language_Model;

            $language_array = $language->getRecords();
            $data['language'] = $language_array;

            return view('user/poster_selection', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_campaigns_by_language($languageid)
    {
        $frameModel = new Frame_Model();
        $campaigns = $frameModel->getCampaignsByLanguage($languageid);

        return $this->response->setJSON($campaigns);
    }

    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function poster_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $poster = new Poster_Model;
            $data['data'] = $poster->getUserData($id);

            return view('user/poster_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function birthday_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $birthday = new Birthday_Frame_Model();

            $birthday_array = $birthday->getRecords();
            $data['data'] = $birthday_array;

            return view('user/birthday_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Birthday_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/birthday_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_birthday_poster()
    {
        $poster = new Birthday_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function birthday_poster_download_status()
    {
        $poster = new Birthday_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_poster_share_status()
    {
        $poster = new Birthday_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_poster_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $poster = new Birthday_Poster_Model;
            $data['data'] = $poster->getUserData($id);

            return view('user/poster_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function anniversary_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $anniversary = new anniversary_Frame_Model();

            $anniversary_array = $anniversary->getRecords();
            $data['data'] = $anniversary_array;

            return view('user/anniversary_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new anniversary_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/anniversary_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_anniversary_poster()
    {
        $poster = new Anniversary_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function anniversary_poster_download_status()
    {
        $poster = new Anniversary_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_poster_share_status()
    {
        $poster = new Anniversary_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_poster_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $poster = new Anniversary_Poster_Model;
            $data['data'] = $poster->getUserData($id);

            return view('user/poster_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function brandreminder_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $brandreminder = new brandreminder_Frame_Model();

            $brandreminder_array = $brandreminder->getRecords();
            $data['data'] = $brandreminder_array;

            return view('user/brandreminder_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function brandreminder_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new brandreminder_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/brandreminder_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_brandreminder_poster()
    {
        $poster = new Brandreminder_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function brandreminder_poster_download_status()
    {
        $poster = new Brandreminder_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function brandreminder_poster_share_status()
    {
        $poster = new Brandreminder_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function brandreminder_poster_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $poster = new Brandreminder_Poster_Model;
            $data['data'] = $poster->getUserData($id);

            return view('user/poster_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function thankyou_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $thankyou = new thankyou_Frame_Model();

            $thankyou_array = $thankyou->getRecords();
            $data['data'] = $thankyou_array;

            return view('user/thankyou_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function thankyou_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new thankyou_Frame_Model;
            $brands = new Brands_Model;

            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $brands_data = $brands->getRecords();
            $data['brands'] = $brands_data;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/thankyou_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_thankyou_poster()
    {
        $poster = new Thankyou_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'brand' => $this->request->getPost('input_text4'),
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function thankyou_poster_download_status()
    {
        $poster = new Thankyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function thankyou_poster_share_status()
    {
        $poster = new Thankyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function thankyou_poster_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $poster = new Thankyou_Poster_Model;
            $data['data'] = $poster->getUserData($id);

            return view('user/poster_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

        public function video_type_selection()
    {
        $session = session();
        if ($session->has('UserID')) {
            return view('user/video_type');
        } else {
            return redirect()->to('/admin/index');
        }
    }

       public function video_maker()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_video()
    {
        $video = new Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function video_download_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_share_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $VideoModel = new Video_Model();
            $data['data'] = $VideoModel->getUserData($id);

            return view('user/video_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function birthday_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $birthday = new Birthday_Video_Frame_Model();

            $birthday_array = $birthday->getRecords();
            $data['data'] = $birthday_array;

            return view('user/birthday_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
       public function birthday_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Birthday_Video_Frame_Model;
            
            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/birthday_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_birthday_video()
    {
        $video = new Birthday_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function birthday_video_download_status()
    {
        $poster = new Birthday_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_video_share_status()
    {
        $poster = new Birthday_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_video_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $VideoModel = new Birthday_Video_Model();
            $data['data'] = $VideoModel->getUserData($id);

            return view('user/birthday_video_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function anniversary_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $anniversary = new Anniversary_Video_Frame_Model();

            $anniversary_array = $anniversary->getRecords();
            $data['data'] = $anniversary_array;

            return view('user/anniversary_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
       public function anniversary_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Anniversary_Video_Frame_Model;
            
            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            return view('user/anniversary_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_anniversary_video()
    {
        $video = new Anniversary_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function anniversary_video_download_status()
    {
        $poster = new Anniversary_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_video_share_status()
    {
        $poster = new Anniversary_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_video_tbl()
    {

        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['user_row'] = $user->where('UserID', $id)->first();

            $VideoModel = new Anniversary_Video_Model();
            $data['data'] = $VideoModel->getUserData($id);

            return view('user/anniversary_video_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

}