<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\API\ResponseTrait;
use App\Models\User_Model;
use \Firebase\JWT\JWT;


class Login extends BaseController
{
    use ResponseTrait;
      

    public function index(){
        $User_Model = new User_Model();
        $input = $this->getRequestInput($this->request);

        $user = $User_Model->where($input)->where("isActive",1)->first();
   
        if(is_null($user)) {
            return $this->respond(['error' => 'Invalid employ code and password'], 200);
        }
   
        $key = getenv('JWT_SECRET');
        $iat = time(); // current timestamp value
        $exp = $iat + 3600;
  
        $payload = array(
            "iss" => "healthvationsteam of the JWT",
            "aud" => "",
            "sub" => $user['empNO'],
            "iat" => $iat, //Time the JWT issued at
            "exp" => $exp, // Expiration time of token
            "email" => $user['UserID'],
            "role_id" => $user['userType'],
        );
          
        $token = JWT::encode($payload, $key, 'HS256');
  
        $response = [
            'message' => 'Login Succesful',
           'token' => $token,
           "role_id"=>$user['userType']
        ];

        return $this->respond($response, 200);
    }
   
    public function forget(){
         $User_Model = new User_Model();
         $emp_pin = $this->request->getVar('emp_email');
         $user = $User_Model->where('mail',$emp_pin)->first();
         if(is_null($user)) {
             return $this->respond(['error' => 'Invalid employ email'], 200); 
         }
            
            $to = $emp_pin;
            $subject = 'MHAC App Forget Password';
            $message = 'New Pin:- '.$user['pass'];
            $headers = 'From: admin@MHACApp.com' . "\r\n" .
                       'Reply-To: admin@MHACApp.com' . "\r\n" .
                       'X-Mailer: PHP/' . phpversion();
           
            //if($email->send()){
            if(mail($emp_pin, $subject, $message, $headers)){
                $response = [
                    'message' => "please check mail",
                ];
                return $this->respond($response, 200);
            }else{
                $response = [
                    'message' => "try again",
                ];
                return $this->respond($response, 200);
            }
            
      
    }
    
    public function createAccount(){
         $response = [
            'message' => 'Account Created Successfully, the account will be verified in max 7 days.'
        ];

        return $this->respond($response, 200);
    }

    private function isLoggedIn()
    {
        $isLoggedIn = session()->get('isLoggedIn');

        return $isLoggedIn;
    }
    
  
}
