<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\API\ResponseTrait;
use App\Models\PatientModel;
use App\Models\Rx_Model;
use App\Models\EmployeeModel;
use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;

class Patient extends BaseController
{
      use ResponseTrait;
    public function index()
    {
        //
    }
    
    public function list()
    {
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));
        $Patient = new PatientModel;
        $employeeModel= new EmployeeModel;
        try { 
            if($decoded->role_id==1){ 
                  $list = $Patient->findPatientbyCampUser([$decoded->email]);
            }else if($decoded->role_id==2){ 
                $user = $employeeModel->select("emp_id")->where('emp_report_id', $decoded->email)->findAll();
                $resultArray = array_column($user, 'emp_id');
                 $list = $Patient->findPatientbyCampUser($resultArray);
            }else if($decoded->role_id==3){ 
                $user = $employeeModel->select("emp_id")->where('emp_report_id', $decoded->email)->findAll();
                $resultArray = array_column($user, 'emp_id');
                
                $user1 = $employeeModel->select("emp_id")->whereIn('emp_report_id', $resultArray)->findAll();
                $result1 = array_column($user1, 'emp_id');
                
                 $list = $Patient->findPatientbyCampUser($result1);
            }else if($decoded->role_id==4){ 
                $user = $employeeModel->select("emp_id")->where('emp_report_id', $decoded->email)->findAll();
                $resultArray = array_column($user, 'emp_id');
                
                $user1 = $employeeModel->select("emp_id")->whereIn('emp_report_id', $resultArray)->findAll();
                $result1 = array_column($user1, 'emp_id');
                
                $user2 = $employeeModel->select("emp_id")->whereIn('emp_report_id', $result1)->findAll();
                $result2 = array_column($user2, 'emp_id');
                
                 array_push($result2,$decoded->email);
                $output = array_merge($result1, $resultArray,$result2);
                    
                 $list = $Patient->findPatientbyCampUser($output);
            }else if($decoded->role_id==5){ 
                   
                 $list = $Patient->findAll();
            }
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    public function getPatientBycamp($id)
    {
        $Patient = new PatientModel;
        try { 
         
         $list = $Patient->findPatientByCampId($id);

         if(empty($list)) {  
             return $this->respond( [
                    'message' => 'Not Found'
                ], 200);
         }else{
           return $this->respond($list, 200);
         }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    public function camplist($id)
    {
        try {
            $camp = new PatientModel;
            $client = $camp->findPatientByCampId($id);

            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    public function show($id)
    {
        try {
            $camp = new PatientModel;
            $client = $camp->where('patient_phone', $id)->first();
            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function create()
    {
         try {
            $patient = new PatientModel;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            $input['createdBy'] = $userId;
            
            if($patient->save($input)){
                $input['patient_Id'] = $patient->getInsertID();
                 $patientMap = new Rx_Model;
                 if($this->request->getFile('previous_rx')){
                    $img = $this->request->getFile('previous_rx');
                    $img->move(FCPATH . 'uploads');
                    $input['previous_rx'] = $img->getName();
                 }
                 if($this->request->getFile('new_rx')){
                    $img = $this->request->getFile('new_rx');
                    $img->move(FCPATH . 'uploads'); 
                    $input['new_rx'] = $img->getName();
                 }
                if($patientMap->save($input)){
                    return $this->respond(['message' => 'insert'],200);
                }else{
                    return $this->respond(['message' => ''],200);
                }
            }else{
                return $this->respond(['message' => 'try camp not save successfully'],200);
            }
         } catch (Exception $e) {
            return $this->respond(['message' => 'Could not find client for specified ID'],ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    public function addpatient()
    {
         try {
            $patientMap = new Rx_Model;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            $input['createdBy'] = $userId;
            
            if($patientMap->save($input)){
                    return $this->respond(
                        [
                            'message' => 'insert'
                        ],
                        200
                    );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }   

    public function update($id)
    {
         try {
            $camp = new CampModel;
            $input = $this->getRequestInput($this->request);
            if($camp->update($id,$input)){
                return $this->respond(
                    [
                        'message' => 'In Next 7 Days Plan will be freeze ant changes after this subject to approval from seniors'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function delete($id)
    {
        try {
            $camp = new CampModel;
            if($camp->delete($id)){
                return $this->respond(
                    [
                        'message' => 'Camp delete successfully'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function upload($id)
    {
        try {
             
            $gallery = new GalleryModel;
            $img = $this->request->getFile('file');
            $img->move(FCPATH . 'uploads');
            
            $data = ['camp_id' => $id,"camp_photo"=>$img->getName()];
            
            if($gallery->save($data)){
                return $this->respond(['message' => ''],200);
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => $e->getMessage()
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
}
