<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;

use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Video_Model;
use App\Models\Birthday_Frame_Model;
use App\Models\Anniversary_Frame_Model;
use App\Models\Brandreminder_Frame_Model;
use App\Models\Thankyou_Frame_Model;
use App\Models\Birthday_Poster_Model;
use App\Models\Anniversary_Poster_Model;
use App\Models\Brandreminder_Poster_Model;
use App\Models\Thankyou_Poster_Model;
use App\Models\Brands_Model;
use App\Models\Birthday_Video_Frame_Model;
use App\Models\Anniversary_Video_Frame_Model;
use App\Models\Birthday_Video_Model;
use App\Models\Anniversary_Video_Model;
use App\Models\Festival_Video_Frame_Model;
use App\Models\Festival_Video_Model;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Regional_controller extends BaseController
{
    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();
            $posterModel = new Poster_Model();
            $videosModel = new Video_Model();
            $FrameModel = new Frame_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->countAllResults(),
                'totalDoctors' => $doctor->where('region_id', $region_id)->countAllResults(),
                'totalPatients' => $patient->where('region_id', $region_id)->countAllResults(),
                'totalrx' => $rx->where('region_id', $region_id)->countAllResults(),
                'totalPosters' => $posterModel->getTotalPostersByRegion($region_id),
                'totalVideos' => $videosModel->getTotalVideosByRegion($region_id),
                'controller' => 'rbm'
            ];
            $data['userType'] = $session->get('userType');
            $data['Name'] = $user->where('UserID', $id)->first();

            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int) ($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data['total'] = $doctor->where('doctor_data.region_id', $row['REGIONId'])->countAllResults();

                $data['data'] = $doctor->getTotalDoctor($data['perPage'], $data['page'], 0, $row['REGIONId']);
                $data['hq'] = $hq_mdl->getHqByRegion($row['REGIONId']);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';
                $data['userType'] = $session->get('userType');

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('admin/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int) ($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data['total'] = $patient->where('patient_data.region_id', $region_id)->countAllResults();

                $data['data'] = $patient->getTotalPatients($data['perPage'], $data['page'], 0, $region_id);
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';
                $data['userType'] = $session->get('userType');

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('admin/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $hq_mdl = new Hq_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }
            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int) ($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $rx->where('rx_data.region_id', $region_id)->countAllResults();

            $data['data'] = $rx->getTotalPatientsrx($data['perPage'], $data['page'], 0, $region_id);
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();


            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int) ($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $doctor->where('doctor_data.region_id', $row['REGIONId'])->countAllResults();

            $data['data'] = $doctor->gettotalDoctorEentry($data['perPage'], $data["page"], 0, $row['REGIONId']);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['hq'] = $hq_mdl->getHqByRegion($row['REGIONId']);
            $data['controller'] = 'rbm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int) ($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 5000;
            // Get total number of items
            $data['total'] = $patient->where('patient_data.region_id', $region_id)->countAllResults();

            $data['data'] = $patient->where('patient_data.region_id', $region_id)->gettotalPatientEentry(500, $data["page"]);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);
            $data['controller'] = 'rbm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function get_doctor_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id') ? $this->request->getGet('zone_id') : 0;
        $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
        $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
        $searchText = $this->request->getGet('searchText') ? $this->request->getGet('searchText') : "";

        $hq_id = $this->request->getGet('hq_id') ? $this->request->getGet('hq_id') : 0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();


        $doctor = new Doctor_Model();
        $table_data = $doctor->getTotalDoctor($pagesize, $page, $zone_id, $row['REGIONId'], $hq_id, $startDate, $endDate, $searchText);
        $total = count($doctor->getTotalDoctor(0, 0, $zone_id, $row['REGIONId'], $hq_id, $startDate, $endDate, $searchText));
        return $this->response->setJSON(['table_data' => $table_data, "total" => $total]);
    }

    public function get_patient_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id') ? $this->request->getGet('zone_id') : 0;
        $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
        $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
        $searchText = $this->request->getGet('searchText') ? $this->request->getGet('searchText') : "";

        $hq_id = $this->request->getGet('hq_id') ? $this->request->getGet('hq_id') : 0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize') ? $this->request->getGet('pagesize') : 500;

        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $patient = new Patient_Model();
        $table_data = $patient->getTotalPatients($pagesize, $page, $zone_id, $row['REGIONId'], $hq_id, $startDate, $endDate, $searchText);
        $total = count($patient->getTotalPatients(0, 0, $zone_id, $row['REGIONId'], $hq_id, $startDate, $endDate, $searchText));
        return $this->response->setJSON(['table_data' => $table_data, "total" => $total]);
    }

    public function get_rx_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id') ? $this->request->getGet('zone_id') : 0;
        $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
        $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
        $searchText = $this->request->getGet('searchText') ? $this->request->getGet('searchText') : "";

        $hq_id = $this->request->getGet('hq_id') ? $this->request->getGet('hq_id') : 0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $rx = new Rx_Model();
        $table_data = $rx->getTotalPatientsrx($pagesize, $page, 0, $row['REGIONId'], $hq_id, $startDate, $endDate, $searchText);
        $total = count($rx->getTotalPatientsrx(0, 0, $zone_id, $row['REGIONId'], $hq_id, $startDate, $endDate, $searchText));
        return $this->response->setJSON(['table_data' => $table_data, "total" => $total]);
    }

    public function get_user_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getRegionUserByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_doctor_data_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getRegionDoctorByHQ($hq_id);
        $total = count($doctor_model->getRegionDoctorByHQ($hq_id, 0, 0));
        return $this->response->setJSON(['table_data' => $table_data, "total" => $total]);
    }

    public function get_patient_data_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getRegionPatientByHQ($hq_id);
        $total = count($patient_model->getRegionPatientByHQ($hq_id, 0, 0));
        return $this->response->setJSON(['table_data' => $patient_data, "total" => $total]);
    }

    public function get_doctor_count_by_date()
    {
        $session = session();
        $user = new User_Model();

        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $data['page'] = (int) ($this->request->getGet('page') ?? 1);
        $data['perPage'] = (int) ($this->request->getGet('perPage') ?? 500);

        $doctor = new Doctor_Model();
        $table_data = $doctor->gettotalDoctorEentry($data['perPage'], $data["page"], 0, $row['REGIONId']);
        ;
        $total = count($doctor->gettotalDoctorEentry($data['perPage'], $data["page"], 0, $row['REGIONId']));
        return $this->response->setJSON(['table_data' => $table_data, "total" => $total]);
    }

    public function get_user_doctor_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getRegionUserDoctorByHQ($hq_id);
        $total = count($doctor_model->getRegionUserDoctorByHQ($hq_id, 0, 0));
        return $this->response->setJSON(['table_data' => $table_data, "total" => $total]);
    }

    public function get_user_patient_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getRegionUserPatientByHQ($hq_id);
        $total = count($patient_model->getRegionUserPatientByHQ($hq_id, 0, 0));
        return $this->response->setJSON(['table_data' => $patient_data, "total" => $total]);
    }

    public function doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function get_rx_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRegionRxByHQ($hq_id);
        $total = count($rx_model->getRegionRxByHQ($hq_id, 0, 0));
        return $this->response->setJSON(['table_data' => $rx_data, "total" => $total]);
    }

    public function add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['region'] = $user->where('UserID', $id)->getRecords();
                $row['row'] = $user->where('UserID', $id)->first();
                if (!empty($row)) {
                    foreach ($row as $zrow) {
                        $region_id = $zrow['REGIONId'];
                    }
                }

                $data['hq'] = $hq_mdl->getHqByRegion($region_id);
                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('rbm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function user_insert()
    {
        $user_insert = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } else {
            $desig = 'ABM';
        }

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
            'isActive' => '1',
        ];
        $user_insert->save($data);
        return redirect()->to('rbm/add_user');
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int) ($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 20;
                // Get total number of items
                $data['total'] = $user->where('tbl_user.REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->countAllResults();

                $data['data'] = $user->where('tbl_user.REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->getTotalUser(20, $data["page"]);
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';
                $data['userType'] = $session->get('userType');

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('admin/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $hq_mdl = new Hq_Model;
        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {
            foreach ($row as $zrow) {
                $region_id = $zrow['REGIONId'];
            }
        }
        $data['hq'] = $hq_mdl->getHqByRegion($region_id);
        $data['Name'] = $user->where('UserID', $id)->first();
        $data['controller'] = 'rbm';

        $FrameModel = new Frame_Model();
        $campaign = $FrameModel->getAllCampaignsWithFrames();
        $data['campaigns'] = $campaign;

        return view('rbm/user_edit', $data);
    }

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } else {
            $desig = 'ABM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'pass' => 'telminorm',
            'isActive' => '1',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('rbm/user_tbl');
    }
    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('rbm/user_tbl');
    }

    public function generate_excel_by_total_doctors()
    {
        try {

            $doctor = new Doctor_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $zone = $this->request->getGet('zone') ? $this->request->getGet('zone') : $row['zoneId'];
            $region = $this->request->getGet('region') ? $this->request->getGet('region') : $row['REGIONId'];
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : 0;
            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $searchText = $this->request->getGet('searchInput') ? $this->request->getGet('searchInput') : "";


            $data = $doctor->getTotalDoctor(0, 0, $zone, $region, $hq, $startDate, $endDate, $searchText);

            // CSV Header
            $header = ['Doctor Name', 'Cln./Hosp. Name', 'SBU Code', 'Phone', 'E-mail', 'Place', 'District', 'State', 'Country', 'Date', 'Employee', 'Emp. ID', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalDoctors.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['doctor'], $row['hospital'], $row['registration_no'], $row['phone'], $row['email'], $row['place'], $row['district'], $row['state'], $row['country'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);

            }

            // Close the output stream
            fclose($file);

            exit;


        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_total_patients()
    {
        try {
            $patient = new Patient_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $zone = $this->request->getGet('zone') ? $this->request->getGet('zone') : $row['zoneId'];
            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $region = $this->request->getGet('region') ? $this->request->getGet('region') : $row['REGIONId'];
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : 0;

            $data = $patient->getTotalPatients(0, 0, $zone, $region, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Doctor', 'Name', 'Phone', 'Place', 'Gender', 'Age', 'Examination Date', 'Hypertension', 'Hypertension Drugs', 'Drugs Combination', 'ARB Prescription', 'ARB Dose', 'ACE-I Prescription', 'ACE-I Dose', 'BB Prescription', 'BB Dose', 'CCB Prescription', 'CCB Dose', 'Diuretic Prescription', 'Diuretic Dose', 'Other Prescription', 'Other Dose', 'SBP', 'DBP', 'Average SBP', 'Average DBP', 'Co-morbid Condition', 'Drugs for co-morbidity', 'Date', 'Employee', 'Emp. ID', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalPatient.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [
                    $row['doctor'],
                    $row['name'],
                    $row['phone'],
                    $row['place'],
                    $row['gender'],
                    $row['age'],
                    $row['examination'],
                    $row['hypertension'],
                    $row['hypertension_drugs'],
                    $row['drugs_combination'],
                    $row['arb'],
                    $row['arb_dose'],
                    $row['ace_i'],
                    $row['ace_i_dose'],
                    $row['bb'],
                    $row['bb_dose'],
                    $row['ccb'],
                    $row['ccb_dose'],
                    $row['diuretic'],
                    $row['diuretic_dose'],
                    $row['other'],
                    $row['other_dose'],
                    $row['sbp1'],
                    $row['dbp1'],
                    $row['average_sbp'],
                    $row['average_dbp'],
                    $row['co_morbid_conditions'],
                    $row['drugs_co_morbidity'],
                    $row['date'],
                    $row['user'],
                    $row['empno'],
                    $row['HQ'],
                    $row['REGION'],
                    $row['ZONE']
                ]);
            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_total_rx()
    {
        try {

            $rx = new Rx_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $zone = $this->request->getGet('zone') ? $this->request->getGet('zone') : $row['zoneId'];
            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $region = $this->request->getGet('region') ? $this->request->getGet('region') : $row['REGIONId'];
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : 0;

            $data = $rx->getTotalPatientsrx(0, 0, $zone, $region, $hq, htmlspecialchars($startDate), htmlspecialchars($endDate));

            // CSV Header
            $header = ['Patient Name', 'Patient Phone', 'Doctor Name', 'Quantity of Strips', 'Indication', 'Secondary', 'Prescription Information', 'Co-Morbidity Prescription', 'Date', 'Employee', 'Emp. ID', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalRx.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [
                    $row['patient_name'],
                    $row['phone_no'],
                    $row['doctor_name'],
                    $row['strips'],
                    $row['indication'],
                    $row['secondary'],
                    $row['prescription_information'],
                    $row['co_morbidity_prescription'],
                    $row['date'],
                    $row['user'],
                    $row['empno'],
                    $row['HQ'],
                    $row['REGION'],
                    $row['ZONE']
                ]);
            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_doctor_users_count()
    {
        try {


            $doctor = new Doctor_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $zone = $this->request->getGet('zone') ? $this->request->getGet('zone') : $row['zoneId'];
            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $region = $this->request->getGet('region') ? $this->request->getGet('region') : $row['REGIONId'];
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : 0;

            $data = $doctor->gettotalDoctorEentry(0, 0, $zone, $region, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region', 'Zone', 'Totel Doctors'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="DoctorsUserCount.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_patient_users_count()
    {
        try {

            $patient = new Patient_Model;

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $zone = $this->request->getGet('zone') ? $this->request->getGet('zone') : $row['zoneId'];
            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $region = $this->request->getGet('region') ? $this->request->getGet('region') : $row['REGIONId'];
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : 0;

            $data = $patient->gettotalPatientEentry(0, 0, $zone, $region, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region', 'Zone', 'Totel Patients'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalPatientsUsersCount.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }

            // Close the output stream
            fclose($file);
            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_user_tbl()
    {
        try {

            $rx = new Rx_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $zone = $this->request->getGet('zone') ? $this->request->getGet('zone') : $row['zoneId'];
            $region = $this->request->getGet('region') ? $this->request->getGet('region') : $row['REGIONId'];
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : 0;

            $user = new User_Model;
            $data = $user->getTotalUser(0, 0, $zone, $region, $hq);


            // CSV Header
            $header = ['Employee Name', 'Phone', 'Email', 'Emp. ID', 'Designation', 'City', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalUser.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['Name'], $row['phoneNO'], $row['mail'], $row['empNO'], $row['DESIG'], $row['city'], $row['HQ'], $row['REGION'], $row['ZONE']]);

            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }


    public function total_poster()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $posterModel->getPosterWithUsersDetailsByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function birthday_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Birthday_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByRegion($region_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/birthday_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function anniversary_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Anniversary_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByRegion($region_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';


            return view('admin/anniversary_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function brandreminder_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Brandreminder_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByRegion($region_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/brandreminder_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function thankyou_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Thankyou_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByRegion($region_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/thankyou_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function total_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $videosModel->getVideosWithUsersDetailsByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

        public function total_birthday_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $VideoModel = new Birthday_Video_Model;

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                   $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $VideoModel->getVideosWithUsersDetailsByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;
            $data['controller'] = 'rbm';

            return view('admin/birthday_videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_anniversary_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $VideoModel = new Anniversary_Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                   $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $VideoModel->getVideosWithUsersDetailsByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;
            $data['controller'] = 'rbm';

            return view('admin/anniversary_videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_festival_videos()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $video = new Festival_Video_Model;

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                   $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $video->getVideosWithUsersDetailsByRegion($region_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;
            $data['controller'] = 'rbm';

            return view('admin/festival_videos', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function users_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $posterModel->getUserCountByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function users_date_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $posterModel->getEntryByDateByRegion($region_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    
    public function select_posters()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/select_posters_type', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function poster_selection()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $language = new Language_Model;

            $language_array = $language->getRecords();
            $data['language'] = $language_array;


            return view('admin/poster_selection', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;


            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function poster_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function birthday_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $birthday = new Birthday_Frame_Model();

            $birthday_array = $birthday->getRecords();
            $data['data'] = $birthday_array;

            return view('admin/birthday_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Birthday_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $id = $session->get('UserID');
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/birthday_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_birthday_poster()
    {
        $poster = new Birthday_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function birthday_poster_download_status()
    {
        $poster = new Birthday_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_poster_share_status()
    {
        $poster = new Birthday_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function anniversary_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $anniversary = new anniversary_Frame_Model();

            $anniversary_array = $anniversary->getRecords();
            $data['data'] = $anniversary_array;

            return view('admin/anniversary_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new anniversary_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/anniversary_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_anniversary_poster()
    {
        $poster = new Anniversary_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function anniversary_poster_download_status()
    {
        $poster = new Anniversary_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_poster_share_status()
    {
        $poster = new Anniversary_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }



    public function brandreminder_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $brandreminder = new brandreminder_Frame_Model();

            $brandreminder_array = $brandreminder->getRecords();
            $data['data'] = $brandreminder_array;

            return view('admin/brandreminder_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function brandreminder_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new brandreminder_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/brandreminder_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_brandreminder_poster()
    {
        $poster = new Brandreminder_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function brandreminder_poster_download_status()
    {
        $poster = new Brandreminder_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function brandreminder_poster_share_status()
    {
        $poster = new Brandreminder_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function thankyou_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $thankyou = new thankyou_Frame_Model();

            $thankyou_array = $thankyou->getRecords();
            $data['data'] = $thankyou_array;

            return view('admin/thankyou_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function thankyou_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new thankyou_Frame_Model;
            $brands = new Brands_Model;

            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $brands_data = $brands->getRecords();
            $data['brands'] = $brands_data;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/thankyou_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_thankyou_poster()
    {
        $poster = new Thankyou_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'brand' => $this->request->getPost('input_text4'),
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function thankyou_poster_download_status()
    {
        $poster = new Thankyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function thankyou_poster_share_status()
    {
        $poster = new Thankyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function select_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();

            $id = $session->get('UserID');

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/select_video_type', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function video_maker()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_video()
    {
        $video = new Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function video_download_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_share_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

      public function birthday_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $birthday = new Birthday_Video_Frame_Model();

            $birthday_array = $birthday->getRecords();
            $data['data'] = $birthday_array;

            return view('admin/birthday_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Birthday_Video_Frame_Model;

            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/birthday_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_birthday_video()
    {
        $video = new Birthday_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function birthday_video_download_status()
    {
        $poster = new Birthday_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_video_share_status()
    {
        $poster = new Birthday_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    
    public function anniversary_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $anniversary = new Anniversary_Video_Frame_Model();

            $anniversary_array = $anniversary->getRecords();
            $data['data'] = $anniversary_array;

            return view('admin/anniversary_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Anniversary_Video_Frame_Model;

            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/anniversary_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_anniversary_video()
    {
        $video = new Anniversary_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function anniversary_video_download_status()
    {
        $poster = new Anniversary_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_video_share_status()
    {
        $poster = new Anniversary_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    
    public function festival_video()
    {
        $session = session();
        if ($session->has('UserID')) {
            
            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            $festival = new Festival_Video_Frame_Model();

            $festival_array = $festival->getRecords();
            $data['data'] = $festival_array;

            return view('admin/festival_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function festival_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Festival_Video_Frame_Model;

            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';

            return view('admin/festival_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_festival_video()
    {
        $video = new Festival_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function festival_video_download_status()
    {
        $video = new Festival_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $video->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }
}