<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Regional_controller extends BaseController
{
    public function r_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->countAllResults(),
                'totalDoctors' => $doctor->where('region_id', $region_id)->countAllResults(),
                'totalPatients' => $patient->where('region_id', $region_id)->countAllResults(),
                'totalrx' => $rx->where('region_id', $region_id)->countAllResults(),
                'controller' => 'rbm'
            ];
            $data['userType'] = $session->get('userType');
            $data['Name'] = $user->where('UserID', $id)->first();


            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
            if (!empty($row)) {
          
                 // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int)($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data ['total'] = $doctor->where('doctor_data.region_id', $row['REGIONId'])->countAllResults();
            
                $data['data'] = $doctor->getTotalDoctor($data['perPage'],$data['page'],0,$row['REGIONId']);
                $data['hq'] = $hq_mdl->getHqByRegion($row['REGIONId']);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';
                $data['userType'] = $session->get('userType');
                return view('admin/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                 // Get the current page from the URL, otherwise default to page 1
                $data ['page'] = (int)($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data ['perPage'] = 500;
                // Get total number of items
                $data ['total'] = $patient->where('patient_data.region_id', $region_id)->countAllResults();
                
                $data['data'] = $patient->getTotalPatients($data ['perPage'],$data['page'],0,$region_id);
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';
                $data['userType'] = $session->get('userType');
                return view('admin/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function total_rx(){
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $hq_mdl = new Hq_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }
            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $rx->where('rx_data.region_id', $region_id)->countAllResults();
            
            $data['data'] = $rx->getTotalPatientsrx($data['perPage'],$data['page'],0,$region_id);
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';
            $data['userType'] = $session->get('userType');
            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            
            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $doctor->where('doctor_data.region_id', $row['REGIONId'])->countAllResults();
            
            $data['data'] = $doctor->gettotalDoctorEentry($data['perPage'],$data["page"],0,$row['REGIONId']);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['hq'] = $hq_mdl->getHqByRegion($row['REGIONId']);
            $data['controller'] = 'rbm';
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 5000;
            // Get total number of items
            $data ['total'] = $patient->where('patient_data.region_id', $region_id)->countAllResults();
            
            $data['data'] = $patient->where('patient_data.region_id', $region_id)->gettotalPatientEentry(500,$data["page"]);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);
            $data['controller'] = 'rbm';
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data ['page'] = (int)($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data ['perPage'] = 20;
                // Get total number of items
                $data ['total'] = $user->where('tbl_user.REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->countAllResults();
            
                $data['data'] = $user->where('tbl_user.REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->getTotalUser(20,$data["page"]);
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'rbm';
                $data['userType'] = $session->get('userType');
                return view('admin/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'rbm';
            return view('admin/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function get_doctor_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";

        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
 
                
        $doctor = new Doctor_Model();
        $table_data = $doctor->getTotalDoctor($pagesize,$page,$zone_id,$row['REGIONId'],$hq_id,$startDate,$endDate,$searchText);
        $total = count($doctor->getTotalDoctor(0,0,$zone_id,$row['REGIONId'],$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_patient_data_by_date()
    {
         $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";

        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize')?$this->request->getGet('pagesize'):500;
        
        $session = session();
         $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $patient = new Patient_Model();
        $table_data = $patient->getTotalPatients($pagesize,$page,$zone_id,$row['REGIONId'],$hq_id,$startDate,$endDate,$searchText);
        $total = count($patient->getTotalPatients(0,0,$zone_id,$row['REGIONId'],$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_rx_data_by_date()
    {
        $zone_id = $this->request->getGet('zone_id')?$this->request->getGet('zone_id'):0;
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";

        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $rx = new Rx_Model();
        $table_data = $rx->getTotalPatientsrx($pagesize,$page,0,$row['REGIONId'],$hq_id,$startDate,$endDate,$searchText);
        $total = count($rx->getTotalPatientsrx(0,0,$zone_id,$row['REGIONId'],$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }


    public function get_user_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getRegionUserByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_doctor_data_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getRegionDoctorByHQ($hq_id);
        $total = count($doctor_model->getRegionDoctorByHQ($hq_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_patient_data_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getRegionPatientByHQ($hq_id);
        $total = count($patient_model->getRegionPatientByHQ($hq_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    

    public function get_doctor_count_by_date()
    {
        $session = session();
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();
            
        $data['page'] = (int)($this->request->getGet('page') ?? 1);
        $data['perPage'] = (int)($this->request->getGet('perPage') ?? 500);
        
        $doctor = new Doctor_Model();
        $table_data = $doctor->gettotalDoctorEentry($data['perPage'],$data["page"],0,$row['REGIONId']);;
        $total = count($doctor->gettotalDoctorEentry($data['perPage'],$data["page"],0,$row['REGIONId']));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }
    public function get_user_doctor_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getRegionUserDoctorByHQ($hq_id);
        $total = count($doctor_model->getRegionUserDoctorByHQ($hq_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_user_patient_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getRegionUserPatientByHQ($hq_id);
        $total = count($patient_model->getRegionUserPatientByHQ($hq_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function r_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('rbm/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function get_rx_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRegionRxByHQ($hq_id);
        $total = count($rx_model->getRegionRxByHQ($hq_id,0,0));
        return $this->response->setJSON(['table_data' => $rx_data,"total"=>$total]);
    }

   

    public function r_add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['region'] = $user->where('UserID', $id)->getRecords();
                $row['row'] = $user->where('UserID', $id)->first();
                if (!empty($row)) {
                    foreach ($row as $zrow) {
                        $region_id = $zrow['REGIONId'];
                    }
                }

                $data['hq'] = $hq_mdl->getHqByRegion($region_id);


                $data['Name'] = $user->where('UserID', $id)->first();

                return view('rbm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_user_insert()
    {
        $user_insert = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) { $desig = 'BO'; }
        else{ $desig = 'ABM'; }
       
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
        ];
        $user_insert->save($data);
        return redirect()->to('rbm/add_user');
    }

    public function r_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $hq_mdl = new Hq_Model;
        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {
            foreach ($row as $zrow) {
                $region_id = $zrow['REGIONId'];
            }
        }
        $data['hq'] = $hq_mdl->getHqByRegion($region_id);

        $data['Name'] = $user->where('UserID', $id)->first();



        return view('rbm/user_edit', $data);
    }

    public function r_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) { $desig = 'BO'; }
        else{ $desig = 'ABM'; }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'pass' => 'telminorm',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('rbm/user_tbl');
    }
    public function r_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('rbm/user_tbl');
    }



    public function generate_excel_by_total_doctors()
    {
        try {
            
            $doctor = new Doctor_Model();
    
            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
            $region = $this->request->getGet('region')?$this->request->getGet('region'):$row['REGIONId'];
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            $searchText = $this->request->getGet('searchInput')?$this->request->getGet('searchInput'):"";
            
    
            $data = $doctor->getTotalDoctor(0,0,$zone,$region,$hq,$startDate,$endDate,$searchText);
     
            // CSV Header
            $header = ['Doctor Name', 'Cln./Hosp. Name', 'SBU Code', 'Phone','E-mail','Place','District','State','Country','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalDoctors.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['doctor'], $row['hospital'], $row['registration_no'], $row['phone'], $row['email'], $row['place'], $row['district'], $row['state'], $row['country'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
        
            // Close the output stream
            fclose($file);
        
            exit;
            

        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
      public function generate_excel_by_total_patients()
    {
        try {
            $patient = new Patient_Model();

         $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
        $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):$row['REGIONId'];
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;

        $data = $patient->getTotalPatients(0,0,$zone,$region,$hq,$startDate,$endDate);
          
        // CSV Header
        $header = ['Doctor', 'Name', 'Phone', 'Place','Gender','Age','Examination Date','Hypertension','Hypertension Drugs','Drugs Combination','ARB Prescription','ARB Dose','ACE-I Prescription','ACE-I Dose','BB Prescription','BB Dose','CCB Prescription','CCB Dose','Diuretic Prescription','Diuretic Dose','Other Prescription','Other Dose','SBP','DBP','Average SBP','Average DBP','Co-morbid Condition','Drugs for co-morbidity','Date','Employee','Emp. ID','Area','Region','Zone'];

        // Create a file pointer connected to the output stream
        $file = fopen('php://output', 'w');

        // Set headers to prompt download
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename="TotalPatient.csv"');

        // Output the header
         fputcsv($file, $header);
     

        //print_r(count($data));
        // Output each row of the data
        foreach ($data as $row) {
            fputcsv($file, [$row['doctor'], $row['name'], $row['phone'], $row['place'], $row['gender'], $row['age'], $row['examination'], $row['hypertension'], $row['hypertension_drugs'], 
                                            $row['drugs_combination'], $row['arb'], $row['arb_dose'], $row['ace_i'], $row['ace_i_dose'], $row['bb'], $row['bb_dose'], $row['ccb'], $row['ccb_dose'], $row['diuretic'], 
                                            $row['diuretic_dose'], $row['other'], $row['other_dose'], $row['sbp1'], $row['dbp1'], $row['average_sbp'], $row['average_dbp'], $row['co_morbid_conditions'], 
                                            $row['drugs_co_morbidity'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
        }
    
        // Close the output stream
        fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_total_rx()
    {
        try {

            $rx = new Rx_Model();
    
              $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            $region = $this->request->getGet('region')?$this->request->getGet('region'):$row['REGIONId'];
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
             
            $data = $rx->getTotalPatientsrx(0,0,$zone,$region,$hq,htmlspecialchars($startDate),htmlspecialchars($endDate));
           
            // CSV Header
            $header = ['Patient Name', 'Patient Phone', 'Doctor Name', 'Quantity of Strips','Indication','Secondary','Prescription Information','Co-Morbidity Prescription','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalRx.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['patient_name'], $row['phone_no'], $row['doctor_name'], $row['strips'], $row['indication'], $row['secondary'], $row['prescription_information'], $row['co_morbidity_prescription'], 
                $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
            }
        
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_doctor_users_count()
    {
        try {
         

         $doctor = new Doctor_Model();
        
          $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):$row['REGIONId'];
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;

        $data =  $doctor->gettotalDoctorEentry(0,0,$zone,$region,$hq,$startDate,$endDate);
          
          // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Doctors'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="DoctorsUserCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_patient_users_count()
    {
        try {

        $patient = new Patient_Model;

          $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):$row['REGIONId'];
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
        
        $data = $patient->gettotalPatientEentry(0,0,$zone,$region,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Patients'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalPatientsUsersCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_user_tbl()
    {
        try {
            
            $rx = new Rx_Model();

              $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
            $region = $this->request->getGet('region')?$this->request->getGet('region'):$row['REGIONId'];
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
    
            $user = new User_Model;
            $data = $user->getTotalUser(0,0,$zone,$region,$hq);
        
                
            // CSV Header
            $header = ['Employee Name', 'Phone', 'Email', 'Emp. ID','Designation','City','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
              header('Content-Type: text/csv');
              header('Content-Disposition: attachment;filename="TotalUser.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['Name'], $row['phoneNO'], $row['mail'], $row['empNO'], $row['DESIG'], $row['city'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
            
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }

    
}