<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Video_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Regional_controller extends BaseController
{
    public function r_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();
            $posterModel = new Poster_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->getTotalUsers(),
                'totalDoctors' => $doctor->where('region_id', $region_id)->getTotalDoctors(),
                'totalPatients' => $patient->where('region_id', $region_id)->getTotalPatient(),
                'totalrx' => $rx->where('region_id', $region_id)->getTotalRxUser(),
                'totalPosters' => $posterModel->getTotalPostersByRegion($region_id),
                'totalVideos' => $videosModel->getTotalVideosByRegion($region_id),
            ];

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                $data['data'] = $user->where('tbl_user.REGIONId', $region_id)->where('UserID !=', $id)->where('DESIG !=', 'ZBM')->getTotalUser();
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('rbm/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function get_user_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getRegionUserByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function r_total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                $data['data'] = $doctor->where('doctor_data.region_id', $region_id)->getTotalDoctor();
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('rbm/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function get_doctor_data_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getRegionDoctorByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function r_total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }

                $data['data'] = $patient->where('patient_data.region_id', $region_id)->getTotalPatients();
                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('rbm/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function get_patient_data_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getRegionPatientByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function r_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $doctor->where('doctor_data.region_id', $region_id)->gettotalDoctorEentry();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_user_doctor_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getRegionUserDoctorByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function r_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $patient->where('patient_data.region_id', $region_id)->gettotalPatientEentry();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_user_patient_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getRegionUserPatientByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function r_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $hq_mdl = new Hq_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $rx->where('rx_data.region_id', $region_id)->getTotalPatientsrx();
            $data['hq'] = $hq_mdl->getHqByRegion($region_id);

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_rx_by_hq()
    {
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getRegionRxByHQ($hq_id);

        return $this->response->setJSON(['table_data' => $rx_data]);
    }

    public function r_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $hq_mdl = new Hq_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['region'] = $user->where('UserID', $id)->getRecords();
                $row['row'] = $user->where('UserID', $id)->first();
                if (!empty($row)) {
                    foreach ($row as $zrow) {
                        $region_id = $zrow['REGIONId'];
                    }
                }

                $data['hq'] = $hq_mdl->getHqByRegion($region_id);

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('rbm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function r_user_insert()
    {
        $user_insert = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } else {
            $desig = 'ABM';
        }

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
        ];
        $user_insert->save($data);
        return redirect()->to('rbm/add_user');
    }

    public function r_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $hq_mdl = new Hq_Model;
        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {
            foreach ($row as $zrow) {
                $region_id = $zrow['REGIONId'];
            }
        }
        $data['hq'] = $hq_mdl->getHqByRegion($region_id);

        $data['Name'] = $user->where('UserID', $id)->first();

        $FrameModel = new Frame_Model();
        $campaign = $FrameModel->getAllCampaignsWithFrames();
        $data['campaigns'] = $campaign;

        return view('rbm/user_edit', $data);
    }

    public function r_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } else {
            $desig = 'ABM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'pass' => 'telminorm',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('rbm/user_tbl');
    }
    public function r_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('rbm/user_tbl');
    }

    public function r_totel_poster()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $posterModel->getPosterWithUsersDetailsByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_totel_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $videosModel->getVideosWithUsersDetailsByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_users_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            // Fetch user count data for the same region
            $data['data'] = $posterModel->getUserCountByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_users_date_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $region_id = $zrow['REGIONId'];
                }
            }

            $data['data'] = $posterModel->getEntryByDateByRegion($region_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    
    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();
            
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function poster_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function video_maker()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('rbm/video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_video()
    {
        $video = new Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function video_download_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_share_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

}