<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\API\ResponseTrait;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\User_Model;
use App\Models\Rx_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\EmployeeModel;
use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;

class Users extends BaseController
{
      use ResponseTrait;
    public function index()
    {
        //
    }
    
    public function editUser()
    {
         $input = $this->getRequestInput($this->request);
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256')); 
        $User = new User_Model;
        
         // Check if user exists
        $user = $User->where("UserID",$decoded->email)->first();
        if (!$user) {
            return $this->respond(['status' => 'success', 'message' => 'User not found'], 200);
        }
        $data = [
            'Name' => $input['name'],
            'mail' => $input['email'],
            'phoneNO' => $input['phone']
        ];
  
        // Delete user
        if ($User->update($decoded->email,$data)) {
            return $this->respond(['status' => 'success','user'=>$User->getUserByUserId($decoded->email), 'message' => 'User Update'], 200);
        } else {
           return $this->respond([ 'message' => 'Try again User deleted'], 200);
        }
        
    }
    
     public function delateUser()
     {
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256')); 
        $User = new User_Model;
        
         // Check if user exists
        $user = $User->where("UserID",$decoded->email)->first();
        if (!$user) {
            return $this->respond(['status' => 'success', 'message' => 'User not found'], 200);
        }
        $data = [
            'isActive' => 0
        ];
     
        // Delete user
        if ($User->update($decoded->email,$data)) {
            return $this->respond(['status' => 'success', 'message' => 'User deleted'], 200);
        } else {
           return $this->respond([ 'message' => 'Try again User deleted'], 200);
        }

     }
    public function myHQ()
    {
        try {
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $User = new User_Model;
            $row['row'] = $User->where('UserID', $decoded->email)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $Region_id = $zrow['REGIONId'];
                }
            }
            
            $HQ = new Hq_Model;
            $client = $HQ->where('region_id', $Region_id)->findAll();
            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    public function myRegion()
    {
        try {
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $User = new User_Model;
             $row['row'] = $User->where('UserID', $decoded->email)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }
            
            $Region = new Region_Model;
            $client = $Region->where('ZONEId', $zone_id)->findAll();
            
            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    public function myZone()
    {
        try {
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            
            $Region = new Zone_Model;
            $client = $Region->findAll();
            
            return $this->respond($client, 200);
            
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function synchData($userId){
        try {

            $input = $this->getRequestInput($this->request);
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            
            $role_id = $decoded->role_id;
            $doctor = new Doctor_Model;
            $Patient = new Patient_Model;
            $PatientRx = new Rx_Model;
                     
            if($input['lastSynch']){
                if($role_id=="1"){
                    $array = array('user_id' => $userId, 'date >' => $input['lastSynch']);
                    $doc = $doctor->where($array)->orderBy('id', 'DESC')->findAll();
                    $pat_d = $Patient->findPatientbyUser($decoded->email);
                    $pat_dRx = $PatientRx->findPatientRxbyUser($decoded->email);
                }else if($role_id=="2"){
                    $doc = $doctor->getDocterByUserHQ($userId);
                    $pat_d = $Patient->findPatientbyHQ($client['HQ_Id']);
                    $pat_dRx = $PatientRx->findPatientRxbyHQ($client['HQ_Id']);
                }else if($role_id=="3"){
                    $doc = $doctor->getDocterByUserRegion($userId);
                    $pat_d = $Patient->findPatientbyRegion($client['REGIONId']);
                    $pat_dRx = $PatientRx->findPatientRxbyRegion($client['REGIONId']);
                }else if($role_id=="4"){
                    $doc = $doctor->getDocterByUserZone($userId);
                    $pat_d = $Patient->findPatientbyZone($client['zoneId']);
                    $pat_dRx = $PatientRx->findPatientRxbyZone($client['zoneId']);
                }else{
                    $array = array('date >' => $input['lastSynch']);
                    $doc = $doctor->where($array)->orderBy('id', 'DESC')->findAll();
                    $pat_d = $Patient->where($array)->findAll();
                    $pat_dRx = $PatientRx->where($array)->findAll();
                }
            
                $data['doctor'] = $doc;
                $data['patient'] = $pat_d;
                $data['patientRx'] = $pat_dRx;
                return $this->respond($data, 200);
            }else{
                if($role_id=="1"){
                    $doc = $doctor->where('user_id',$userId)->orderBy('id', 'DESC')->findAll();
                    $pat_d = $Patient->findPatientbyUser($decoded->email);
                    $pat_dRx = $PatientRx->findPatientRxbyUser($decoded->email);
                }else if($role_id=="2"){
                    $doc = $doctor->getDocterByUserHQ($userId);
                    $pat_d = $Patient->findPatientbyHQ($client['HQ_Id']);
                    $pat_dRx = $PatientRx->findPatientRxbyHQ($client['HQ_Id']);
                }else if($role_id=="3"){
                    $doc = $doctor->getDocterByUserRegion($userId);
                    $pat_d = $Patient->findPatientbyRegion($client['REGIONId']);
                    $pat_dRx = $PatientRx->findPatientRxbyRegion($client['REGIONId']);
                }else if($role_id=="4"){
                    $doc = $doctor->getDocterByUserZone($userId);
                    $pat_d = $Patient->findPatientbyZone($client['zoneId']);
                    $pat_dRx = $PatientRx->findPatientRxbyZone($client['zoneId']);
                }else{
                  $doc = $doctor->orderBy('id', 'DESC')->findAll();
                  $pat_d = $Patient->findAll();
                  $pat_dRx = $PatientRx->findAll();
                }
            
                $data['doctor'] = $doc;
                $data['patient'] = $pat_d;
                $data['patientRx'] = $pat_dRx;
                return $this->respond($data, 200);
            }
            
            
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    
     public function getDoctorTotal()
    {
        try {
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            
            $rx = new Rx_Model();
            $client = $rx->getTotalData();
            
            return $this->respond($client, 200);
            
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function myProfile()
    {
        try {
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            
            $user = new User_Model;
            $client = $user->getUserByUserId($userId);
            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function list()
    {
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));

        $user = new User_Model;
        $client = $user->getUserByUserId($decoded->email);
        $str = $this->request->getGet('name')?$this->request->getGet('name'):"";
        try { 
            if($decoded->role_id==2 || $decoded->role_id==1){ 
                 $list = $user->getRegionUserByHQ($client['HQ_Id'],$str);
            }else if($decoded->role_id==3){ 
                 $list = $user->getZoneUserByRegion($client['REGIONId'],$str);
            }else if($decoded->role_id==4){ 
                $list = $user->getUserDataByZone($client['zoneId'],0,0,$str);
            }else if($decoded->role_id==5){
                if($str==""){
                   $list = $user->findAll();
                }else{
                   $list = $user->like('Name', $str)->findAll(); 
                }
                 
            }
            return $this->respond($list, 200);

        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    public function getPatientBycamp($id)
    {
        $Patient = new PatientModel;
        try { 
         
         $list = $Patient->findPatientByCampId($id);

         if(empty($list)) {  
             return $this->respond( [
                    'message' => 'Not Found'
                ], 200);
         }else{
           return $this->respond($list, 200);
         }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    public function camplist($id)
    {
        try {
            $camp = new PatientModel;
            $client = $camp->findPatientByCampId($id);

            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    public function show($id)
    {
        try {
            $camp = new PatientModel;
            $client = $camp->where('patient_phone', $id)->first();
            return $this->respond($client, 200);
        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function savaEmployee()
    {
         try {
            $patient = new User_Model;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));

            $input['createdBy'] = $decoded->email;
            
            if($patient->save($input)){
                return $this->respond(['message' => 'insert'],200);
            }else{
                return $this->respond(['message' => 'try camp not save successfully'],200);
            }
         } catch (Exception $e) {
            return $this->respond(['message' => 'Could not find client for specified ID'],ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    
    public function create()
    {
         try {
            $patient = new PatientModel;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            $input['createdBy'] = $userId;
            
            if($patient->save($input)){
                $input['patient_Id'] = $patient->getInsertID();
                 $patientMap = new Rx_Model;
                 if($this->request->getFile('previous_rx')){
                    $img = $this->request->getFile('previous_rx');
                    $img->move(FCPATH . 'uploads');
                    $input['previous_rx'] = $img->getName();
                 }
                 if($this->request->getFile('new_rx')){
                    $img = $this->request->getFile('new_rx');
                    $img->move(FCPATH . 'uploads'); 
                    $input['new_rx'] = $img->getName();
                 }
                if($patientMap->save($input)){
                    return $this->respond(['message' => 'insert'],200);
                }else{
                    return $this->respond(['message' => ''],200);
                }
            }else{
                return $this->respond(['message' => 'try camp not save successfully'],200);
            }
         } catch (Exception $e) {
            return $this->respond(['message' => 'Could not find client for specified ID'],ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    public function addpatient()
    {
         try {
            $patientMap = new Rx_Model;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            $input['createdBy'] = $userId;
            
            if($patientMap->save($input)){
                    return $this->respond(
                        [
                            'message' => 'insert'
                        ],
                        200
                    );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }   

    public function update($id)
    {
         try {
            $camp = new CampModel;
            $input = $this->getRequestInput($this->request);
            if($camp->update($id,$input)){
                return $this->respond(
                    [
                        'message' => 'In Next 7 Days Plan will be freeze ant changes after this subject to approval from seniors'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function delete($id)
    {
        try {
            $camp = new CampModel;
            if($camp->delete($id)){
                return $this->respond(
                    [
                        'message' => 'Camp delete successfully'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function upload($id)
    {
        try {
             
            $gallery = new GalleryModel;
            $img = $this->request->getFile('file');
            $img->move(FCPATH . 'uploads');
            
            $data = ['camp_id' => $id,"camp_photo"=>$img->getName()];
            
            if($gallery->save($data)){
                return $this->respond(['message' => ''],200);
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => $e->getMessage()
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    
    public function patientByDoctor($doctorId)
    {

        $Patient = new Patient_Model;
   
        try { 

             $list = $Patient->where("dr_id",$doctorId)->findAll();
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    
    public function findPatients()
    {
         $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));
        $Patient = new Patient_Model;
        $user = new User_Model;
        $client = $user->getUserByUserId($decoded->email);
        
        $str = $this->request->getGet('name')?$this->request->getGet('name'):"";
        
        try { 
        
            $list = $Patient->like('name', $str)->where("user_id",$decoded->email)->findAll(); 
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    public function patient()
    {
         $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));
        $Patient = new Patient_Model;
        $user = new User_Model;
        $client = $user->getUserByUserId($decoded->email);
        
        $str = $this->request->getGet('name')?$this->request->getGet('name'):"";
        
        try { 
        
            if($decoded->role_id==1){ 
                if($str==""){
                    $list = $Patient->where('patient_data.user_id', $decoded->email)->getPatientUser();
                }else{
                    $list = $Patient->where('patient_data.user_id', $decoded->email)->like('name', $str)->getPatientUser(); 
                }
            }else if($decoded->role_id==2){ 
                 $list = $Patient->findPatientbyHQ($client['HQ_Id']);
            }else if($decoded->role_id==3){ 
                 $list = $Patient->findPatientbyRegion($client['REGIONId']);
            }else if($decoded->role_id==4){ 
                 $list = $Patient->findPatientbyZone($client['zoneId']);
            }else if($decoded->role_id==5){ 
                 $list = $Patient->findAll();
            }
           
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    public function patientRx()
    {
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));
        $PatientRx = new Rx_Model;
        
        $user = new User_Model;
        $client = $user->getUserByUserId($decoded->email);
        
        try { 
            if($decoded->role_id==1){ 
                  $list = $PatientRx->findPatientRxbyUser($decoded->email);
            }else if($decoded->role_id==2){ 
                 $list = $PatientRx->findPatientRxbyHQ($client['HQ_Id']);
            }else if($decoded->role_id==3){ 
                 $list = $PatientRx->findPatientRxbyRegion($client['REGIONId']);
            }else if($decoded->role_id==4){ 
                 $list = $PatientRx->findPatientRxbyZone($client['zoneId']);
            }else if($decoded->role_id==5){ 
                 $list = $PatientRx->findAll();
            }
              
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    public function uploadimg()
    { 
         $input = $this->getRequestInput($this->request);
        
        $img = $this->request->getFile('image');
        $name = str_replace(' ', '_', $input['patient_name']);
   
        $uploadPath = FCPATH . 'assets/patient_data/'.$name;
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0755, true);
        }
        if($img->move($uploadPath)){
            return $this->respond(['image' => $name."/".$img->getName()],200);
        }else{
            return $this->respond(['image' => "Prescription Not Uploaded"],200);
        }
        
    }
    public function savePatientRx()
    {
         try {
            $patient = new Patient_Model;
            $input = $this->getRequestInput($this->request);

            $patientMap = new Rx_Model;
            
            if($patientMap->save($input)){ 
                
                return $this->respond(['message' => 'insert',"input"=>$input],200);
            }else{
                return $this->respond(['message' => 'try camp not save successfully'],200);
            }
                
         } catch (Exception $e) {
            return $this->respond(['message' => 'Could not find client for specified ID'],ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    
    
     public function updatePatient($patient_id)
    {
       
          try {
            $patient = new Patient_Model;
            $input = $this->getRequestInput($this->request);
           
            if($patient->update($patient_id,$input)){
                  $input['patient_id'] = $patient_id;
             
                    return $this->respond(['message' => 'insert',"input"=>$input],200);

            }else{
                return $this->respond(['message' => 'try camp not save successfully'],200);
            }
         } catch (Exception $e) {
            return $this->respond(['message' => 'Could not find client for specified ID'],ResponseInterface::HTTP_NOT_FOUND);
        }
    }
     public function savePatient()
    {
         try {
            $patient = new Patient_Model;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;

            
            if($patient->save($input)){
                return $this->respond(['message' => 'insert','patient_Id'=>$patient->getInsertID()],200);
            }else{
                return $this->respond(['message' => 'try camp not save successfully'],200);
            }
         } catch (Exception $e) {
            return $this->respond(['message' => 'Could not find client for specified ID'],ResponseInterface::HTTP_NOT_FOUND);
        }
    }
    
     public function patientCount()
    {
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));
        $UserModel = new User_Model;
        
        $client = $UserModel->getUserByUserId($decoded->email);
         $patient = new Patient_Model;
         
        try { 
           if($decoded->role_id==2){ 
                 $list = $patient->where('hq_id', $client['HQ_Id'])->gettotalPatientEentry();
            }else if($decoded->role_id==3){ 
                   $list = $patient->where('patient_data.region_id', $client['REGIONId'])->gettotalPatientEentry();
            }else if($decoded->role_id==4){ 
                   $list = $patient->where('zone_id', $client['zoneId'])->gettotalPatientEentry();
            }else if($decoded->role_id==5){ 
                   $list = $patient->gettotalPatientEentry();
            }
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
     public function doctorCount()
    {
        $key = getenv('JWT_SECRET');
        $header = $this->request->getHeader("Authorization");
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }
        $decoded = JWT::decode($token, new Key($key, 'HS256'));
        $UserModel = new User_Model;
        $client = $UserModel->getUserByUserId($decoded->email);
         
         $doctor = new Doctor_Model;
        
         
        try { 
             if($decoded->role_id==2){ 
                 $list = $doctor->where('hq_id', $client['HQ_Id'])->gettotalDoctorEentry(); 
            }else if($decoded->role_id==3){ 
                  $list = $doctor->where('doctor_data.region_id', $client['REGIONId'])->gettotalDoctorEentry(); 
            }else if($decoded->role_id==4){ 
                 $list = $doctor->where('zone_id', $client['zoneId'])->gettotalDoctorEentry(); 
            }else if($decoded->role_id==5){ 
                 $list = $doctor->gettotalDoctorEentry();
            }
             if(empty($list)) {  
                 return $this->respond( [
                        'message' => 'Not Found'
                    ], 200);
             }else{
               return $this->respond($list, 200);
             }
           
        } catch (Exception $e) {
          //alert the user.
          return $this->respond( [  
                'message' => $e->getMessage(),
            ], 200);
        }
    }
    
    
}
