<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Zone_controller extends BaseController
{

    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zoneId = $zrow['zoneId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('zoneId', $zoneId)->where('UserID !=', $id)->countAllResults(),
                'totalDoctors' => $doctor->where('zone_id', $zoneId)->countAllResults(),
                'totalPatients' => $patient->where('zone_id', $zoneId)->countAllResults(),
                'totalrx' => $rx->where('zone_id', $zoneId)->countAllResults(),
                'controller' => 'zone'
            ];
            $data['userType'] = $session->get('userType');
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();
            $region_mdl = new Region_Model();
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $doctor->where('zone_Id', $zone_id)->countAllResults();
                
            $data['data'] = $doctor->getTotalDoctor($data['perPage'],$data['page'],$zone_id);
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'zone';
            $data['userType'] = $session->get('userType');
            return view('admin/total_doctors', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model();
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $patient->where('patient_data.zone_Id', $zone_id)->countAllResults();
                
            $data['data'] = $patient->getTotalPatients($data ['perPage'],$data['page'],$zone_id);
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'zone';
            $data['userType'] = $session->get('userType');
            return view('admin/total_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_rx(){
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $rx->where('zone_Id', $zone_id)->countAllResults();
            
            $data['data'] = $rx->getTotalPatientsrx($data['perPage'],$data['page'],$zone_id);
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'zone';
            $data['userType'] = $session->get('userType');
            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data ['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $doctor->where('zone_Id', $zone_id)->countAllResults();
            
            $data['data'] = $doctor->gettotalDoctorEentry($data ['perPage'],$data["page"],$zone_id);
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'zone';
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = count($patient->gettotalPatientEentry(0,0,$zone_id));
            
            $data['data'] = $patient->gettotalPatientEentry($data['perPage'],$data["page"],$zone_id);
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'zone';
            $data['userType'] = $session->get('userType');
            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user_mdl = new User_Model;
            $region_mdl = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user_mdl->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data ['page'] = (int)($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data ['total'] = $user_mdl->where('tbl_user.zoneId', $zone_id)->where('UserID !=', $id)->countAllResults();
                
            $data['data'] = $user_mdl->where('tbl_user.zoneId', $zone_id)->where('UserID !=', $id)->getTotalUser($data['perPage'],$data["page"]);
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);
            $data['Name'] = $user_mdl->where('UserID', $id)->first();
            $data['controller'] = 'zone';
            $data['userType'] = $session->get('userType');
            return view('admin/user_table', $data);
        } else {
            return redirect()->to('/index');
        }

    }

    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['userType'] = $session->get('userType');
            $data['controller'] = 'zone';
            return view('admin/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    

    public function get_user_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $user_model = new User_Model();
        $user_data = $user_model->getZoneUserByRegion($region_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_user_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getZoneUserByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_hq_by_region()
    {
        $region_id = $this->request->getVar('region_id');
        $hq_model = new Hq_Model();
        $hqs = $hq_model->getHqByRegion($region_id);
        echo json_encode($hqs);
    }
    public function add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $region = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $row['row'] = $user->where('UserID', $id)->first();
                if (!empty($row)) {
                    foreach ($row as $zrow) {
                        $zone_id = $zrow['zoneId'];
                    }
                }

               $region = new Region_Model;
                $region_array = $region->where('ZONEId', $zone_id)->getRecords();
                $data['region'] = $region_array;

                $data['zone_id'] = $zone_id;

                $data['Name'] = $user->where('UserID', $id)->first();

                return view('zone/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function user_insert()
    {
        $user_insert = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) { $desig = 'BO'; }
        elseif ($userType == 2) { $desig = 'ABM'; }
        else { $desig = 'RBM'; }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
        ];
        $user_insert->save($data);
        return redirect()->to('zone/add_user');
    }

    public function user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $region = new Region_Model;

        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {

            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $REGIONId = $zrow['REGIONId'];
                }
            }

            $reg['region'] = $region->where('REGIONId', $REGIONId)->first();
            if (!empty($reg)) {
                foreach ($reg as $zregion) {
                    $zone_id = $zregion['ZONEId'];
                }

                $region = new Region_Model;
                $region_array = $region->where('ZONEId', $zone_id)->getRecords();
                $data['region'] = $region_array;
            }
        }

        $data['Name'] = $user->where('UserID', $id)->first();

        return view('zone/user_edit', $data);
    }

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('userType');
        if ($userType == 1) { $desig = 'BO'; }
        elseif ($userType == 2) { $desig = 'ABM'; }
        else { $desig = 'RBM'; }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('userType'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'pass' => 'telminorm',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('zone/user_tbl');
    }

    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('zone/user_tbl');
    }

   

    public function get_doctor_data_by_date()
    {
         $session = session();
         $user = new User_Model;
         $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $doctor = new Doctor_Model();
        $table_data = $doctor->getTotalDoctor($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        $total = count($doctor->getTotalDoctor(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_patient_data_by_date()
    {
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        $session = session();
         $user = new User_Model;
         $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }
        $patient = new Patient_Model();
        $table_data = $patient->getTotalPatients($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        $total = count($patient->getTotalPatients(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_rx_data_by_date()
    {
         $session = session();
         $user = new User_Model;
         $id = $session->get('UserID');
         $row = $user->where('UserID', $id)->first();
            
        $zone_id = $row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');
        
        $rx = new Rx_Model();
        $table_data = $rx->getTotalPatientsrx($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        
        $total = count($rx->getTotalPatientsrx(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));

        return $this->response->setJSON(['table_data' => $table_data,'total'=>$total]);
    }


    public function get_doctor_data_by_region()
    {
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneDoctorByRegion($region_id);
        $total = count($doctor_model->getZoneDoctorByRegion($region_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_doctor_data_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model-> getZoneDoctorByHQ($hq_id, $region_id);
        $total = count($doctor_model->getZoneDoctorByHQ($hq_id, $region_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_user_doctor_by_region()
    {
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneUserDoctorByRegion($region_id);
        $total = count($doctor_model->getZoneUserDoctorByRegion($region_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_user_doctor_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneUserDoctorByHQ($hq_id, $region_id);
        $total = count($doctor_model->getZoneUserDoctorByHQ($hq_id, $region_id,0,0));
        return $this->response->setJSON(['table_data' => $table_data,"total"=>$total]);
    }

    public function get_patient_count_by_date()
    {
        $session = session();
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $user = new User_Model;
        $id = $session->get('UserID');
        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {
            foreach ($row as $zrow) {
                $zone_id = $zrow['zoneId'];
            }
        }

        $patient_model = new Patient_Model();
        $patient_data = $patient->gettotalPatientEentry($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        $total = count($patient->gettotalPatientEentry(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $patient_data]);
    }
    public function get_doctor_count_by_date()
    {
        $session = session();
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $user = new User_Model;
        $id = $session->get('UserID');
        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {
            foreach ($row as $zrow) {
                $zone_id = $zrow['zoneId'];
            }
        }

        $patient_model = new Patient_Model();
        $patient_data = $doctor->gettotalDoctorEentry($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
         $total = count($doctor->gettotalDoctorEentry(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function get_patient_data_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZonePatientByRegion($region_id);

        $total = count($patient_model->getZonePatientByRegion($region_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

    public function get_patient_data_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZonePatientByHQ($hq_id, $region_id);

        $total = count($patient_model->getZonePatientByHQ($hq_id, $region_id,0,0));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }

   

    public function get_user_patient_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZoneUserPatientByRegion($region_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_user_patient_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZoneUserPatientByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('zone/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function get_total_rx_data()
    {
        $session = session();
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $searchText = $this->request->getGet('searchText')?$this->request->getGet('searchText'):"";
        $region_id = $this->request->getGet('region_id')?$this->request->getGet('region_id'):0;
        $hq_id = $this->request->getGet('hq_id')?$this->request->getGet('hq_id'):0;
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $user = new User_Model;
        $id = $session->get('UserID');
        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {
            foreach ($row as $zrow) {
                $zone_id = $zrow['zoneId'];
            }
        }
        $rx = new rx_Model;
        $patient_data = $rx->getTotalPatientsrx($pagesize,$page,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText);
        $total = count($rx->getTotalPatientsrx(0,0,$zone_id,$region_id,$hq_id,$startDate,$endDate,$searchText));
        return $this->response->setJSON(['table_data' => $patient_data,"total"=>$total]);
    }
    

    public function get_rx_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getZoneRxByRegion($region_id);
        $total = count($rx_model->getZoneRxByRegion($region_id,0,0));
        return $this->response->setJSON(['table_data' => $rx_data,"total"=>$total]);
    }

    public function get_rx_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getZoneRxByHQ($hq_id, $region_id);
        $total = count($rx_model->getZoneRxByHQ($hq_id, $region_id,0,0));
        return $this->response->setJSON(['table_data' => $rx_data,"total"=>$total]);
    }




     public function generate_excel_by_total_doctors()
    {
        try {
            
            $doctor = new Doctor_Model();
    
            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
            $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            
    
            $data = $doctor->getTotalDoctor(0,0,$zone,$region,$hq,$startDate,$endDate);
    
            // CSV Header
            $header = ['Doctor Name', 'Cln./Hosp. Name', 'SBU Code', 'Phone','E-mail','Place','District','State','Country','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalDoctors.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['doctor'], $row['hospital'], $row['registration_no'], $row['phone'], $row['email'], $row['place'], $row['district'], $row['state'], $row['country'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
        
            // Close the output stream
            fclose($file);
        
            exit;

        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
      public function generate_excel_by_total_patients()
    {
        try {
            $patient = new Patient_Model();

         $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
        $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;

        $data = $patient->getTotalPatients(0,0,$zone,$region,$hq,$startDate,$endDate);
          
        // CSV Header
        $header = ['Doctor', 'Name', 'Phone', 'Place','Gender','Age','Examination Date','Hypertension','Hypertension Drugs','Drugs Combination','ARB Prescription','ARB Dose','ACE-I Prescription','ACE-I Dose','BB Prescription','BB Dose','CCB Prescription','CCB Dose','Diuretic Prescription','Diuretic Dose','Other Prescription','Other Dose','SBP','DBP','Average SBP','Average DBP','Co-morbid Condition','Drugs for co-morbidity','Date','Employee','Emp. ID','Area','Region','Zone'];

        // Create a file pointer connected to the output stream
        $file = fopen('php://output', 'w');

        // Set headers to prompt download
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename="TotalPatient.csv"');

        // Output the header
         fputcsv($file, $header);
     

        //print_r(count($data));
        // Output each row of the data
        foreach ($data as $row) {
            fputcsv($file, [$row['doctor'], $row['name'], $row['phone'], $row['place'], $row['gender'], $row['age'], $row['examination'], $row['hypertension'], $row['hypertension_drugs'], 
                                            $row['drugs_combination'], $row['arb'], $row['arb_dose'], $row['ace_i'], $row['ace_i_dose'], $row['bb'], $row['bb_dose'], $row['ccb'], $row['ccb_dose'], $row['diuretic'], 
                                            $row['diuretic_dose'], $row['other'], $row['other_dose'], $row['sbp1'], $row['dbp1'], $row['average_sbp'], $row['average_dbp'], $row['co_morbid_conditions'], 
                                            $row['drugs_co_morbidity'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
        }
    
        // Close the output stream
        fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_total_rx()
    {
        try {

            $rx = new Rx_Model();
    
              $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
            $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
            $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
            $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
            $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
            
            $data = $rx->getTotalPatientsrx(0,0,$zone,$region,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Patient Name', 'Patient Phone', 'Doctor Name', 'Quantity of Strips','Indication','Secondary','Prescription Information','Co-Morbidity Prescription','Date','Employee','Emp. ID','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalRx.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['patient_name'], $row['phone_no'], $row['doctor_name'], $row['strips'], $row['indication'], $row['secondary'], $row['prescription_information'], $row['co_morbidity_prescription'], 
                $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);
            }
        
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_doctor_users_count()
    {
        try {
         

         $doctor = new Doctor_Model();
        
          $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;

        $data =  $doctor->gettotalDoctorEentry(0,0,$zone,$region,$hq,$startDate,$endDate);
          
          // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Doctors'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="DoctorsUserCount .csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
            
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_patient_users_count()
    {
        try {

        $patient = new Patient_Model;

          $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
        $startDate = $this->request->getGet('startDate')?$this->request->getGet('startDate'):"";
        $endDate = $this->request->getGet('endDate')?$this->request->getGet('endDate'):"";
        $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
        $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
        
        $data = $patient->gettotalPatientEentry(0,0,$zone,$region,$hq,$startDate,$endDate);
            
            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region','Zone','Totel Patients'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalPatientsUsersCount.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }
        
            // Close the output stream
            fclose($file);
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    
    public function generate_excel_by_user_tbl()
    {
        try {
            
            $rx = new Rx_Model();

              $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
         
            echo $zone = $this->request->getGet('zone')?$this->request->getGet('zone'):$row['zoneId'];
            echo $region = $this->request->getGet('region')?$this->request->getGet('region'):0;
            echo $hq = $this->request->getGet('hq')?$this->request->getGet('hq'):0;
    
            $user = new User_Model;
            $data = $user->getTotalUser(0,0,$zone,$region,$hq);
        
                
            // CSV Header
            $header = ['Employee Name', 'Phone', 'Email', 'Emp. ID','Designation','City','Area','Region','Zone'];
    
            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');
    
            // Set headers to prompt download
              header('Content-Type: text/csv');
              header('Content-Disposition: attachment;filename="TotalUser.csv"');
    
            // Output the header
             fputcsv($file, $header);
         
    
            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['Name'], $row['phoneNO'], $row['mail'], $row['empNO'], $row['DESIG'], $row['city'], $row['HQ'], $row['REGION'], $row['ZONE']]);
               
            }
            
            // Close the output stream
            fclose($file);
        
        exit;
        }
        //catch exception
        catch(Exception $e) {
          echo 'Message: ' .$e->getMessage();
        }
        
    }
    


}