<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Video_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Zone_controller extends BaseController
{

    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model();
            $patient = new Patient_Model();
            $rx = new Rx_Model();
            $posterModel = new Poster_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zoneId = $zrow['zoneId'];
                }
            }

            $data = [
                'totalUsers' => $user->where('zoneId', $zoneId)->where('UserID !=', $id)->getTotalUsers(),
                'totalDoctors' => $doctor->where('zone_id', $zoneId)->getTotalDoctors(),
                'totalPatients' => $patient->where('zone_id', $zoneId)->getTotalPatient(),
                'totalrx' => $rx->where('zone_id', $zoneId)->getTotalRxUser(),
                'totalPosters' => $posterModel->getTotalPostersByZone($zoneId),
                'totalVideos' => $videosModel->getTotalVideosByZone($zoneId),

            ];

            $data['Name'] = $user->where('UserID', $id)->first();

            
            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user_mdl = new User_Model;
            $region_mdl = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user_mdl->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $user_mdl->where('tbl_user.zoneId', $zone_id)->where('UserID !=', $id)->getTotalUser();
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);
            $data['Name'] = $user_mdl->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/user_table', $data);
        } else {
            return redirect()->to('/index');
        }

    }

    public function get_user_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $user_model = new User_Model();
        $user_data = $user_model->getZoneUserByRegion($region_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_user_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $user_model = new User_Model();
        $user_data = $user_model->getZoneUserByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $user_data]);
    }

    public function get_hq_by_region()
    {
        $region_id = $this->request->getVar('region_id');
        $hq_model = new Hq_Model();
        $hqs = $hq_model->getHqByRegion($region_id);
        echo json_encode($hqs);
    }
    public function add_user()
    {

        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $region = new Region_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $row['row'] = $user->where('UserID', $id)->first();
                if (!empty($row)) {
                    foreach ($row as $zrow) {
                        $zone_id = $zrow['zoneId'];
                    }
                }

                $region = new Region_Model;
                $region_array = $region->where('ZONEId', $zone_id)->getRecords();
                $data['region'] = $region_array;

                $data['zone_id'] = $zone_id;

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('zone/add_user', $data);
            } else {
                return redirect()->to('/index');
            }

        }
    }

    public function user_insert()
    {
        $user_insert = new User_Model;
        $userType = $this->request->getVar('user_type');
        if ($userType == 1) {
            $desig = 'BO';
        } elseif ($userType == 2) {
            $desig = 'ABM';
        } else {
            $desig = 'RBM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
        ];
        $user_insert->save($data);
        return redirect()->to('zone/add_user');
    }

    public function user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $region = new Region_Model;

        $row['row'] = $user->where('UserID', $id)->first();
        if (!empty($row)) {

            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $REGIONId = $zrow['REGIONId'];
                }
            }

            $reg['region'] = $region->where('REGIONId', $REGIONId)->first();
            if (!empty($reg)) {
                foreach ($reg as $zregion) {
                    $zone_id = $zregion['ZONEId'];
                }

                $region = new Region_Model;
                $region_array = $region->where('ZONEId', $zone_id)->getRecords();
                $data['region'] = $region_array;
            }
        }

        $data['Name'] = $user->where('UserID', $id)->first();

        $FrameModel = new Frame_Model();
        $campaign = $FrameModel->getAllCampaignsWithFrames();
        $data['campaigns'] = $campaign;

        return view('zone/user_edit', $data);
    }

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $userType = $this->request->getVar('userType');
        if ($userType == 1) {
            $desig = 'BO';
        } elseif ($userType == 2) {
            $desig = 'ABM';
        } else {
            $desig = 'RBM';
        }
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('userType'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => $desig,
            'REGIONId' => $this->request->getVar('region'),
            'pass' => 'telminorm',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('zone/user_tbl');
    }
    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('zone/user_tbl');
    }

    public function total_Doctors()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model();
            $region_mdl = new Region_Model();
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $doctor->where('zone_Id', $zone_id)->getTotalDoctor();
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/total_doctors', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_doctor_data_by_region()
    {
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneDoctorByRegion($region_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_doctor_data_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneDoctorByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $doctor->where('zone_Id', $zone_id)->gettotalDoctorEentry();
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function get_user_doctor_by_region()
    {
        $region_id = $this->request->getPost('region_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneUserDoctorByRegion($region_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }

    public function get_user_doctor_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');
        $doctor_model = new Doctor_Model();
        $table_data = $doctor_model->getZoneUserDoctorByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $table_data]);
    }


    public function total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model();
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $patient->where('patient_data.zone_Id', $zone_id)->getTotalPatients();
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/total_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function get_patient_data_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZonePatientByRegion($region_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_patient_data_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZonePatientByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $patient->where('zone_Id', $zone_id)->gettotalPatientEentry();
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_user_patient_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZoneUserPatientByRegion($region_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function get_user_patient_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $patient_model = new Patient_Model();
        $patient_data = $patient_model->getZoneUserPatientByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $patient_data]);
    }

    public function doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $region_mdl = new Region_Model();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $rx->where('zone_Id', $zone_id)->getTotalPatientsrx();
            $data['region'] = $region_mdl->getRegionsByZone($zone_id);

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function get_rx_by_region()
    {
        $region_id = $this->request->getPost('region_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getZoneRxByRegion($region_id);

        return $this->response->setJSON(['table_data' => $rx_data]);
    }

    public function get_rx_by_hq()
    {
        $region_id = $this->request->getPost('region_id');
        $hq_id = $this->request->getPost('hq_id');

        $rx_model = new Rx_Model();
        $rx_data = $rx_model->getZoneRxByHQ($hq_id, $region_id);

        return $this->response->setJSON(['table_data' => $rx_data]);
    }

    public function z_totel_poster()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $posterModel->getPosterWithUsersDetailsByZone($zone_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function z_totel_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $VideoModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }

            $data['data'] = $VideoModel->getVideosWithUsersDetailsByZone($zone_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }
    public function z_users_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }


            $data['data'] = $posterModel->getUserCountByZone($zone_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();


            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function z_users_date_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $zone_id = $zrow['zoneId'];
                }
            }


            $data['data'] = $posterModel->getEntryByDateByZone($zone_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();


            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    

    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();
            
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function poster_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function video_maker()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('zone/video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_video()
    {
        $video = new Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function video_download_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_share_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

}