<?php

namespace App\Models;

use CodeIgniter\Model;

class Anniversary_Video_Model extends Model
{
    protected $table = 'anniversary_video_tbl';
    protected $primaryKey = 'anniversary_video_id';

    protected $allowedFields = ['anniversary_video_id', 'doctor_name', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];


    public function getTotalVideos()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('anniversary_video_tbl.*, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'anniversary_video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('anniversary_video_tbl.fk_user_id', $id)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.qualification, anniversary_video_tbl.city, anniversary_video_tbl.date')
            ->orderBy('anniversary_video_tbl.anniversary_video_id', 'DESC')
            ->findAll();
    }
    public function getVideosWithUsersDetails ()
    {
        return $this->select('anniversary_video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'anniversary_video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.qualification, anniversary_video_tbl.city, anniversary_video_tbl.date, anniversary_video_tbl.fk_user_id')
            ->orderBy('anniversary_video_tbl.anniversary_video_id', 'ASC')
            ->findAll();
    }

    public function getTotalVideosByZone($zoneId)
    {
        return $this->select('anniversary_video_tbl.doctor_name, anniversary_video_tbl.fk_user_id, anniversary_video_tbl.date')
            ->join('tbl_user AS u', 'anniversary_video_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.zoneId', $zoneId)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.fk_user_id, anniversary_video_tbl.date')
            ->countAllResults(false);
    }

    public function getVideosWithUsersDetailsByZone($zoneId)
    {
        return $this->select('anniversary_video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'anniversary_video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.date, anniversary_video_tbl.fk_user_id')
            ->orderBy('anniversary_video_tbl.anniversary_video_id', 'ASC')
            ->findAll();
    }

    public function getTotalVideosByRegion($region_id)
    {
        return $this->select('anniversary_video_tbl.doctor_name, anniversary_video_tbl.fk_user_id, anniversary_video_tbl.date')
            ->join('tbl_user AS u', 'anniversary_video_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.REGIONId', $region_id)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.fk_user_id, anniversary_video_tbl.date')
            ->countAllResults(false);
    }

    public function getVideosWithUsersDetailsByRegion($regionId)
    {
        return $this->select('anniversary_video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'anniversary_video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $regionId)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.date, anniversary_video_tbl.fk_user_id')
            ->orderBy('anniversary_video_tbl.anniversary_video_id', 'ASC')
            ->findAll();
    }

    public function getTotalVideosByHq($hq_id)
    {
        return $this->select('anniversary_video_tbl.doctor_name, anniversary_video_tbl.fk_user_id, anniversary_video_tbl.date')
            ->join('tbl_user AS u', 'anniversary_video_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.HQ', $hq_id)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.fk_user_id, anniversary_video_tbl.date')
            ->countAllResults(false);
    }

    public function getVideosWithUsersDetailsByHq($hqId)
    {
        return $this->select('anniversary_video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'anniversary_video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('anniversary_video_tbl.doctor_name, anniversary_video_tbl.date, anniversary_video_tbl.fk_user_id')
            ->orderBy('anniversary_video_tbl.anniversary_video_id', 'ASC')
            ->findAll();
    }


}


?>