<?php

namespace App\Models;

use CodeIgniter\Model;

class Birthday_Poster_Model extends Model
{
    protected $table = 'birthday_tbl';
    protected $primaryKey = 'bday_id';

    protected $allowedFields = ['bday_id', 'doctor_name', 'doctor_img', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];

    public function getTotalPosters()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('birthday_tbl.*, birthday_frame_tbl.frame_name, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_frame_tbl', 'birthday_tbl.fk_frame_id = birthday_frame_tbl.birthday_frame_id', 'left')
            ->join('tbl_user', 'birthday_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('birthday_tbl.fk_user_id', $id)
            ->groupBy('birthday_tbl.doctor_name, birthday_tbl.qualification, birthday_tbl.city, birthday_tbl.date')
            ->orderBy('birthday_tbl.bday_id', 'DESC')
            ->findAll();
    }

    public function getPosterWithUsersDetails()
    {
        return $this->select('birthday_tbl.*, birthday_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_frame_tbl', 'birthday_tbl.fk_frame_id = birthday_frame_tbl.birthday_frame_id', 'left')
            ->join('tbl_user', 'birthday_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('birthday_tbl.doctor_name, birthday_tbl.qualification, birthday_tbl.city, birthday_tbl.date, birthday_tbl.fk_user_id')
            ->orderBy('birthday_tbl.bday_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByZone($zoneId)
    {
        return $this->select('birthday_tbl.*, birthday_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_frame_tbl', 'birthday_tbl.fk_frame_id = birthday_frame_tbl.birthday_frame_id', 'left')
            ->join('tbl_user', 'birthday_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', value: $zoneId)
            ->groupBy('birthday_tbl.doctor_name, birthday_tbl.qualification, birthday_tbl.city, birthday_tbl.date, birthday_tbl.fk_user_id')
            ->orderBy('birthday_tbl.bday_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByRegion($regionId)
    {
        return $this->select('birthday_tbl.*, birthday_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_frame_tbl', 'birthday_tbl.fk_frame_id = birthday_frame_tbl.birthday_frame_id', 'left')
            ->join('tbl_user', 'birthday_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId',  $regionId)
            ->groupBy('birthday_tbl.doctor_name, birthday_tbl.qualification, birthday_tbl.city, birthday_tbl.date, birthday_tbl.fk_user_id')
            ->orderBy('birthday_tbl.bday_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByHq($hqId)
    {
        return $this->select('birthday_tbl.*, birthday_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_frame_tbl', 'birthday_tbl.fk_frame_id = birthday_frame_tbl.birthday_frame_id', 'left')
            ->join('tbl_user', 'birthday_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('birthday_tbl.doctor_name, birthday_tbl.qualification, birthday_tbl.city, birthday_tbl.date, birthday_tbl.fk_user_id')
            ->orderBy('birthday_tbl.bday_id', 'ASC')
            ->findAll();
    }

}


?>