<?php

namespace App\Models;

use CodeIgniter\Model;

class Doctor_Model extends Model
{
    protected $table = 'doctor_data';
    protected $allowedFields = [
        'id', 'doctor', 'hospital', 'registration_no', 'phone', 'email', 'place', 
        'district', 'state', 'country', 'user', 'user_id', 'empno', 'hq_id', 'region_id', 
        'zone_id', 'date'];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }

    public function getTotalDoctors()
    {
        return $this->select(' COUNT(*) as total ')
        ->groupBy('doctor, user, date')
        ->findAll()
        ;
    }

    public function getTotalDoctorUser()
    {
        return $this->select('user, COUNT(*) AS entry_count')
            ->groupBy('doctor,date')
            ->getRecords();
    }

    public function getDoctorUser()
    {
        return $this->select('*')
            ->groupBy('doctor, date')
            ->orderBy('id', 'DESC')
            ->findAll();

    }



    public function getTotalDoctor()
    {
        return $this->select('doctor_data.*, tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_user', 'doctor_data.user_id = tbl_user.UserId', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy(' doctor_data.doctor,doctor_data.user, doctor_data.date')
            ->orderBy('doctor_data.id', 'DESC')
            ->findAll();
    }


    public function getTotelDoctorEentry()
    {
        return $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count,  tbl_user.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_user', 'doctor_data.user_id = tbl_user.UserId', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('doctor_data.user_id, tbl_user.hq')
            ->orderBy('entry_count', 'DESC')
            ->findAll()
        ;
    }


}


?>