<?php

namespace App\Models;

use CodeIgniter\Model;

class Thankyou_Poster_Model extends Model
{
    protected $table = 'thankyou_tbl';
    protected $primaryKey = 'thankyou_id';

    protected $allowedFields = ['thankyou_id', 'doctor_name', 'doctor_img', 'qualification', 'city', 'download_status', 'share_status', 'brand', 'fk_user_id', 'fk_frame_id', 'date'];

    public function getTotalPosters()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('thankyou_tbl.*, thankyou_frame_tbl.frame_name, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('thankyou_frame_tbl', 'thankyou_tbl.fk_frame_id = thankyou_frame_tbl.thankyou_frame_id', 'left')
            ->join('tbl_user', 'thankyou_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('thankyou_tbl.fk_user_id', $id)
            ->groupBy('thankyou_tbl.doctor_name, thankyou_tbl.qualification, thankyou_tbl.city, thankyou_tbl.date')
            ->orderBy('thankyou_tbl.thankyou_id', 'DESC')
            ->findAll();
    }


    public function getPosterWithUsersDetails()
    {
        return $this->select('thankyou_tbl.*, thankyou_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('thankyou_frame_tbl', 'thankyou_tbl.fk_frame_id = thankyou_frame_tbl.thankyou_frame_id', 'left')
            ->join('tbl_user', 'thankyou_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('thankyou_tbl.doctor_name, thankyou_tbl.qualification, thankyou_tbl.city,  thankyou_tbl.brand, thankyou_tbl.date, thankyou_tbl.fk_user_id')
            ->orderBy('thankyou_tbl.thankyou_id', 'ASC')
            ->findAll();
    }
    public function getPosterWithUsersDetailsByZone($zoneId)
    {
        return $this->select('thankyou_tbl.*, thankyou_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('thankyou_frame_tbl', 'thankyou_tbl.fk_frame_id = thankyou_frame_tbl.thankyou_frame_id', 'left')
            ->join('tbl_user', 'thankyou_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('thankyou_tbl.doctor_name, thankyou_tbl.qualification, thankyou_tbl.city, thankyou_tbl.date, thankyou_tbl.fk_user_id')
            ->orderBy('thankyou_tbl.thankyou_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByRegion($regionId)
    {
        return $this->select('thankyou_tbl.*, thankyou_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('thankyou_frame_tbl', 'thankyou_tbl.fk_frame_id = thankyou_frame_tbl.thankyou_frame_id', 'left')
            ->join('tbl_user', 'thankyou_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $regionId)
            ->groupBy('thankyou_tbl.doctor_name, thankyou_tbl.qualification, thankyou_tbl.city, thankyou_tbl.date, thankyou_tbl.fk_user_id')
            ->orderBy('thankyou_tbl.thankyou_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByHq($hqId)
    {
        return $this->select('thankyou_tbl.*, thankyou_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('thankyou_frame_tbl', 'thankyou_tbl.fk_frame_id = thankyou_frame_tbl.thankyou_frame_id', 'left')
            ->join('tbl_user', 'thankyou_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('thankyou_tbl.doctor_name, thankyou_tbl.qualification, thankyou_tbl.city, thankyou_tbl.date, thankyou_tbl.fk_user_id')
            ->orderBy('thankyou_tbl.thankyou_id', 'ASC')
            ->findAll();
    }

}

?>