<?php

namespace App\Models;

use CodeIgniter\Model;

class User_Model extends Model
{
    protected $table = 'tbl_user';
    protected $primaryKey = 'UserID';
    protected $allowedFields = ['UserID ', 'Name', 'mail', 'pass', 'userImg', 'userType', 'HQ', 'city', 'createdBy', 'empNO', 'DESIG', 'phoneNO', 'REGIONId', 'zoneId','isActive'];

    public function getRecords()
    {
        return $this->findAll();
    }

    public function getRow($id)
    {
        return $this->where('UserID ', $id)->first();
    }
    public function getTotalUsers()
    {
        return $this->countAllResults();
    }
    public function getTotalUser($perPage=500,$page=1,$zone=0,$region=0,$hq=0)
    {
        $results = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left');
            
            if($zone!=0){
                $results->where('tbl_user.zoneId', $zone);
            }
            if($region!=0){
                $results->where('tbl_user.REGIONId', $region);
            }
            if($hq!=0){
                 $results->where('tbl_user.HQ', $hq);
            }
            $results->orderBy('tbl_user.UserID', 'ASC');
            if($perPage!=0){
                $results_rec =  $results->paginate($perPage, 'group1', $page);
            }else{
                $results_rec = $results->get()->getResultArray();
            }
        return $results_rec;
    }

   

    public function getUserDataByRegion($region_id, $zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zone_id)
            ->where('tbl_user.REGIONId', $region_id)
            ->orderBy('tbl_user.UserID', 'ASC');
            if($perPage!=0){
                return $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->get()->getResultArray();
            };
    }

    public function getUserDataByHQ($hq_id, $region_id, $zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zone_id)
            ->where('tbl_user.REGIONId', $region_id)
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC');
            if($perPage!=0){
                return $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->get()->getResultArray();
            };
    }

    public function getProfile()
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->findAll();
    }

  
    public function getZoneUserByHQ($hq_id, $region_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $region_id)
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }
    
     public function getUserDataByZone($zone_id,$perPage=500,$page=1,$str="")
    {
        $results = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zone_id)
            ->orderBy('tbl_user.UserID', 'ASC');
            if($str!=""){
                 $query->like('tbl_user.Name', $str);
            }  
            if($perPage!=0){
                return $results->paginate($perPage, 'group1', $page);
            }else{
                return $results->get()->getResultArray();
            }

    }
    
    public function getZoneUserByRegion($region_id,$str="")
    {
       $query =  $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $region_id);
         if($str!=""){
             $query->like('tbl_user.Name', $str);
         }   
        return $query->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
    public function getRegionUserByHQ($hq_id,$str="")
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id);
         if($str!=""){
             $query->like('tbl_user.Name', $str);
         }   
         return    $query->orderBy('tbl_user.UserID', 'ASC')->findAll();

    }
    
    public function getUserByUserId($id)
    {
        return $this->select('tbl_user.*,tbl_user.HQ as HQ_Id, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.UserID ', $id)
            ->first();
    }
    public function findEmpPatientCountbyUser($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
    
     public function findEmpPatientCountbyHQ($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
     public function findEmpPatientCountbyRegion($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
     public function findEmpPatientCountbyZone($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
    public function findEmpPatientCount($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
    
    
    
    public function findEmpDocterCountbyHQ($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
     public function findEmpDocterCountbyRegion($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
     public function findEmpDocterCountbyZone($hq_id)
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
    public function findEmpDocterCount()
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();

    }
    
}




?>