<?php

namespace App\Models;

use CodeIgniter\Model;

class Frame_Model extends Model
{
    protected $table = 'frame_tbl';
    protected $primaryKey = 'frame_id';
    protected $allowedFields = ['frame_id', 'frame_name', 'fk_campaign_id', 'fk_language_id'];

    public function getRecords()
    {
        return $this->orderBy('frame_id', 'ASC')->findAll();
    }
    public function getRow($id)
    {
        return $this->select('frame_tbl.*, campaign_tbl.campaign_name, language_tbl.language')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('frame_id', $id)
            ->first();
    }

    public function getFrames()
    {
        return $this->select('frame_tbl.*, campaign_tbl.campaign_name, language_tbl.language')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->orderBy('frame_tbl.frame_id', 'ASC')
            ->findAll();

    }

    public function getCampaignsByLanguage($languageid)
    {
        return $this->select('frame_tbl.*, campaign_tbl.campaign_name')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->where('frame_tbl.fk_language_id', $languageid)
            ->groupBy('frame_tbl.frame_id, frame_tbl.fk_campaign_id, campaign_tbl.campaign_name')
            ->orderBy('campaign_tbl.campaign_id', 'DESC')
            ->findAll();
    }

    public function getAllCampaignsWithFrames()
    {
        return $this->select('frame_tbl.frame_id, frame_name, frame_tbl.fk_campaign_id, campaign_tbl.campaign_name, language_tbl.language')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->groupBy('frame_tbl.frame_id, frame_tbl.fk_campaign_id, campaign_tbl.campaign_name, language_tbl.language')
            ->orderBy('campaign_tbl.campaign_name', 'ASC')
            ->findAll();
    }

}


?>