<?php

namespace App\Models;

use CodeIgniter\Model;

class Poster_Model extends Model
{
    protected $table = 'poster_tbl';
    protected $primaryKey = 'poster_id';

    protected $allowedFields = ['poster_id', 'doctor_name', 'doctor_img', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];

    public function getTotalPosters()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('poster_tbl.fk_user_id', $id)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'DESC')
            ->findAll();
    }


    public function getPosterWithUsersDetails()
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }

    public function getUserCount()
    {
        return $this->db->table('tbl_user')
            ->select('tbl_user.UserID, Name, DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE, 
            COUNT(DISTINCT CONCAT(p.doctor_name, "-", p.date, "-", p.fk_user_id)) as poster_count,
            COUNT(DISTINCT CONCAT(v.doctor_name, "-", v.date, "-", v.fk_user_id)) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join('poster_tbl p', 'p.fk_user_id = tbl_user.UserID', 'left')
            ->join('video_tbl v', 'v.fk_user_id = tbl_user.UserID', 'left')
            ->join('frame_tbl', 'p.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->groupBy('tbl_user.UserID')
            ->having('poster_count > 0 OR video_count > 0')
            ->get()
            ->getResultArray();
    }


    public function getEntrybyDate()
    {
        // Create a subquery for all unique user-date combinations from posters
        $posterDates = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Create a subquery for all unique user-date combinations from videos
        $videoDates = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Combine both to get all dates with either posters or videos
        $allDates = "(" . $posterDates->getCompiledSelect() . ") UNION (" . $videoDates->getCompiledSelect() . ")";

        // Create subquery for poster counts
        $posterCounts = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
                COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as poster_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Create subquery for video counts
        $videoCounts = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
                COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as video_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Build the main query
        $query = $this->db->table('tbl_user')
            ->select('tbl_user.UserID, 
                ad.entry_date,
                tbl_user.Name, 
                tbl_user.DESIG,
                tbl_hq.HQ, 
                tbl_region.REGION, 
                tbl_zone.ZONE,
                COALESCE(pc.poster_count, 0) as poster_count,
                COALESCE(vc.video_count, 0) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join("($allDates) as ad", 'ad.fk_user_id = tbl_user.UserID')
            ->join(
                "(" . $posterCounts->getCompiledSelect() . ") as pc",
                'pc.fk_user_id = ad.fk_user_id AND pc.entry_date = ad.entry_date',
                'left'
            )
            ->join(
                "(" . $videoCounts->getCompiledSelect() . ") as vc",
                'vc.fk_user_id = ad.fk_user_id AND vc.entry_date = ad.entry_date',
                'left'
            )
            ->where('pc.poster_count > 0 OR vc.video_count > 0')
            ->orderBy('ad.entry_date', 'ASC');

        return $query->get()->getResultArray();
    }

    public function getTotalPostersByZone($zoneId)
    {
        return $this->select('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->join('tbl_user AS u', 'poster_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.zoneId', $zoneId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->countAllResults(false);
    }



    public function getTopUsersByZone($zoneId)
    {
        return $this->db->table('poster_tbl')
            ->select('poster_tbl.fk_user_id')
            ->join('tbl_user u', 'poster_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.fk_zone_id', $zoneId)
            ->groupBy('poster_tbl.fk_user_id')
            ->limit(10)
            ->get()
            ->getNumRows();
    }

    public function getPosterWithUsersDetailsByZone($zoneId)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }

    public function getTopUserByZone($zoneId)
    {
        return $this->select('tbl_user.UserID, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE, COUNT(DISTINCT CONCAT(poster_tbl.doctor_name, "-", poster_tbl.date, "-", poster_tbl.fk_user_id, "-", campaign_tbl.campaign_id, "-", language_tbl.language_id)) as entry_count')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('poster_tbl.fk_user_id')
            ->orderBy('entry_count', 'DESC')
            ->limit(10)
            ->findAll();
    }

    public function getUserCountByZone($zoneId)
    {
        return $this->db->table('tbl_user')
            ->select('tbl_user.UserID, Name, DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE, 
            COUNT(DISTINCT CONCAT(p.doctor_name, "-", p.date, "-", p.fk_user_id)) as poster_count,
            COUNT(DISTINCT CONCAT(v.doctor_name, "-", v.date, "-", v.fk_user_id)) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join('poster_tbl p', 'p.fk_user_id = tbl_user.UserID', 'left')
            ->join('video_tbl v', 'v.fk_user_id = tbl_user.UserID', 'left')
            ->join('frame_tbl', 'p.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('tbl_user.UserID')
            ->having('poster_count > 0 OR video_count > 0')
            ->get()
            ->getResultArray();
    }

    public function getEntryByDateByZone($zoneId)
    {
        $posterDates = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Create a subquery for all unique user-date combinations from videos
        $videoDates = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Combine both to get all dates with either posters or videos
        $allDates = "(" . $posterDates->getCompiledSelect() . ") UNION (" . $videoDates->getCompiledSelect() . ")";

        // Create subquery for poster counts
        $posterCounts = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
            COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as poster_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Create subquery for video counts
        $videoCounts = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
            COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as video_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Build the main query
        $query = $this->db->table('tbl_user')
            ->select('tbl_user.UserID, 
            ad.entry_date,
            tbl_user.Name, 
            tbl_user.DESIG,
            tbl_hq.HQ, 
            tbl_region.REGION, 
            tbl_zone.ZONE,
            COALESCE(pc.poster_count, 0) as poster_count,
            COALESCE(vc.video_count, 0) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join("($allDates) as ad", 'ad.fk_user_id = tbl_user.UserID')
            ->join(
                "(" . $posterCounts->getCompiledSelect() . ") as pc",
                'pc.fk_user_id = ad.fk_user_id AND pc.entry_date = ad.entry_date',
                'left'
            )
            ->join(
                "(" . $videoCounts->getCompiledSelect() . ") as vc",
                'vc.fk_user_id = ad.fk_user_id AND vc.entry_date = ad.entry_date',
                'left'
            )
            ->where('tbl_user.zoneId', $zoneId) // Make sure this matches your database structure
            ->where('(pc.poster_count > 0 OR vc.video_count > 0)') // Added parentheses for clarity
            ->orderBy('ad.entry_date', 'ASC');

        return $query->get()->getResultArray();
    }

    public function getTotalPostersByRegion($region_id)
    {
        return $this->select('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->join('tbl_user AS u', 'poster_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.REGIONId', $region_id)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->countAllResults(false);
    }

    public function getPosterWithUsersDetailsByRegion($regionId)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $regionId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }


    public function getUserCountByRegion($regionId)
    {
        return $this->db->table('tbl_user')
            ->select('tbl_user.UserID, Name, DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE, 
            COUNT(DISTINCT CONCAT(p.doctor_name, "-", p.date, "-", p.fk_user_id)) as poster_count,
            COUNT(DISTINCT CONCAT(v.doctor_name, "-", v.date, "-", v.fk_user_id)) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join('poster_tbl p', 'p.fk_user_id = tbl_user.UserID', 'left')
            ->join('video_tbl v', 'v.fk_user_id = tbl_user.UserID', 'left')
            ->join('frame_tbl', 'p.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.REGIONId', $regionId)
            ->groupBy('tbl_user.UserID')
            ->having('poster_count > 0 OR video_count > 0')
            ->get()
            ->getResultArray();
    }

    public function getEntryByDateByRegion($regionId)
    {
        // Create a subquery for all unique user-date combinations from posters
        $posterDates = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Create a subquery for all unique user-date combinations from videos
        $videoDates = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Combine both to get all dates with either posters or videos
        $allDates = "(" . $posterDates->getCompiledSelect() . ") UNION (" . $videoDates->getCompiledSelect() . ")";

        // Create subquery for poster counts
        $posterCounts = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
            COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as poster_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Create subquery for video counts
        $videoCounts = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
            COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as video_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Build the main query
        $query = $this->db->table('tbl_user')
            ->select('tbl_user.UserID, 
            ad.entry_date,
            tbl_user.Name, 
            tbl_user.DESIG,
            tbl_hq.HQ, 
            tbl_region.REGION, 
            tbl_zone.ZONE,
            COALESCE(pc.poster_count, 0) as poster_count,
            COALESCE(vc.video_count, 0) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join("($allDates) as ad", 'ad.fk_user_id = tbl_user.UserID')
            ->join(
                "(" . $posterCounts->getCompiledSelect() . ") as pc",
                'pc.fk_user_id = ad.fk_user_id AND pc.entry_date = ad.entry_date',
                'left'
            )
            ->join(
                "(" . $videoCounts->getCompiledSelect() . ") as vc",
                'vc.fk_user_id = ad.fk_user_id AND vc.entry_date = ad.entry_date',
                'left'
            )
            ->where('tbl_user.REGIONId', $regionId) // Make sure this matches your database structure
            ->where('(pc.poster_count > 0 OR vc.video_count > 0)') // Added parentheses for clarity
            ->orderBy('ad.entry_date', 'ASC');

        return $query->get()->getResultArray();
    }

    public function getTotalPostersByHq($hq_id)
    {
        return $this->select('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->join('tbl_user AS u', 'poster_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.HQ', $hq_id)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.fk_user_id, poster_tbl.date')
            ->countAllResults(false);
    }


    public function getPosterWithUsersDetailsByHq($hqId)
    {
        return $this->select('poster_tbl.*, frame_tbl.frame_name, campaign_tbl.campaign_name, language_tbl.language, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('frame_tbl', 'poster_tbl.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->join('tbl_user', 'poster_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('poster_tbl.doctor_name, poster_tbl.date, poster_tbl.fk_user_id, campaign_tbl.campaign_id, language_tbl.language_id')
            ->orderBy('poster_tbl.poster_id', 'ASC')
            ->findAll();
    }

    public function getUserCountByHq($hqId)
    {
        return $this->db->table('tbl_user')
            ->select('tbl_user.UserID, Name, DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE, 
            COUNT(DISTINCT CONCAT(p.doctor_name, "-", p.date, "-", p.fk_user_id)) as poster_count,
            COUNT(DISTINCT CONCAT(v.doctor_name, "-", v.date, "-", v.fk_user_id)) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join('poster_tbl p', 'p.fk_user_id = tbl_user.UserID', 'left')
            ->join('video_tbl v', 'v.fk_user_id = tbl_user.UserID', 'left')
            ->join('frame_tbl', 'p.fk_frame_id = frame_tbl.frame_id', 'left')
            ->join('campaign_tbl', 'frame_tbl.fk_campaign_id = campaign_tbl.campaign_id', 'left')
            ->join('language_tbl', 'frame_tbl.fk_language_id = language_tbl.language_id', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('tbl_user.UserID')
            ->having('poster_count > 0 OR video_count > 0')
            ->get()
            ->getResultArray();
    }

    public function getEntryByDateByHq($hqId)
    {
        // Create a subquery for all unique user-date combinations from posters
        $posterDates = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Create a subquery for all unique user-date combinations from videos
        $videoDates = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date')
            ->groupBy('fk_user_id, DATE(date)');

        // Combine both to get all dates with either posters or videos
        $allDates = "(" . $posterDates->getCompiledSelect() . ") UNION (" . $videoDates->getCompiledSelect() . ")";

        // Create subquery for poster counts
        $posterCounts = $this->db->table('poster_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
            COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as poster_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Create subquery for video counts
        $videoCounts = $this->db->table('video_tbl')
            ->select('fk_user_id, DATE(date) as entry_date, 
            COUNT(DISTINCT CONCAT(doctor_name, "-", DATE(date), "-", fk_user_id)) as video_count')
            ->groupBy('fk_user_id, DATE(date)');

        // Build the main query
        $query = $this->db->table('tbl_user')
            ->select('tbl_user.UserID, 
            ad.entry_date,
            tbl_user.Name, 
            tbl_user.DESIG,
            tbl_hq.HQ, 
            tbl_region.REGION, 
            tbl_zone.ZONE,
            COALESCE(pc.poster_count, 0) as poster_count,
            COALESCE(vc.video_count, 0) as video_count')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->join("($allDates) as ad", 'ad.fk_user_id = tbl_user.UserID')
            ->join(
                "(" . $posterCounts->getCompiledSelect() . ") as pc",
                'pc.fk_user_id = ad.fk_user_id AND pc.entry_date = ad.entry_date',
                'left'
            )
            ->join(
                "(" . $videoCounts->getCompiledSelect() . ") as vc",
                'vc.fk_user_id = ad.fk_user_id AND vc.entry_date = ad.entry_date',
                'left'
            )
            ->where('tbl_user.HQ', $hqId) // Make sure this matches your database structure
            ->where('(pc.poster_count > 0 OR vc.video_count > 0)') // Added parentheses for clarity
            ->orderBy('ad.entry_date', 'ASC');

        return $query->get()->getResultArray();
    }




}


?>