<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

<body>
    <!-- Sidebar Start -->
    <?php include ("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include ("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Patients Rx</h3>
                         <div class="table-responsive">
                            <button id="tbltoxl1" class="btn bg-green  text-white">Generate Excel</button>
                            <div class="row mb-2">
                                <div class="col-3 mt-2">
                                 <input class="search" type="text" id="searchInput" placeholder="Search ">
                                </div>
                                <div class="col-3 mt-2">
                                    <input type="text" class="search" placeholder="Start Date:" id="startDatepicker">
                                </div>
                                <div class="col-3 mt-2">
                                    <input type="text" class="search" placeholder="End Date:" id="endDatepicker">
                                </div>
                                <div class="col-3 mt-2">
                                <button id="tblSearch"  class="btn bg-green  text-white">Search</button>
                                </div>
                            </div>

                        <div class="table-responsive">
                            <table class="table" id="myTable" style="">
                                <thead>
                                    <tr>
                                    <th scope="col">S. No</th>
                                        <th scope="col">Image</th>
                                        <th scope="col">Patient Name</th>
                                        <th scope="col">Patient Phone</th>
                                        <th scope="col">Doctor Name</th>
                                        <th scope="col">Quantity of Strips</th>
                                        <th scope="col">Indication</th>
                                        <th scope="col">Secondary</th>
                                        <th scope="col">Prescription Information</th>
                                        <th scope="col">Co-Morbidity Prescription</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Employee</th>
                                        <th scope="col">Emp. ID</th>
                                        <th scope="col">Area</th>
                                        <th scope="col">Region</th>
                                        <th scope="col">Zone</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                            <td><?php echo $serial + ($perPage * ($page - 1)) ?></td>
                                                <td>
                                                    <?php $file_extension = pathinfo($row['image'], PATHINFO_EXTENSION);
                                                    $allowed_extensions = array('jpg', 'jpeg', 'png', 'gif', 'bmp');
                                                    if (in_array(strtolower($file_extension), $allowed_extensions)) {
                                                        echo '<img src="' . base_url() . '/assets/patient_data/' . $row['image'] . '" style="width:100px">';
                                                    } else { echo $row['image'];} ?>
                                                </td>
                                                <td><?php echo $row['patient_name']; ?></td>
                                                <td><?php echo $row['phone_no']; ?></td>
                                                <td><?php echo $row['doctor_name']; ?></td>
                                                <td><?php echo $row['strips']; ?></td>
                                                <td><?php echo $row['indication']; ?></td>
                                                <td><?php echo $row['secondary']; ?></td>
                                                <td><?php echo $row['prescription_information']; ?></td>
                                                <td><?php echo $row['co_morbidity_prescription']; ?></td>
                                                <td><?php echo $row['date']; ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td>
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                            
                            <?php   if(!empty($data)  && $total>$perPage){ ?>
                        
                              <ul id="pagination-demo" class="pagination-sm"></ul>
                            
                            <?php } ?>
                              <select class="form-select" name="pagesize" id="pagesize" >
                                <option value="20" <?php if($perPage==20){ echo "selected";} ?> >20</option>
                                <option value="50" <?php if($perPage==50){ echo "selected";} ?>>50</option>
                                <option value="100" <?php if($perPage==100){ echo "selected";} ?>>100</option>
                                <option value="500" <?php if($perPage==500){ echo "selected";} ?>>500</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
             $(document).ready(function () {
            function setpagination(total) {
                 console.log(total);
                 $('#pagination-demo').pagination('destroy');
                 console.log("setpagination",total);
                  $('#pagination-demo').pagination({
                    items: total,
                    itemsOnPage: $("#pagesize").val(),
                     cssStyle: 'light-theme',
                    onPageClick: function (pageNumber) {
                         $.ajax({ url: '<?php echo base_url("zone/get_doctor_data_by_date"); ?>', type: 'get', 
                            data: { 
                                zone_id: $("#zone").val(),
                                region_id: $("#region").val(),
                                hq_id: $("#hq").val(),
                                startDate: $("#startDatepicker").val(),
                                endDate: $("#endDatepicker").val(),
                                searchText: $("#searchInput").val(),
                                page:pageNumber,
                                pagesize:$("#pagesize").val()
                            }, dataType: 'json', 
                            success: function (response) { 
                                updateTable(response.table_data,pageNumber); 
                                if(pageNumber==1){
                                    setpagination(response.table_data.length)
                                }
                            } 
                        }); 
                    }
                });
             }
             
            $('#tbltoxl1').click(function(){ 
                let Str = "";
                if($('#zone').val()){
                    Str="zone="+$('#zone').val()
                }
                if($('#region').val()){
                    Str=Str+"&region="+$('#region').val()
                }
                if($('#hq').val()){
                    Str=Str+"&hq="+$('#hq').val()
                }
                if($('#startDatepicker').val()){
                    Str=Str+"&startDate="+$('#startDatepicker').val()
                }
                if($('#endDatepicker').val()){
                    Str=Str+"&endDate="+$('#endDatepicker').val()
                }
                window.open('<?php echo base_url(); ?>abm/generate_excel_by_total_rx?'+Str, '_blank')
            });
            
            $('#tblSearch').click(function(){ 
                $.ajax({ url: '<?php echo base_url("abm/get_total_rx_data"); ?>', type: 'get', 
                    data: { 
                        region_id: $("#region").val(),
                        hq_id: $("#hq").val(),
                        startDate: $("#startDatepicker").val(),
                        endDate: $("#endDatepicker").val(),
                        searchText: $("#searchInput").val(),
                        page:page,
                        pagesize:$("#pagesize").val()
                    }, dataType: 'json', 
                    success: function (response) { 
                        updateTable(response.table_data); 
                    } 
                }); 
            });


            function updateTable(tableData,pageNo=1) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var html = "<tr>" + "<td>" + (((pageNo - 1) * $("#pagesize").val()) + (index + 1)) + "</td>" + "<td>" + row.doctor + "</td>" +
                            "<td>" + row.hospital + "</td>" + "<td>" + row.registration_no + "</td>" +
                            "<td>" + "<a href='<?php echo site_url('admin/doctor_patients/'); ?>" + row.id +
                            "' style='border-radius: 3px;' class='btn bg-green text-white'><i class='bi bi-people'></i></a>" +
                            "</td>" + "<td>" + row.phone + "</td>" + "<td>" + row.email + "</td>" + "<td>" +
                            row.place + "</td>" + "<td>" + row.district + "</td>" + "<td>" + row.state +
                            "</td>" + "<td>" + row.country + "</td>" + "<td>" + row.date + "</td>" +
                            "<td>" + row.user + "</td>" + "<td>" + row.empno + "</td>" + "<td>" + row.HQ + "</td>" + "<td>" + row.REGION +
                            "</td>" + "<td>" + row.ZONE + "</td>" + "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
             setpagination(<?php echo $total;?>)
        });
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include ("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
</body>

</html>