<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>
        <div class="container-fluid "><br>
            <div class="row">
                <div class="col-sm-12 ">
                    <div class="bg-white rounded h-100 p-4">
                        <h3 class="mb-4"> Employee Details Form</h3>
                        <form role="form" action="<?php echo site_url('/rbm/user_insert') ?>" method="post"
                            onsubmit="return submitForm(this);" enctype="multipart/form-data">
                            <div class="col-sm-12 row">
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Employee Name</label>
                                    <input required type="text" class="form-control" placeholder="Employee Name"
                                        name="name">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Employee Mobile</label>
                                    <input type="tel" class="form-control" pattern="[6-9]{1}[0-9]{9}"
                                        placeholder="9 * * * * * * * * 0" name="phone">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Employee E-mail</label>
                                    <input type="email" class="form-control" placeholder="Employee E-mail"
                                        name="email">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Employee ID</label>
                                    <input required type="text" class="form-control" placeholder="Employee ID"
                                        name="emp_no">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label">Designation</label><br>
                                    <select class="form-select col-1" name="user_type" required>
                                        <option value="1">BO</option>
                                        <option value="2">ABM</option>
                                        <br>
                                    </select>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> City</label>
                                    <input required type="text" class="form-control" placeholder="City" name="city">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label">Area</label><br>
                                    <select class="form-select" name="hq" id="hq" required>
                                        <option value="">Select Area</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $hqrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $hqrow['HQId']; ?>">
                                                    <?php echo $hqrow['HQ']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php
                                $serial = 0;
                                if (!empty($region)) {
                                    foreach ($region as $row) {
                                        ?>
                                        <input type="hidden" value="<?php echo $row['REGIONId']; ?>" name="region"
                                            class="form-control">
                                        <input type="hidden" value="<?php echo $row['zoneId']; ?>" name="zone"
                                            class="form-control">
                                    <?php }
                                } else { ?>
                                    <option>Region Not Found </option>
                                <?php } ?>
                            </div>
                            <center>
                                <div class="col-xs-12 ">
                                    <br>
                                    <input type="submit" class="btn btn-primary" name="submit" value="submit">
                                </div>
                            </center>
                        </form>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include("footer.php") ?>
    <script>
        $(document).ready(function () {
            $('#hq').change(function () {
                var hqId = $(this).val();
                var regionId = $("#region").val();
                var zoneId = $("#zone").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_hq"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId,
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else { }
            });


        });
    </script>
</body>
</html>