<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
<body>
    <section class="section pt-0" id="about">
        <?php include ("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <h5>Cardimet Brand Prescribed Telminorm/Telminorm AM/Telminorm BXL</h5>
                    <br>
                    <form id="rxForm" action="<?= site_url('/user/rx_data') ?>" method="post"
                        enctype="multipart/form-data">
                        <input class="input" type="tel" required id="phone" name="phone_number" pattern="[6-9]{1}[0-9]{9}" placeholder="Patient Phone">
                        <input class="input" type="text" required readonly name="patient_name" placeholder="Patient Name" value="">
                        <input class="input" type="text" required readonly name="doctor_name" placeholder="Doctor Name" value="">
                        <input class="input" type="number" required id="tabquantity" name="quantity" placeholder="Quantity of Tablets" oninput="divideValue()">
                        <input class="input" type="text" required readonly id="result" name="strips" placeholder="Quantity of Strips">
                        <input class="input" type="text" name="indication" placeholder="Indication">
                        <input class="input" type="text" required name="secondary" placeholder="Current Secondary">
                        <input class="input" type="file" required name="image" accept="image/webp,image/png,image/jpeg" style="width:196px">
                        <input class="input" type="hidden" required name="patient_id" value="">
                        <input class="input" type="hidden" required name="doctor_id" value="">
                        <input class="input" type="hidden" required name="user_id" value="">
                        <input class="input" type="hidden" required name="user" value="">
                        <input class="input" type="hidden" required name="empno" value="">
                        <input class="input" type="hidden" required name="hq_id" value="">
                        <input class="input" type="hidden" required name="region_id" value="">
                        <input class="input" type="hidden" required name="zone_id" value="">
                        <div class="text-center">
                            <br>
                            <button type="button" id="submitBtn" class="btn sub-btn">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="">
            <img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt=" ">
        </div>
    </section>
    <?php include ("footer.php") ?>
    <script>
        function divideValue() {
            var tabquantity = parseFloat(document.getElementById("tabquantity").value);
            if (!isNaN(tabquantity)) {
                var result = (tabquantity / 10).toFixed(1);
                var strikethrough = "";
                for (var i = 0; i < tabquantity; i++) {strikethrough += "-";}
                var resultString = result + " Strips";
                document.getElementById("result").value = resultString; } 
            else { document.getElementById("result").value = ""; }
        }
        function fetchPatientData(phoneNumber) {
            console.log('Phone number:', phoneNumber); 
            fetch('<?= site_url('/user/fetchPatientData') ?>', {
                method: 'POST',
                headers: {'Content-Type': 'application/json','X-Requested-With': 'XMLHttpRequest'},
                body: JSON.stringify({ phone: phoneNumber })
            })
            .then(response => response.json())
            .then(data => {
                if (data.error) { alert(data.error); } 
                else {
                document.querySelector('input[name="patient_name"]').value = data.patient_name;
                document.querySelector('input[name="doctor_name"]').value = data.doctor_name;
                document.querySelector('input[name="patient_id"]').value = data.patient_id;
                document.querySelector('input[name="doctor_id"]').value = data.doctor_id;
                document.querySelector('input[name="user_id"]').value = data.user_id;
                document.querySelector('input[name="user"]').value = data.user;
                document.querySelector('input[name="empno"]').value = data.empno;
                document.querySelector('input[name="hq_id"]').value = data.hq_id;
                document.querySelector('input[name="region_id"]').value = data.region_id;
                document.querySelector('input[name="zone_id"]').value = data.zone_id;
                }
            })
            .catch(error => { console.error('Error:', error); });
        }
        document.getElementById('phone').addEventListener('input', function (event) {
            var phoneNumber = event.target.value.trim();
            if (phoneNumber.length === 10 && /^[6-9]\d{9}$/.test(phoneNumber)) { fetchPatientData(phoneNumber); } 
            else {
            document.querySelector('input[name="patient_name"]').value = '';
            document.querySelector('input[name="doctor_name"]').value = '';
            document.querySelector('input[name="patient_id"]').value = '';
            document.querySelector('input[name="doctor_id"]').value = '';
            }
        });
        document.getElementById('submitBtn').addEventListener('click', function () {
            var phoneNumber = document.getElementById('phone').value.trim();
            if (phoneNumber.length !== 10 || !/^[6-9]\d{9}$/.test(phoneNumber)) {
                alert('Please enter a valid 10-digit phone number.'); return;
            }
            var form = document.getElementById('rxForm');
            var inputs = form.querySelectorAll('input[required]');
            var isValid = true;
            inputs.forEach(function (input) { if (!input.value.trim()) {isValid = false; } });
            if (!isValid) { alert('Please fill in all required fields.'); return; }
            form.submit();
        });
    </script>
</body>

</html>