<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <h5>Prescription Information</h5>
                    <br>
                    <form id="rxForm" action="<?= site_url('/user/rx_data') ?>" method="post" enctype="multipart/form-data">
                        <input class="input" type="text" required name="patient_name" placeholder="Patient Name" value="<?php echo $patientData['name']  ?>">
                        <input class="input" type="text" required name="doctor_name" placeholder="Doctor Name" value="<?php echo $patientData['doctor']  ?>">
                        <input class="input" type="tel" name="phone_number" pattern="[6-9]{1}[0-9]{9}" placeholder="Patient Phone" value="<?php echo $patientData['phone']  ?>">
                        <input class="input" type="number" required name="strips" placeholder="Quantity of Strips">
                        <input class="input" type="text" name="indication" placeholder="Indication">
                        <input class="input" type="number" required name="secondary" placeholder="Units of Current Secondary">
                        <div class="custom-dropdown dropdown-one">
                            <label class="form-label drop">Prescription Information</label>
                            <div class="custom-dropdown-content">
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm 20"> Telminorm 20</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm 40"> Telminorm 40</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm AM 40/5"> Telminorm AM 40/5</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm BXL 40/25"> Telminorm BXL 40/25</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm BXL 40/50"> Telminorm BXL 40/50</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Non-Prescriber"> Non-Prescriber</label>
                                </div><span class="dropdown-icon">&#9660;</span>
                        </div>
                        <div class="custom-dropdown dropdown-two">
                            <label for="" class="form-label drop">Co-Morbidity Prescription</label>
                            <div class="custom-dropdown-content">
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 5"> RXtor 5</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 10"> RXtor 10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 20"> RXtor 20</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 40"> RXtor 40</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor F 5"> RXtor F 5</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor F 10"> RXtor F 10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor Gold 10"> RXtor Gold 10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor Gold 20"> RXtor Gold 20</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip 25"> Suitglip 25</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip 50"> Suitglip 50</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip 100"> Suitglip 100</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - M 50/1000"> Suitglip - M 50/1000</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - M 50/500"> Suitglip - M 50/500</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - MXR 100/1000"> Suitglip - MXR 100/1000</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - MXR 100/500"> Suitglip - MXR 100/500</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - MXR 50/500"> Suitglip - MXR 50/500</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip D 50/5"> Suitglip D 50/5</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip D 100/10"> Suitglip D 100/10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree MV 1"> Glyree MV 1</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree MV 2"> Glyree MV 2</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M 1 Fort"> Glyree M 1 Fort</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M 2 Fort"> Glyree M 2 Fort</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M1"> Glyree M1</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M2"> Glyree M2</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 1"> Glyree - 1</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 2"> Glyree - 2</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 3"> Glyree - 3</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 4"> Glyree - 4</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Non-Prescriber"> Non-Prescriber</label>
                            </div><span class="dropdown-icon">&#9660;</span>
                        </div>
                        <input class=" " type="file" name="image" accept="image/webp,image/png,image/jpeg" style="width:222px; padding-left: 10px;">
                        <input class="input" type="hidden" required name="patient_id" value="<?php echo $patientData['id']  ?>">
                        <input class="input" type="hidden" required name="doctor_id" value="<?php echo $patientData['dr_id']  ?>">
                        <input class="input" type="hidden" required name="user_id" value="<?php echo $patientData['user_id']  ?>">
                        <input class="input" type="hidden" required name="user" value="<?php echo $patientData['user']  ?>">
                        <input class="input" type="hidden" required name="empno" value="<?php echo $patientData['empno']  ?>">
                        <input class="input" type="hidden" required name="hq_id" value="<?php echo $patientData['hq_id']  ?>">
                        <input class="input" type="hidden" required name="region_id" value="<?php echo $patientData['region_id']  ?>">
                        <input class="input" type="hidden" required name="zone_id" value="<?php echo $patientData['zone_id']  ?>">
                        <div class="text-center"><br>
                            <button type="submit" id="submitBtn" class="btn sub-btn">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class=""><img src="<?= base_url() ?>asset/imgs/character.png" class="chr" alt="MHAC Character"></div>
    </section>
    <?php include("footer.php") ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            document.getElementById("submitBtn").addEventListener("click", function(event) {
                event.preventDefault();                 
                var dropdown1 = document.querySelector(".dropdown-one input:checked");
                var dropdown2 = document.querySelector(".dropdown-two input:checked");
                var requiredFields = document.querySelectorAll("#rxForm input[required]");
                for (var i = 0; i < requiredFields.length; i++) {
                    if (!requiredFields[i].value) {
                        alert("Please fill out all required fields.");
                        return;
                    }
                }
                if (!dropdown1) {
                    alert("Select an option from the Prescription Information dropdown.");
                    return;
                }
                if (!dropdown2) {
                    alert("Select an option from the Co-Morbidity Prescription dropdown.");
                    return;
                }
                document.getElementById("rxForm").submit();
            });
        });
    </script>
</body>
</html>