<script>
        function validateForm() {
            var sbp1 = document.getElementById("sbp1").value;
            var dbp1 = document.getElementById("dbp1").value;
            if (parseInt(sbp1) < parseInt(dbp1)) { alert("Reading 1 : SBP cannot be less than DBP"); return false; }
            var sbp2 = document.getElementById("sbp2").value;
            var dbp2 = document.getElementById("dbp2").value;
            if (parseInt(sbp2) < parseInt(dbp2)) { alert("Reading 2 : SBP cannot be less than DBP"); return false; }
            var sbp3 = document.getElementById("sbp3").value;
            var dbp3 = document.getElementById("dbp3").value;
            if (parseInt(sbp3) < parseInt(dbp3)) { alert("Reading 3 : SBP cannot be less than DBP"); return false; }
            return true;
        }

        function calculateAverage() {
            var sbp1 = parseInt(document.getElementById("sbp1").value);
            var dbp1 = parseInt(document.getElementById("dbp1").value);
            var sbp2 = parseInt(document.getElementById("sbp2").value);
            var dbp2 = parseInt(document.getElementById("dbp2").value);
            var sbp3 = parseInt(document.getElementById("sbp3").value);
            var dbp3 = parseInt(document.getElementById("dbp3").value);

            var avg_sbp = (sbp1 + sbp2 + sbp3) / 3;
            var avg_dbp = (dbp1 + dbp2 + dbp3) / 3;

            document.getElementById("average_sbp").value = isNaN(avg_sbp) ? '' : avg_sbp.toFixed(2);
            document.getElementById("average_dbp").value = isNaN(avg_dbp) ? '' : avg_dbp.toFixed(2);
        }
        document.getElementById("sbp1").addEventListener("input", calculateAverage);
        document.getElementById("dbp1").addEventListener("input", calculateAverage);
        document.getElementById("sbp2").addEventListener("input", calculateAverage);
        document.getElementById("dbp2").addEventListener("input", calculateAverage);
        document.getElementById("sbp3").addEventListener("input", calculateAverage);
        document.getElementById("dbp3").addEventListener("input", calculateAverage);

        function showNextSection(currentSec, nextSec) {
            if (validateForm(currentSec)) {
                if (currentSec === 'sec-2') {
                    var hypertensionValue = document.querySelector('input[name="hypertension"]:checked').value;
                    if (hypertensionValue === 'Yes') {
                        hideAndUnhide(currentSec, 'sec-3');
                        return;
                    }
                }
                hideAndUnhide(currentSec, nextSec);
            }
        }

        function validateForm(section) {
            if (section === 'sec-1') {
                var name = document.querySelector('input[name="name"]').value.trim();
                var place = document.querySelector('input[name="place"]').value.trim();
                var examination = document.querySelector('input[name="examination"]').value.trim();
                var age = document.querySelector('input[name="age"]').value.trim();
                var gender = document.querySelector('input[name="gender"]:checked');
                if (name === '' || place === '' || examination === '' || age === '' || !gender) {
                    alert('Please fill in all fields ');
                    return false;
                }
            } else if (section === 'sec-2') {
                var hypertension = document.querySelector('input[name="hypertension"]:checked');
                if (!hypertension) {
                    alert('Please select if you have known hypertension');
                    return false;
                } else if (hypertension.value === 'Yes') {
                    var drugsRadio = document.querySelector('input[name="drugs"]:checked');
                    if (!drugsRadio) {
                        alert("Please select a value for 'Anti-Hypertension Drugs'");
                        return false;
                    }
                    var checkboxes = document.querySelectorAll('input[name="combination[]"]:checked');
                    var maxChecked = parseInt(drugsRadio.value);
                    if (drugsRadio.value === 'Mono') {
                        if (checkboxes.length !== 1) {
                            alert("Please select exactly 1 checkbox for 'Anti-Hypertension Drugs Combination'");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Dual') {
                        if (checkboxes.length !== 2) {
                            alert("Please select exactly 2 checkboxes for 'Anti-Hypertension Drugs Combination'");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Triple') {
                        if (checkboxes.length !== 3) {
                            alert("Please select exactly 3 checkboxes for 'Anti-Hypertension Drugs Combination'");
                            return false;
                        }
                    }
                }
            } else if (section === 'sec-3') {
                var sbp1 = parseInt(document.querySelector('input[name="sbp1"]').value);
                var dbp1 = parseInt(document.querySelector('input[name="dbp1"]').value);
                var sbp2 = parseInt(document.querySelector('input[name="sbp2"]').value);
                var dbp2 = parseInt(document.querySelector('input[name="dbp2"]').value);
                var sbp3 = parseInt(document.querySelector('input[name="sbp3"]').value);
                var dbp3 = parseInt(document.querySelector('input[name="dbp3"]').value);
                if (isNaN(sbp1) || isNaN(dbp1) || isNaN(sbp2) || isNaN(dbp2) || isNaN(sbp3) || isNaN(dbp3)) {
                    alert('Please enter valid BP readings ');
                    return false;
                }
                if (sbp1 < dbp1 || sbp2 < dbp2 || sbp3 < dbp3) {
                    alert('SBP cannot be less than DBP ');
                    return false;
                }
                calculateAverage(); // Calculate average SBP and DBP
            } 

            return true;
        }

        function hideAndUnhide(currentSec, nextSec) {
            document.querySelector('.' + currentSec).style.display = 'none';
            document.querySelector('.' + nextSec).style.display = 'block';
            if (nextSec === 'sec-2') {
                enableCheckboxes(1); // Enable only the main checkboxes after going to sec-2
            }
        }

        function showPreviousSection(currentSec, prevSec) {
            hideAndUnhide(currentSec, prevSec);
            currentSection = prevSec;
        }

        function showInputField() {
            var inputs = document.querySelectorAll('.hidden');
            for (var i = 0; i < inputs.length; i++) {
                inputs[i].style.display = 'inline-block';
                if (inputs[i].getAttribute('type') === 'radio') {
                    inputs[i].setAttribute('required', 'required');
                }
            }
        }

        function hideInputField() {
            var drugsRadios = document.querySelectorAll('input[name="drugs"]');
            for (var j = 0; j < drugsRadios.length; j++) {
                if (drugsRadios[j].value === 'Mono') {
                    drugsRadios[j].setAttribute('value', 'No');
                    drugsRadios[j].checked = true;
                } else {
                    drugsRadios[j].disabled = true;
                }
            }
            var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var k = 0; k < combinationCheckboxes.length; k++) {
                if (combinationCheckboxes[k].value === 'ARB') {
                    combinationCheckboxes[k].checked = false;
                    combinationCheckboxes[k].value = 'NO'; // Set the value to "NO"
                } else {
                    combinationCheckboxes[k].disabled = true;
                }
            }
        }

        function enableCheckboxes(maxChecked) {
            var checkboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].disabled = false;
            }
        }

        function validateName(input) {
            var namePattern = /^[a-zA-Z ]+$/;
            if (!input.value.match(namePattern)) {
                alert('Name must contain only letters and spaces');
                input.value = '';
                return false;
            }
            return true;
        }

        function validatePhone(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^[6-9]\d{9}$/;
            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, '');
                if (input.value.length > 10) {
                    input.value = input.value.slice(0, 10);
                }
            }
        }
        function validateAge(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^\d{2}$/;
            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, '');
                if (input.value.length > 2) {
                    input.value = input.value.slice(0, 2);
                }
            }
        }





    </script>



<!-- rx code old -->

<script>
        function divideValue() {
            var tabquantity = parseFloat(document.getElementById("tabquantity").value);
            if (!isNaN(tabquantity)) {
                var result = (tabquantity / 10).toFixed(1);
                var strikethrough = "";
                for (var i = 0; i < tabquantity; i++) { strikethrough += "-"; }
                var resultString = result + " Strips";
                document.getElementById("result").value = resultString;
            }
            else { document.getElementById("result").value = ""; }
        }
        function fetchPatientData(phoneNumber) {
            console.log('Phone number:', phoneNumber);
            fetch('<?= site_url('/user/fetchPatientData') ?>', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' },
                body: JSON.stringify({ phone: phoneNumber })
            })
                .then(response => response.json())
                .then(data => {
                    if (data.error) { alert(data.error); }
                    else {
                        document.querySelector('input[name="patient_name"]').value = data.patient_name;
                        document.querySelector('input[name="doctor_name"]').value = data.doctor_name;
                        document.querySelector('input[name="patient_id"]').value = data.patient_id;
                        document.querySelector('input[name="doctor_id"]').value = data.doctor_id;
                        document.querySelector('input[name="user_id"]').value = data.user_id;
                        document.querySelector('input[name="user"]').value = data.user;
                        document.querySelector('input[name="empno"]').value = data.empno;
                        document.querySelector('input[name="hq_id"]').value = data.hq_id;
                        document.querySelector('input[name="region_id"]').value = data.region_id;
                        document.querySelector('input[name="zone_id"]').value = data.zone_id;
                    }
                })
                .catch(error => { console.error('Error:', error); });
        }
        document.getElementById('phone').addEventListener('input', function (event) {
            var phoneNumber = event.target.value.trim();
            if (phoneNumber.length === 10 && /^[6-9]\d{9}$/.test(phoneNumber)) { fetchPatientData(phoneNumber); }
            else {
                document.querySelector('input[name="patient_name"]').value = '';
                document.querySelector('input[name="doctor_name"]').value = '';
                document.querySelector('input[name="patient_id"]').value = '';
                document.querySelector('input[name="doctor_id"]').value = '';
            }
        });
        document.getElementById('submitBtn').addEventListener('click', function () {
            var phoneNumber = document.getElementById('phone').value.trim();
            if (phoneNumber.length !== 10 || !/^[6-9]\d{9}$/.test(phoneNumber)) {
                alert('Please enter a valid 10-digit phone number.'); return;
            }
            var form = document.getElementById('rxForm');
            var inputs = form.querySelectorAll('input[required]');
            var isValid = true;
            inputs.forEach(function (input) { if (!input.value.trim()) { isValid = false; } });
            if (!isValid) { alert('Please fill in all required fields.'); return; }
            form.submit();
        });
    </script>