<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Patients User Count</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green text-white">Generate Excel</button>
                            <input class="search" type="text" id="searchInput" placeholder="Search ">
                            <div class="row mt-2 mb-2">
                               <div class="dropdown col-sm-4">
                                    <select class="form-select" name="region" id="region">
                                        <option value="">Select Region</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($region)) {
                                            foreach ($region as $regionrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $regionrow['REGIONId']; ?>">
                                                    <?php echo $regionrow['REGION']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="hq" id="hq">
                                        <option value="">Select HQ</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $hqrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $hqrow['HQId']; ?>">
                                                    <?php echo $hqrow['HQ']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th scope="">S.no.</th>
                                        <th scope="">Employee Name</th>
                                        <th scope="">Emp. ID</th>
                                        <th scope="">Area</th>
                                        <th scope="">Region</th>
                                        <th scope="">Zone</th>
                                        <th scope="">Totel Patients</th>
                                        <!-- <th scope="">Date</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td><?php echo $serial + ($perPage * ($page - 1)) ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td> 
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                                <td><?php echo $row['entry_count']; ?></td>
                                                <!-- <td><?php // echo $row['date']; ?></td> -->
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                            
                             <?php   if(!empty($data)  && $total>$perPage){ ?>
                        
                             <ul id="pagination-demo" class="pagination-sm"></ul>
                            
                            <?php } ?>
                            <select class="form-select" name="pagesize" id="pagesize" >
                                        <option value="20" <?php if($perPage==20){ echo "selected";} ?> >20</option>
                                        <option value="50" <?php if($perPage==50){ echo "selected";} ?>>50</option>
                                        <option value="100" <?php if($perPage==100){ echo "selected";} ?>>100</option>
                                        <option value="500" <?php if($perPage==500){ echo "selected";} ?>>500</option>
                                    </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
    <script>
        $(document).ready(function () {
            function setpagination(total) {
                 console.log(total);
                 $('#pagination-demo').pagination('destroy');
                 console.log("setpagination",total);
                  $('#pagination-demo').pagination({
                    items: total,
                    itemsOnPage: $("#pagesize").val(),
                     cssStyle: 'light-theme',
                    onPageClick: function (pageNumber) {
                         $.ajax({ url: '<?php echo base_url("zone/get_patient_count_by_date"); ?>', type: 'get', 
                            data: { 
                                zone_id: $("#zone").val(),
                                region_id: $("#region").val(),
                                hq_id: $("#hq").val(),
                                startDate: $("#startDatepicker").val(),
                                endDate: $("#endDatepicker").val(),
                                searchText: $("#searchInput").val(),
                                page:pageNumber,
                                pagesize:$("#pagesize").val()
                            }, dataType: 'json', 
                            success: function (response) { 
                                updateTable(response.table_data,pageNumber); 
                                if(pageNumber==1){
                                    setpagination(response.table_data.length)
                                }
                            } 
                        }); 
                    }
                });
             }


            $('#tblSearch').click(function(){ 
                $.ajax({ url: '<?php echo base_url("zone/get_patient_count_by_date"); ?>', type: 'get', 
                    data: { 
                        region_id: $("#region").val(),
                        hq_id: $("#hq").val(),
                        startDate: $("#startDatepicker").val(),
                        endDate: $("#endDatepicker").val(),
                        searchText: $("#searchInput").val(),
                        page:page,
                        pagesize:$("#pagesize").val()
                    }, dataType: 'json', 
                    success: function (response) { 
                        updateTable(response.table_data); 
                    } 
                }); 
            });
            
            $('#tbltoxl').click(function(){ 
                let Str = "";
                if($('#zone').val()){
                    Str="zone="+$('#zone').val()
                }
                if($('#region').val()){
                    Str=Str+"&region="+$('#region').val()
                }
                if($('#hq').val()){
                    Str=Str+"&hq="+$('#hq').val()
                }
                if($('#startDatepicker').val()){
                    Str=Str+"&startDate="+$('#startDatepicker').val()
                }
                if($('#endDatepicker').val()){
                    Str=Str+"&endDate="+$('#endDatepicker').val()
                }
                window.open('<?php echo base_url(); ?>zone/generate_excel_by_total_doctors?'+Str, '_blank')
            });
            $('#region').change(function () {
                var regionId = $(this).val();
                if (regionId) {
                    $.ajax({
                        url: '<?php echo base_url("zone/get_hq_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#hq").empty();
                            $("#hq").append('<option value="">Select HQ</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['HQId'];
                                    var name = response[i]['HQ'];
                                    $("#hq").append("<option value='" + id + "'>" + name + "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                    var selectedZoneId = $("#zone").val();
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: selectedZoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                }
            });

            $('#hq').change(function () {
                var hqId = $(this).val();
                var regionId = $("#region").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_hq"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId,
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                    var selectedRegionId = $("#region").val();
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: selectedRegionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                }
            });

            function updateTable(tableData,pageNo = 1) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var html = "<tr>" + "<td>" + (((pageNo - 1) * $("#pagesize").val()) + (index + 1)) + "</td>" + "<td>" + row.user + "</td>" +
                            "<td>" + row.empno + "</td>" + "<td>" + row.HQ + "</td>" + "<td>" + row.REGION +
                            "</td>" + "<td>" + row.ZONE + "</td>" + "<td>" + row.entry_count + "</td>" +
                            "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
            
             setpagination(<?php echo $total;?>)
        });
    </script>
    <script>
        document.getElementById('searchInput').addEventListener('input', function() {
            const searchText = this.value.toLowerCase();
            const table = document.querySelector('.table');
            const rows = table.querySelectorAll('tbody tr');
            rows.forEach(function(row) {
                const columns = row.querySelectorAll('td');
                let found = false;
                columns.forEach(function(column) { if (column.textContent.toLowerCase().includes(searchText)) { found = true; } });
                if (found) { row.style.display = ''; } 
                else { row.style.display = 'none'; }
            });
        });    
    </script>
</body>
 </html>