<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Doctors</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green  text-white">Generate Excel</button>
                            <table class="table" id="myTable" style="">
                                <thead>
                                    <tr class="">
                                        <th scope="col">S. No.</th>
                                        <th scope="col">Doctor Name</th>
                                        <th scope="col">Cln./Hosp. Name</th>
                                        <th scope="col">SBU Code</th>
                                        <th scope="col">Patients</th>
                                        <th scope="col">Phone</th>
                                        <th scope="col">E-mail</th>
                                        <th scope="col">Place</th>
                                        <th scope="col">District</th>
                                        <th scope="col">State</th>
                                        <th scope="col">Country</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Employee</th>
                                        <th scope="col">Emp. ID</th>
                                        <th scope="col">Area</th>
                                        <th scope="col">Region</th>
                                        <th scope="col">Zone</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td><?php echo $serial ?></td>
                                                <td><?php echo $row['doctor']; ?></td>
                                                <td><?php echo $row['hospital']; ?></td>
                                                <td><?php echo $row['registration_no']; ?></td>
                                                <td>
                                                    <a href="<?php echo site_url('abm/doctor_patients/' . $row['id']) ?>"
                                                        style="border-radius: 3px;" class="btn bg-green text-white "><i class="bi bi-people "></i>
                                                    </a>
                                                </td>
                                                <td><?php echo $row['phone']; ?></td>
                                                <td><?php echo $row['email']; ?></td>
                                                <td><?php echo $row['place']; ?></td>
                                                <td><?php echo $row['district']; ?></td>
                                                <td><?php echo $row['state']; ?></td>
                                                <td><?php echo $row['country']; ?></td>
                                                <td><?php echo $row['date']; ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td>
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>Record Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
</body>
</html>