
<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

<body>
    <!-- Sidebar Start -->
    <?php include ("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include ("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Patients Rx</h3>
                        <button id="tbltoxl" class="btn bg-green text-white">Generate Excel</button>
                        <input class="search" type="text" id="searchInput" placeholder="Search ">
                        <div class="row mt-2 mb-2">
                            <div class="dropdown col-sm-4">
                                <select class="form-select" name="hq" id="hq">
                                    <option value="">Select HQ</option>
                                    <?php
                                    $serial = 0;
                                    if (!empty($hq)) {
                                        foreach ($hq as $hqrow) {
                                            $serial++;
                                            ?>
                                            <option value="<?php echo $hqrow['HQId']; ?>">
                                                <?php echo $hqrow['HQ']; ?>
                                            </option>
                                        <?php }
                                    } else { ?>
                                        <h4>Record Not Found</h4>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable" style="">
                                <thead>
                                    <tr>
                                    <th scope="col">S. No</th>
                                        <th scope="col">Image</th>
                                        <th scope="col">Patient Name</th>
                                        <th scope="col">Patient Phone</th>
                                        <th scope="col">Doctor Name</th>
                                        <th scope="col">Quantity of Strips</th>
                                        <th scope="col">Indication</th>
                                        <th scope="col">Secondary</th>
                                        <th scope="col">Prescription Information</th>
                                        <th scope="col">Co-Morbidity Prescription</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Employee</th>
                                        <th scope="col">Emp. ID</th>
                                        <th scope="col">Area</th>
                                        <th scope="col">Region</th>
                                        <th scope="col">Zone</th>
                                    </tr>
                                </thead>
 
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                            <td><?php echo $serial ?></td>
                                                <td>
                                                    <?php $file_extension = pathinfo($row['image'], PATHINFO_EXTENSION);
                                                    $allowed_extensions = array('jpg', 'jpeg', 'png', 'gif', 'bmp');
                                                    if (in_array(strtolower($file_extension), $allowed_extensions)) {
                                                        echo '<img src="' . base_url() . '/assets/patient_data/' . $row['image'] . '" style="width:100px">';
                                                    } else { echo $row['image'];} ?>
                                                </td>
                                                <td><?php echo $row['patient_name']; ?></td>
                                                <td><?php echo $row['phone_no']; ?></td>
                                                <td><?php echo $row['doctor_name']; ?></td>
                                                <td><?php echo $row['strips']; ?></td>
                                                <td><?php echo $row['indication']; ?></td>
                                                <td><?php echo $row['secondary']; ?></td>
                                                <td><?php echo $row['prescription_information']; ?></td>
                                                <td><?php echo $row['co_morbidity_prescription']; ?></td>
                                                <td><?php echo $row['date']; ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td>
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include ("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
    <script>
        $(document).ready(function () {
            $('#hq').change(function () {
                var hqId = $(this).val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("rbm/get_rx_by_hq"); ?>',
                        type: 'post',
                        data: {
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                    var selectedRegionId = $("#region").val();
                    $.ajax({
                        url: '<?php echo base_url("rbm/get_rx_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: selectedRegionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                }
            });

            function updateTable(tableData) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var imageExtensions = ['webp', 'jpg', 'jpeg', 'png', 'gif'];
                        var imageExtension = row.image.split('.').pop().toLowerCase();
                        var isValidImage = imageExtensions.includes(imageExtension);
                        var imageHtml;
                        if (isValidImage) {
                            var imageUrl = "<?php echo base_url(); ?>/assets/patient_data/" + row.image;
                            imageHtml = "<img src='" + imageUrl + "' style='width:100px' onerror='this.onerror=null;this.outerHTML=\"" + row.image + "\";'>";
                        } else {
                            imageHtml = row.image;
                        }
                        var html = "<tr>" + "<td>" + (index + 1) + "</td>" +
                            "<td>" + imageHtml + "</td>" +
                            "<td>" + row.patient_name + "</td>" + "<td>" + row.doctor_name + "</td>" + "<td>" + row.phone_no + "</td>" + 
                            "<td>" + row.strips + "</td>" + "<td>" + row.indication + "</td>" + "<td>" + row.secondary + "</td>" + 
                            "<td>" + row.prescription_information + "</td>" + "<td>" + row.co_morbidity_prescription + "</td>" + 
                            "<td>" + row.date + "</td>" + "<td>" + row.user + "</td>" + "<td>" + row.empno + "</td>" +
                            "<td>" + row.HQ + "</td>" + "<td>" + row.REGION + "</td>" + "<td>" + row.ZONE + "</td>" + "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
        });
    </script>
</body>

</html>