<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();
$routes->setAutoRoute(true);


/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Index_controller');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
 
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF chapters_indion are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.



//*-------------- Admin User --------------*//

$routes->get('/index', 'Index_controller::index');
$routes->get('/admin', 'Index_controller::index');
$routes->get('/admin/index', 'Index_controller::index');
$routes->post('/admin/login', 'Index_controller::login');
$routes->get('/logout', 'Index_controller::logout');

$routes->get('/admin/profile', 'Admin_controller::admin_profile');
$routes->get('/admin/profile_edit/(:num)', 'Admin_controller::profile_edit/$1');
$routes->post('/admin/profile_update', 'Admin_controller::profile_update');
$routes->get('/admin/dashboard', 'Admin_controller::dashboard');

$routes->get('/admin/employee_form', 'Admin_controller::employee_form');
$routes->get('/admin/employee_table', 'Admin_controller::employee_table');
$routes->post('/admin/employee_insert', 'Admin_controller::employee_insert');
$routes->get('/admin/employee_edit/(:num)', 'Admin_controller::employee_edit/$1');
$routes->post('/admin/employee_update', 'Admin_controller::employee_update');
$routes->get('/admin/employee_delete/(:num)', 'Admin_controller::employee_delete/$1');

$routes->get('/admin/campaign_form', 'Admin_controller::campaign_form');
$routes->get('/admin/campaign_table', 'Admin_controller::campaign_table');
$routes->post('/admin/campaign_insert', 'Admin_controller::campaign_insert');
$routes->get('/admin/campaign_edit/(:num)', 'Admin_controller::campaign_edit/$1');
$routes->post('/admin/campaign_update', 'Admin_controller::campaign_update');
$routes->get('/admin/campaign_delete/(:num)', 'Admin_controller::campaign_delete/$1');

$routes->get('/admin/language_form', 'Admin_controller::language_form');
$routes->get('/admin/language_table', 'Admin_controller::language_table');
$routes->post('/admin/language_insert', 'Admin_controller::language_insert');
$routes->get('/admin/language_edit/(:num)', 'Admin_controller::language_edit/$1');
$routes->post('/admin/language_update', 'Admin_controller::language_update');
$routes->get('/admin/language_delete/(:num)', 'Admin_controller::language_delete/$1');

$routes->get('/admin/frame_form', 'Admin_controller::frame_form');
$routes->get('/admin/frame_table', 'Admin_controller::frame_table');
$routes->post('/admin/frame_insert', 'Admin_controller::frame_insert');
$routes->get('/admin/frame_edit/(:num)', 'Admin_controller::frame_edit/$1');
$routes->post('/admin/frame_update', 'Admin_controller::frame_update');
$routes->get('/admin/frame_delete/(:num)', 'Admin_controller::frame_delete/$1');

$routes->get('/admin/totel_poster', 'Admin_controller::totel_poster');
$routes->get('/admin/top_users', 'Admin_controller::top_users');
$routes->get('/admin/users_count', 'Admin_controller::users_count');
$routes->get('/admin/users_date_count', 'Admin_controller::users_date_count');
$routes->get('/admin/users_date/(:num)', 'Admin_controller::users_date/$1');

// -------------- ZBM -------------- //

$routes->get('/zone/dashboard', 'Zone_controller::z_dashboard');
$routes->get('/zone/totel_poster', 'Zone_controller::z_totel_poster');
$routes->get('/zone/top_users', 'Zone_controller::z_top_users');
$routes->get('/zone/users_count', 'Zone_controller::z_users_count');
$routes->get('/zone/users_date_count', 'Zone_controller::z_users_date_count');

$routes->get('/zone/employee_form', 'Zone_controller::z_employee_form');
$routes->get('/zone/employee_table', 'Zone_controller::z_employee_table');
$routes->post('/zone/employee_insert', 'Zone_controller::z_employee_insert');
$routes->get('/zone/employee_edit/(:num)', 'Zone_controller::z_employee_edit/$1');
$routes->post('/zone/employee_update', 'Zone_controller::z_employee_update');
$routes->get('/zone/employee_delete/(:num)', 'Zone_controller::z_employee_delete/$1');

$routes->get('/zone/profile', 'Zone_controller::z_admin_profile');

// -------------- Region -------------- //

$routes->get('/region/dashboard', 'Region_controller::r_dashboard');
$routes->get('/region/totel_poster', 'Region_controller::r_totel_poster');
$routes->get('/region/top_users', 'Region_controller::r_top_users');
$routes->get('/region/users_count', 'Region_controller::r_users_count');
$routes->get('/region/users_date_count', 'Region_controller::r_users_date_count');

$routes->get('/region/employee_form', 'Region_controller::r_employee_form');
$routes->get('/region/employee_table', 'Region_controller::r_employee_table');
$routes->post('/region/employee_insert', 'Region_controller::r_employee_insert');
$routes->get('/region/employee_edit/(:num)', 'Region_controller::r_employee_edit/$1');
$routes->post('/region/employee_update', 'Region_controller::r_employee_update');
$routes->get('/region/employee_delete/(:num)', 'Region_controller::r_employee_delete/$1');

$routes->get('/region/profile', 'Region_controller::r_admin_profile');

// -------------- Area -------------- //


$routes->get('/area/dashboard', 'Area_controller::a_dashboard');
$routes->get('/area/totel_poster', 'Area_controller::a_totel_poster');
$routes->get('/area/top_users', 'Area_controller::a_top_users');
$routes->get('/area/users_count', 'Area_controller::a_users_count');
$routes->get('/area/users_date_count', 'Area_controller::a_users_date_count');

$routes->get('/area/employee_form', 'Area_controller::a_employee_form');
$routes->get('/area/employee_table', 'Area_controller::a_employee_table');
$routes->post('/area/employee_insert', 'Area_controller::a_employee_insert');
$routes->get('/area/employee_edit/(:num)', 'Area_controller::a_employee_edit/$1');
$routes->post('/area/employee_update', 'Area_controller::a_employee_update');
$routes->get('/area/employee_delete/(:num)', 'Area_controller::a_employee_delete/$1');

$routes->get('/area/profile', 'Area_controller::a_admin_profile');

// -------------- User -------------- //

$routes->get('/user/home', 'User_controller::home');
$routes->get('/user/get_campaigns_by_language/(:num)', 'User_controller::get_campaigns_by_language/$1');
$routes->get('/user/poster_maker/(:num)', 'User_controller::poster_maker/$1');
$routes->post('/user/add_poster', 'User_controller::add_poster');
$routes->post('/user/update_download_status', 'User_controller::update_download_status');
$routes->post('/user/update_share_status', 'User_controller::update_share_status');
$routes->get('/user/poster_table', 'User_controller::poster_tbl');



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
