<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Usertype_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Index_controller extends BaseController
{

    public function index()
    {
        return view('user_bo/index');
    }

    public function login()
    {
        $model = new User_Model();
        $result = $model->where('emp_no', $this->request->getVar('emp_no'))->
            where('pass', $this->request->getVar('password'))->
            first();
        $session = session();
        if ($result != null) {
            $session = session();
            $sessionData = [
                'user_id' => $result['user_id'],
                'fk_usertype_id' => $result['fk_usertype_id'],

                'isLoggedIn' => true
            ];
            $session->set($sessionData);

            switch ($result['fk_usertype_id']) {
                case '5':
                    return redirect()->to('/admin/dashboard');
                case '4':
                    return redirect()->to('/zone/dashboard');
                case '3':
                    return redirect()->to('/region/dashboard');
                case '2':
                    return redirect()->to('/area/dashboard');
                case '1':
                    return redirect()->to('/user/home');
                default:
                    return redirect()->back()->withInput()->with('error', 'Invalid access level.');
            }

        } else {
            $session->setFlashdata('error', 'Your ID or Password is incorrect.');
            return redirect()->back()->withInput();
        }
    }

    public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('/admin');
    }

}