<?php
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;

    require 'E:/xampp/htdocs/CPR_App/vendor/autoload.php'; 
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $name = strip_tags(trim($_POST["name"]));
        $name = str_replace(array("\r","\n"),array(" "," "),$name);
        $email = filter_var(trim($_POST["email"]), FILTER_SANITIZE_EMAIL);
        $cont_subject = strip_tags(trim($_POST["subject"]));
        $message = trim($_POST["message"]);

        if (empty($name) || empty($message) || empty($cont_subject) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            http_response_code(400);
            echo "Oops! There was a problem with your submission. Please complete the form and try again.";
            exit;
        }

        $mail = new PHPMailer(true);

        try {
            $mail->SMTPDebug = 0; 
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com'; 
            $mail->SMTPAuth = true;
            $mail->Username = 'YourGmail@gmail.com'; 
            $mail->Password = 'Your Gmail password'; 
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            $mail->setFrom($email, $name);
            $mail->addAddress('Recipient@gmail.com'); 

            
            $mail->isHTML(false);
            $mail->Subject = "New contact from $name";
            $mail->Body = "Name: $name\nEmail: $email\n\nSubject: $cont_subject\nMessage:\n$message\n";

          
            if ($mail->send()) {
                http_response_code(200);
                echo "Thank You! Your message has been sent.";
            } else {
                http_response_code(500);
                echo "Oops! Something went wrong and we couldn't send your message.";
            }

        } catch (Exception $e) {
            echo "Mailer Error: {$mail->ErrorInfo}";
            error_log("Mail could not be sent. PHPMailer Error: {$mail->ErrorInfo}");
            http_response_code(500);
        }

    } else {
        http_response_code(403);
        echo "There was a problem with your submission, please try again.";
    }
?>
