<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
<body>
    <section class="section pt-0" id="about">
        <?php include ("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <h5>Personal Information of Healthcare Provider</h5>
                    <form id="doctorForm" action="<?php echo site_url('/user/doctor_data') ?>" method="post" onsubmit="return validateForm()">
                        <input class="input" type="text" required name="doctor" placeholder="Doctor Name">
                        <input class="input" type="text" required name="hospital" placeholder="Clinic / Hospital Name">
                        <input class="input" type="text" required name="registration_no" maxlength="16" placeholder="SBU Code">
                        <input class="input" type="tel" required name="phone" id="phone" pattern="[6-9]{1}[0-9]{9}" placeholder="Phone">
                        <input class="input" type="email" required name="email" placeholder="E-mail">
                        <input class="input" type="text" required name="place" placeholder="Place">
                        <input class="input" type="text" required name="district" placeholder="District">
                        <input class="input" type="text" required name="state" placeholder="State">
                        <input class="input" type="text" required name="country" placeholder="Country">
                        <input class="input" type="hidden" required name="user_id" value="<?= $row['UserID']; ?>">
                        <input class="input" type="hidden" required name="user" value="<?= $row['Name']; ?>">
                        <input class="input" type="hidden" required name="empno" value="<?= $row['empNO']; ?>">
                        <input class="input" type="hidden" required name="hq_id" value="<?= $row['HQ']; ?>">
                        <input class="input" type="hidden" required name="region_id" value="<?= $row['REGIONId']; ?>">
                        <input class="input" type="hidden" required name="zone_id" value="<?= $row['zoneId']; ?>">
                        <div class="text-center"><br><button type="submit" class="btn sub-btn">Submit</button></div>
                    </form>
                </div>
            </div>
        </div>
        <div class=""><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt="MHAC Character"></div>
    </section>
    <?php include ("footer.php") ?>
    <script>
        function validateForm() {
            var doctor = document.forms["doctorForm"]["doctor"].value.trim(); var hospital = document.forms["doctorForm"]["hospital"].value.trim(); var registration_no = document.forms["doctorForm"]["registration_no"].value.trim(); var phone = document.forms["doctorForm"]["phone"].value.trim(); var email = document.forms["doctorForm"]["email"].value.trim(); var place = document.forms["doctorForm"]["place"].value.trim(); var district = document.forms["doctorForm"]["district"].value.trim(); var state = document.forms["doctorForm"]["state"].value.trim(); var country = document.forms["doctorForm"]["country"].value.trim();
            if (doctor == "" || hospital == "" || registration_no == "" || phone == "" || email == "" || place == "" || district == "" || state == "" || country == "") { alert("Please fill out all fields"); return false; }
            if (phone.length != 10 || isNaN(phone)) { alert("Please enter a valid 10-digit phone number"); return false; }
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/; if (!emailPattern.test(email)) { alert("Please enter a valid email address"); return false; }
            var xhr = new XMLHttpRequest(); xhr.onreadystatechange = function() { if (xhr.readyState === XMLHttpRequest.DONE) { if (xhr.status === 200) { var response = xhr.responseText; if (response === "exists") { alert("Phone Number is Already Registered"); } else { document.getElementById("doctorForm").submit(); } } else { alert("Error checking phone number"); } } };
                xhr.open("POST", "<?php echo site_url('user/check_phone_exists') ?>", true);
                xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                xhr.send("phone=" + phone);
                return false;
        }
    </script>
</body>
</html>