<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>

<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php"); ?>
        <div class="box-container text-center ">

            <div class="dropdown">
                <button class="dropdown-toggle" onclick="toggleDropdown()">Select Language</button>
                <div class="dropdown-menu" id="dropdownMenu">
                    <?php foreach ($language as $row): ?>
                        <a href="#" onclick="fetchCampaigns(<?= $row['language_id']; ?>)">
                            <?= esc($row['language']); ?>
                        </a>
                    <?php endforeach; ?>
                </div>

                <div id="campaignLinks" style="margin-top: 0px;"></div>
            </div>

        </div>
        <!-- <div ><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt="MHAC Character"></div> -->
    </section>
    <script>
        function toggleDropdown() {
            const dropdownMenu = document.getElementById("dropdownMenu");
            const isShowing = dropdownMenu.classList.contains("show");
            
            // Clear campaigns if dropdown is being shown
            if (!isShowing) {
                document.getElementById("campaignLinks").innerHTML = "";
            }
            
            dropdownMenu.classList.toggle("show");
        }

        window.onclick = function (event) {
            if (!event.target.matches('.dropdown-toggle')) {
                var dropdowns = document.getElementsByClassName("dropdown-menu");
                for (var i = 0; i < dropdowns.length; i++) {
                    dropdowns[i].classList.remove('show');
                }
            }
        }

        function fetchCampaigns(languageid) {
            fetch("<?= base_url('user/get_campaigns_by_language/') ?>" + languageid)
                .then(response => response.json())
                .then(data => {
                    let html = '';
                    if (data.length > 0) {
                        data.forEach(row => {
                            html += `<div style="margin-bottom: 10px;">
                        <a href="<?= base_url('user/poster_maker') ?>/${row.frame_id}" class="btn-link">
                           ${row.campaign_name}
                        </a><br>
                        <img src="<?= base_url(); ?>/assets/frame/${row.frame_name}" style="height:320px; margin-top:10px; Box-shadow: 0 4px 12px rgba(0, 0, 0, 0.407);">
                    </div>`;
                        });
                    } else {
                        html = '<p style="color: #000">No campaigns found for selected language.</p>';
                    }

                    document.getElementById('campaignLinks').innerHTML = html;
                })
                .catch(error => {
                    console.error('Error fetching campaigns:', error);
                });
        }
    </script>

</body>
</html>