<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="MHAC - Mission Hypertension Awareness & Control">
    <meta name="author" content="Devcrud">
    <title>MHAC - Mission Hypertension Awareness & Control</title>
    <link rel="stylesheet" href="<?php echo base_url(); ?>/asset/vendors/themify-icons/css/themify-icons.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>/asset/css/meyawo.css" />
    <style>
        .hidden { display: none; }
        .hide-sec { display: none; }
    </style>
</head>
<body>
    <section class="section pt-0" id="about">
        <?php include ("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <h5>Patient / Volunteer Data</h5>
                    <form action="<?php echo site_url('/user/patient_data') ?>" method="post"
                        onsubmit="return validateForm()">
                        <div class="sec-1">
                            <input onkeyup="validateName(this)" class="input" type="text" id="searchInput" required oninput="filterOptions()" name="name" placeholder="Name">
                            <select id="selectOptions" style="display: none;" onchange="fillInputField()">
                                <?php
                                $serial = 0;
                                if (!empty($patients)) {
                                    foreach ($patients as $patients_row) {
                                        $serial++; ?>
                                        <option value="<?php echo $patients_row['name']; ?>">
                                            <?php echo $patients_row['name']; ?> <?php echo $patients_row['date']; ?>
                                        </option>
                                    <?php }
                                } else { ?>
                                <?php } ?>
                            </select>
                            <input onkeyup="validatePhone(this)" class="input" type="tel" id="input_style" name="phone" pattern="[6-9]{1}[0-9]{9}" placeholder="Phone ">
                            <input onkeyup="validateAge(this)" class="input" type="number" id="input_style" required name="age" placeholder="Age">
                            <input class="input" type="text" id="input_style" required name="place" onkeyup="validateName(this)" placeholder="Place">
                            <br><label>Date of Examination </label>
                            <input class="input" type="date" id="input_style" required name="examination" placeholder="Date of Examination">
                            <br><label>Gender : </label><br>
                            <label class="radio-inline input">Male <input type="radio" name="gender" required value="Male"></label>
                            <label class="radio-inline input">Female <input type="radio" name="gender" required value="Female"></label>
                            <label class="radio-inline input">Other <input type="radio" name="gender" required value="Other"></label>
                            <input class="input" type="hidden" required name="dr_id" value="<?= $row['id']; ?>">
                            <input class="input" type="hidden" required name="user_id" value="<?= $row['user_id']; ?>">
                            <input class="input" type="hidden" required name="user" value="<?= $row['user']; ?>">
                            <input class="input" type="hidden" required name="empno" value="<?= $row['empno']; ?>">
                            <input class="input" type="hidden" required name="hq_id" value="<?= $row['hq_id']; ?>">
                            <input class="input" type="hidden" required name="region_id" value="<?= $row['region_id']; ?>">
                            <input class="input" type="hidden" required name="zone_id" value="<?= $row['zone_id']; ?>">
                            <br><br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-1', 'sec-1')">Back</button>
                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-1', 'sec-2')">Next</button>
                            </div>
                        </div>
                        <div class="sec-2 hide-sec">
                            <label>Known case of Hypertension</label><br>
                            <label class="radio-inline  input">Yes <input type="radio" name="hypertension" required value="Yes" onclick="showInputField()"></label>
                            <label class="radio-inline  input">No <input type="radio" name="hypertension" required value="No" onclick="hideInputField()"></label><br>
                            <div class="radio-inline hidden"> What therapy? <br>
                                <label class="ahd">Mono<input type="radio" name="drugs" required value="Mono"></label>
                                <label class="ahd">Dual<input type="radio" name="drugs" required value="Dual"></label>
                                <label class="ahd">Triple<input type="radio" name="drugs" required value="Triple"></label>
                            </div>
                            <br>
                            <div class="Combination hidden">Which Combination: <br>
                                <div class="Combination-Drugs">
                                    <label class="ARB-Main drugs-main  ">ARB <input type="checkbox" name="combination[]" value="ARB"></label><br>
                                    <div class="ARB-additional drugs-additional hidden">
                                        <label>Telmisartan <input type="checkbox" name="ARB[]" value="Telmisartan"></label>
                                        <label>Olmesartan <input type="checkbox" name="ARB[]" value="Olmesartan"></label>
                                        <label>Losartan <input type="checkbox" name="ARB[]" value="Losartan"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input class="input other" type="text" id="input_style" name="ARB_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="ARB_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="ACE-I-Main drugs-main "> ACE-I <input type="checkbox" name="combination[]" value="ACE-I"></label><br>
                                    <div class="ACE-I-additional drugs-additional hidden">
                                        <label>Ramipril <input type="checkbox" name="ACE-I[]" value="Ramipril"></label>
                                        <label>Lisinopril <input type="checkbox" name="ACE-I[]" value="Lisinopril"></label>
                                        <label>Perindopril <input type="checkbox" name="ACE-I[]" value="Perindopril"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input class="input other" type="text" id="input_style" name="ACE_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="ACE_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="BB-Main drugs-main ">BB <input type="checkbox" name="combination[]" value="BB"></label><br>
                                    <div class="BB-additional drugs-additional hidden">
                                        <label>Metoprolol <input type="checkbox" name="BB[]" value="Metoprolol"></label>
                                        <label>Bisoprolol <input type="checkbox" name="BB[]" value="Bisoprolol"></label>
                                        <label>Atenolol <input type="checkbox" name="BB[]" value="Atenolol"></label>
                                        <label>Carvedilol <input type="checkbox" name="BB[]" value="Carvedilol"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input class="input other" type="text" id="input_style" name="BB_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="BB_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="CCB-Main drugs-main ">CCB <input type="checkbox" name="combination[]" value="CCB"></label><br>
                                    <div class="CCB-additional drugs-additional hidden">
                                        <label>Amlodipine <input type="checkbox" name="CCB[]" value="Amlodipine"></label>
                                        <label>Cilnidipine <input type="checkbox" name="CCB[]" value="Cilnidipine"></label>
                                        <label>Azelnidipine <input type="checkbox" name="CCB[]" value="Azelnidipine"></label>
                                        <label>Nifedipine <input type="checkbox" name="CCB[]" value="Nifedipine"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input class="input other" type="text" id="input_style" name="CCB_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="CCB_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="Diuretic-Main drugs-main ">Diuretic <input type="checkbox" name="combination[]" value="Diuretic"></label><br>
                                    <div class="Diuretic-additional drugs-additional hidden">
                                        <label>Chlorthalidone <input type="checkbox" name="Diuretic[]" value="Chlorthalidone"></label>
                                        <label>HCTZ <input type="checkbox" name="Diuretic[]" value="HCTZ"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input class="input other" type="text" id="input_style" name="Diuretic_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="Diuretic_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="Other-Main drugs-main ">Other <input type="checkbox" name="combination[]" value="Other"></label><br>
                                    <div class="Other-additional drugs-additional hidden">
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input class="input other" type="text" id="input_style" name="Other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="Other_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                            </div><br>
                            <div class="text-center pt-3">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-2', 'sec-1')">Back</button>
                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-2', 'sec-3')">Next</button>
                            </div>
                        </div>
                        <div class="sec-3 hide-sec">
                            <h6>Take 3 BP Readings with 2 minutes gap</h6>
                            <label style="margin-bottom:0px">Reading 1</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="sbp1" id="sbp1" required placeholder="mmHg"></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="dbp1" id="dbp1" required placeholder="mmHg"></label>
                            <label style="margin-top:8px; margin-bottom:0px">Reading 2</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="sbp2" id="sbp2" required placeholder="mmHg"></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="dbp2" id="dbp2" required placeholder="mmHg"></label>
                            <label style="margin-top:8px; margin-bottom:0px">Reading 3</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="sbp3" id="sbp3" required placeholder="mmHg"></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="dbp3" id="dbp3" required placeholder="mmHg"></label>
                            <label style="margin-top:8px; margin-bottom:0px">Average Reading</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="average_sbp" id="average_sbp" required placeholder="mmHg" readonly></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="average_dbp" id="average_dbp" required placeholder="mmHg" readonly></label>
                            <br><br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-3', 'sec-2')">Back</button>
                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-3', 'sec-4')">Next</button>
                            </div>
                            <p><b>Note:</b><br>1. If increase in BP, he or she needs to seek repeat examination after a week. 
                               <br>2. <b>DBP</b> can not be higher then <b>SBP</b>
                               <br>3. Take 3 readings with a gap of 2 minutes
                            </p>
                        </div>
                        <div class="sec-4 hide-sec">
                            <h6 >Co-morbid Conditions if any:</h6>
                            <label style="padding-left:10px">Diabetes <input type="checkbox" class="co-morbid" checked name="comorbid_con[]" value="Diabetes"></label>
                            <label style="padding-left:10px">Established-ASCVD <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="Established-ASCVD"></label>
                            <label style="padding-left:10px">CKD <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="CKD"></label>
                            <label style="padding-left:10px">Previous Stroke <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="Previous Stroke"></label>
                            <label style="padding-left:10px margin-bottom:10px">Other:</label>
                            <input class="input" type="text" id="input_style" name="comorbid_other" class="co-morbid" placeholder="Other"><br>
                            <label style="margin-bottom:10px">Drugs for co-morbidity </label>
                            <label style="margin:0px" class="radio-inline  "><textarea type="text" class="input" name="drg_comorbid" rows="1" id="textarea " placeholder="Drugs for co-morbidity "></textarea></label>
                            <br><br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-4', 'sec-3')">Back</button>
                                <button type="submit" class="btn sub-btn"> Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class=""><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt=" "></div>
    </section>
    <?php include ("footer.php") ?>
    <script>
        function validateForm(section) {
            if (section === 'sec-1') {
                var name = document.querySelector('input[name="name"]').value.trim();
                var place = document.querySelector('input[name="place"]').value.trim();
                var examination = document.querySelector('input[name="examination"]').value.trim();
                var age = document.querySelector('input[name="age"]').value.trim();
                var gender = document.querySelector('input[name="gender"]:checked');
                if (name === '' || place === '' || examination === '' || age === '' || !gender) {
                    alert('Please fill in all fields ');
                    return false;
                }
            } else if (section === 'sec-2') {
                var hypertension = document.querySelector('input[name="hypertension"]:checked');
                if (!hypertension) {
                    alert('Please Choose one option for Hypertension');
                    return false;
                } else if (hypertension.value === 'Yes') {
                    var drugsRadio = document.querySelector('input[name="drugs"]:checked');
                    if (!drugsRadio) {
                        alert("Its Mandatory to select the type of Hypertension Therapy ");
                        return false;
                    }
                    var checkboxes = document.querySelectorAll('input[name="combination[]"]:checked');
                    var maxChecked = parseInt(drugsRadio.value);
                    if (drugsRadio.value === 'Mono') {
                        if (checkboxes.length !== 1) {
                            alert("Anti-Hypertensive class of drug mandatory to be selected");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Dual') {
                        if (checkboxes.length !== 2) {
                            alert("Anti-Hypertensive 2 classes of drug mandatory to be selected");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Triple') {
                        if (checkboxes.length < 3) {
                            alert("Anti-Hypertensive 3 classes of drug mandatory to be selected");
                            return false;
                        }
                    }
                    var combinationDrugs = document.querySelectorAll('.Combination-Drugs');
                    for (var i = 0; i < combinationDrugs.length; i++) {
                        var mainCheckbox = combinationDrugs[i].querySelector('.drugs-main input[type="checkbox"]');
                        var additionalCheckboxes = combinationDrugs[i].querySelectorAll('.drugs-additional input[type="checkbox"]');
                        var additionalDoseInputs = combinationDrugs[i].querySelectorAll('.drugs-additional input[type="number"].dose');
                        var otherInput = combinationDrugs[i].querySelector('.drugs-additional input[type="text"].input.other'); // Selector for the other input field
                        if (mainCheckbox.checked) {
                            var additionalChecked = Array.from(additionalCheckboxes).some(function(checkbox) {
                                return checkbox.checked;
                            });                    
                            var otherInputFilled = otherInput && otherInput.value.trim() !== "";                    
                            if (additionalChecked || otherInputFilled) {
                                var doseFilled = false;
                                for (var j = 0; j < additionalCheckboxes.length; j++) {
                                    if (additionalCheckboxes[j].checked) {
                                        if (j < additionalDoseInputs.length) {
                                            var doseInput = additionalDoseInputs[j];
                                            if (!doseInput.value.trim()) {
                                                alert("It's Mandatory to Fill Dose Input Field for " + additionalCheckboxes[j].parentNode.textContent.trim());
                                                return false;
                                            } else {
                                                doseFilled = true;
                                            }
                                        }
                                    }
                                }
                                if (otherInputFilled && !doseFilled) {
                                    for (var j = 0; j < additionalDoseInputs.length; j++) {
                                        if (additionalDoseInputs[j].value.trim()) {
                                            doseFilled = true;
                                            break;
                                        }
                                    }
                                    if (!doseFilled) {
                                        alert("It's Mandatory to Fill 'dose' input field for " + mainCheckbox.parentNode.textContent.trim());
                                        return false;
                                    }
                                }
                            } else {
                                alert('Select class of drugs or fill the other input field for ' + mainCheckbox.parentNode.textContent.trim());
                                return false;
                            }
                        }
                    }
                    
                }
            } else if (section === 'sec-3') {
                var sbp1 = parseInt(document.querySelector('input[name="sbp1"]').value);
                var dbp1 = parseInt(document.querySelector('input[name="dbp1"]').value);
                var sbp2 = parseInt(document.querySelector('input[name="sbp2"]').value);
                var dbp2 = parseInt(document.querySelector('input[name="dbp2"]').value);
                var sbp3 = parseInt(document.querySelector('input[name="sbp3"]').value);
                var dbp3 = parseInt(document.querySelector('input[name="dbp3"]').value);
                if (isNaN(sbp1) || isNaN(dbp1) || isNaN(sbp2) || isNaN(dbp2) || isNaN(sbp3) || isNaN(dbp3)) {
                    alert('Please enter valid BP readings ');
                    return false;
                }
                if (sbp1 < dbp1 || sbp2 < dbp2 || sbp3 < dbp3) {
                    alert('SBP cannot be less than DBP ');
                    return false;
                }
                calculateAverage(); 
            } else if (section === 'sec-4') {
                var coMorbidCheckboxes = document.querySelectorAll('.co-morbid[type="checkbox"]:checked');
                var coMorbidOtherInput = document.querySelector('.co-morbid[type="text"]');
                var isCoMorbidChecked = false;

                for (var i = 0; i < coMorbidCheckboxes.length; i++) {
                    if (coMorbidCheckboxes[i].value !== 'Other') {
                        isCoMorbidChecked = true;
                        break;
                    }
                }
                if (isCoMorbidChecked || coMorbidOtherInput.value.trim() !== '') {
                    return true;
                } else {
                    alert('Please select at least one co-morbid condition or fill in the "Other" field');
                    return false;
                }
            }
            return true;
        }
        function calculateAverage() {
            var sbp1 = parseInt(document.getElementById("sbp1").value);
            var dbp1 = parseInt(document.getElementById("dbp1").value);
            var sbp2 = parseInt(document.getElementById("sbp2").value);
            var dbp2 = parseInt(document.getElementById("dbp2").value);
            var sbp3 = parseInt(document.getElementById("sbp3").value);
            var dbp3 = parseInt(document.getElementById("dbp3").value);
            var avg_sbp = ( sbp2 + sbp3) / 2;
            var avg_dbp = ( dbp2 + dbp3) / 2;
            document.getElementById("average_sbp").value = isNaN(avg_sbp) ? '' : avg_sbp.toFixed(2);
            document.getElementById("average_dbp").value = isNaN(avg_dbp) ? '' : avg_dbp.toFixed(2);
        }

        document.getElementById("sbp1").addEventListener("input", calculateAverage);
        document.getElementById("dbp1").addEventListener("input", calculateAverage);
        document.getElementById("sbp2").addEventListener("input", calculateAverage);
        document.getElementById("dbp2").addEventListener("input", calculateAverage);
        document.getElementById("sbp3").addEventListener("input", calculateAverage);
        document.getElementById("dbp3").addEventListener("input", calculateAverage);

        function showNextSection(currentSec, nextSec) {
            if (validateForm(currentSec)) {
                if (currentSec === 'sec-2') {
                    var hypertensionValue = document.querySelector('input[name="hypertension"]:checked').value;
                    if (hypertensionValue === 'Yes') {
                        hideAndUnhide(currentSec, 'sec-3');
                        return;
                    }
                }
                hideAndUnhide(currentSec, nextSec);
            }
        }
        function hideAndUnhide(currentSec, nextSec) {
            document.querySelector('.' + currentSec).style.display = 'none';
            document.querySelector('.' + nextSec).style.display = 'block';
            if (nextSec === 'sec-2') {
                enableCheckboxes(1); 
            }
        }
        function showPreviousSection(currentSec, prevSec) {
            hideAndUnhide(currentSec, prevSec);
            currentSection = prevSec;
        }
        function showInputField() {
            var inputs = document.querySelectorAll('.hidden');
            for (var i = 0; i < inputs.length; i++) {
                inputs[i].style.display = 'inline-block';
                if (inputs[i].getAttribute('type') === 'radio') {
                    inputs[i].setAttribute('required', 'required');
                }
            }
        }
        function hideInputField() {
            var drugsRadios = document.querySelectorAll('input[name="drugs"]');
            for (var j = 0; j < drugsRadios.length; j++) {
                if (drugsRadios[j].value === 'Mono') {
                    drugsRadios[j].setAttribute('value', 'No');
                    drugsRadios[j].checked = true;
                } else {
                    drugsRadios[j].disabled = true;
                }
            }
            var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var k = 0; k < combinationCheckboxes.length; k++) {
                if (combinationCheckboxes[k].value === 'ARB') {
                    combinationCheckboxes[k].checked = false;
                    combinationCheckboxes[k].value = 'NO'; 
                } else {
                    combinationCheckboxes[k].disabled = true;
                }
            }
        }
        function enableCheckboxes(maxChecked) {
            var checkboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].disabled = false;
            }
        }
        function validateName(input) {
            var namePattern = /^[a-zA-Z ]+$/;
            if (!input.value.match(namePattern)) {
                alert('Please enter letters only');
                input.value = '';
                return false;
            }
            return true;
        }
        function validatePhone(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^[6-9]\d{9}$/;
            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, '');
                if (input.value.length > 10) {
                    input.value = input.value.slice(0, 10);
                }
            }
        }
        function validateAge(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^\d{2}$/;
            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, '');
                if (input.value.length > 2) {
                    input.value = input.value.slice(0, 2);
                }
            }
        }        
        function filterOptions() {
            var input = document.getElementById("searchInput").value.toLowerCase();
            var select = document.getElementById("selectOptions");
            var options = select.getElementsByTagName("option");
            for (var i = 0; i < options.length; i++) {
                var optionValue = options[i].value.toLowerCase();
                if (optionValue.includes(input)) {
                    options[i].style.display = "";
                } else {
                    options[i].style.display = "none";
                }
            }
            if (input.length >= 3) {
                select.style.display = "";
                select.setAttribute("size", "5");
            } else {
                select.style.display = "none";
            }
        }
        function fillInputField() {
            var select = document.getElementById("selectOptions");
            var input = document.getElementById("searchInput");
            input.value = select.value;
            select.style.display = "none";
        }
        function fillInputField() {
            var select = document.getElementById("selectOptions");
            var selectedOption = select.options[select.selectedIndex];
            if (selectedOption) {
                var input = document.getElementById("searchInput");
                input.value = selectedOption.value;
                select.style.display = "none";
            }
        }
       document.getElementById("selectOptions").addEventListener("click", fillInputField);
    </script>
</body>
</html>