<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <h5> Prescription Information</h5>
                    <br>
                    <form id="rxForm" action="<?= site_url('/user/rx_data') ?>" method="post"
                        enctype="multipart/form-data" onsubmit="return checkDoctorName()">
                        <input onkeyup="validateName(this)" class="input" type="text" id="searchInput" required
                            oninput="filterOptions()" name="patient_name" placeholder="Patient Name">
                        <select id="selectOptions" style="display: none;" onchange="fillInputField()">
                            <option value="" selected disabled hidden>Select Patient</option>
                            <?php
                            $serial = 0;
                            if (!empty($patients)) {
                                foreach ($patients as $patients_row) { $serial++; ?>
                                    <option value="<?php echo $patients_row['name']; ?>"
                                        data-phone="<?php echo $patients_row['phone']; ?>"
                                        data-doctor="<?php echo $patients_row['doctor']; ?>"
                                        data-id="<?php echo $patients_row['id']; ?>"
                                        data-dr_id="<?php echo $patients_row['dr_id']; ?>"
                                        data-user_id="<?php echo $patients_row['user_id']; ?>"
                                        data-user="<?php echo $patients_row['user']; ?>"
                                        data-empno="<?php echo $patients_row['empno']; ?>"
                                        data-hq_id="<?php echo $patients_row['hq_id']; ?>"
                                        data-region_id="<?php echo $patients_row['region_id']; ?>"
                                        data-zone_id="<?php echo $patients_row['zone_id']; ?>">
                                        <?php echo $patients_row['name']; ?> <?php echo $patients_row['date']; ?>
                                    </option>
                                <?php }
                            } ?>
                        </select>
                        <input class="input" type="text" required readonly name="doctor_name" id="doctorName" placeholder="Doctor Name" value="">
                        <input class="input" type="tel" readonly id="phone" name="phone_number" pattern="[6-9]{1}[0-9]{9}" placeholder="Patient Phone">
                        <input class="input" type="number" required name="strips" placeholder="Quantity of Strips">
                        <input class="input" type="text" name="indication" placeholder="Indication">
                        <input class="input" type="number" required name="secondary" placeholder="Current Secondary in Units">
                        <div class="custom-dropdown">
                            <label class="form-label drop">Prescription Information</label>
                            <div class="custom-dropdown-content">
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm 20"> Telminorm 20</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm 40"> Telminorm 40</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm AM 40/5"> Telminorm AM 40/5</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm BXL 40/25"> Telminorm BXL 40/25</label>
                                <label><input type="checkbox" name="prescription_information[]" value="Telminorm BXL 40/50"> Telminorm BXL 40/50</label>
                            </div><span class="dropdown-icon">&#9660;</span>
                        </div>
                        <div class="custom-dropdown">
                            <label for="" class="form-label drop">Co-Morbidity Prescription</label>
                            <div class="custom-dropdown-content">
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 5"> RXtor 5</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 10"> RXtor 10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 20"> RXtor 20</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor 40"> RXtor 40</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor F 5"> RXtor F 5</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor F 10"> RXtor F 10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor Gold 10"> RXtor Gold 10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="RXtor Gold 20"> RXtor Gold 20</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip 25"> Suitglip 25</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip 50"> Suitglip 50</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip 100"> Suitglip 100</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - M 50/1000"> Suitglip - M 50/1000</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - M 50/500"> Suitglip - M 50/500</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - MXR 100/1000"> Suitglip - MXR 100/1000</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - MXR 100/500"> Suitglip - MXR 100/500</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip - MXR 50/500"> Suitglip - MXR 50/500</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip D 50/5"> Suitglip D 50/5</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Suitglip D 100/10"> Suitglip D 100/10</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree MV 1"> Glyree MV 1</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree MV 2"> Glyree MV 2</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M 1 Fort"> Glyree M 1 Fort</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M 2 Fort"> Glyree M 2 Fort</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M1"> Glyree M1</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree M2"> Glyree M2</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 1"> Glyree - 1</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 2"> Glyree - 2</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 3"> Glyree - 3</label>
                                <label><input type="checkbox" name="co_morbidity_prescription[]" value="Glyree - 4"> Glyree - 4</label>
                            </div><span class="dropdown-icon">&#9660;</span>
                        </div>
                        <input class=" " type="file" name="image" accept="image/webp,image/png,image/jpeg" style="width:222px; padding-left: 10px;">
                        <input class="input" type="hidden" required name="patient_id" value="">
                        <input class="input" type="hidden" required name="doctor_id" value="">
                        <input class="input" type="hidden" required name="user_id" value="">
                        <input class="input" type="hidden" required name="user" value="">
                        <input class="input" type="hidden" required name="empno" value="">
                        <input class="input" type="hidden" required name="hq_id" value="">
                        <input class="input" type="hidden" required name="region_id" value="">
                        <input class="input" type="hidden" required name="zone_id" value="">
                        <div class="text-center"><br>
                            <button type="submit" id="submitBtn" class="btn sub-btn">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class=""><img src="<?php echo base_url(); ?>asset/imgs/character.png" class="chr" alt="MHAC Character"></div>
    </section>
    <?php include("footer.php") ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var dropdowns = document.querySelectorAll('.custom-dropdown');
            dropdowns.forEach(function (dropdown) {
                var select = dropdown.querySelector('.form-label');
                var options = dropdown.querySelector('.custom-dropdown-content');
                select.addEventListener('click', function (e) {
                    e.stopPropagation();
                    dropdown.classList.toggle('clicked');
                });
                document.addEventListener('click', function () {
                    dropdown.classList.remove('clicked');
                });
            });
            function getUrlParams() {
                var params = {};
                var queryString = window.location.search.substring(1);
                var regex = /([^&=]+)=([^&]*)/g;
                var m;
                while (m = regex.exec(queryString)) {
                    params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
                }
                return params;
            }
            var params = getUrlParams();
            if (params.name) {
                var name = params.name.replace(/[^a-zA-Z\s]/g, ' '); 
                document.getElementById('searchInput').value = name;
                filterOptions(); 
            }
        });

        function filterOptions() {
            var input = document.getElementById("searchInput").value.toLowerCase();
            var select = document.getElementById("selectOptions");
            var options = select.getElementsByTagName("option");
            for (var i = 0; i < options.length; i++) {
                var optionValue = options[i].value.toLowerCase();
                if (optionValue.includes(input)) {
                    options[i].style.display = "";
                } else {
                    options[i].style.display = "none";
                }
            }
            if (input.length >= 3) {
                select.style.display = "";
                select.setAttribute("size", "5");
            } else {
                select.style.display = "none";
            }
        }

        function validateName(input) {
            var regex = /^[a-zA-Z\s]*$/;
            if (!regex.test(input.value)) {
                alert("Please enter a valid name (only alphabets and spaces allowed).");
                input.value = "";
            }
        }

        function fillInputField() {
            var select = document.getElementById("selectOptions");
            var input = document.getElementById("searchInput");
            var phoneInput = document.getElementById("phone");
            var doctorInput = document.querySelector('input[name="doctor_name"]');
            var patient_id = document.querySelector('input[name="patient_id"]');
            var doctor_id = document.querySelector('input[name="doctor_id"]');
            var user_id = document.querySelector('input[name="user_id"]');
            var user = document.querySelector('input[name="user"]');
            var empno = document.querySelector('input[name="empno"]');
            var hq_id = document.querySelector('input[name="hq_id"]');
            var region_id = document.querySelector('input[name="region_id"]');
            var zone_id = document.querySelector('input[name="zone_id"]');
            var selectedOption = select.options[select.selectedIndex];
            input.value = selectedOption.value;
            patient_id.value = selectedOption.getAttribute('data-id');
            doctor_id.value = selectedOption.getAttribute('data-dr_id');
            user_id.value = selectedOption.getAttribute('data-user_id');
            user.value = selectedOption.getAttribute('data-user');
            empno.value = selectedOption.getAttribute('data-empno');
            hq_id.value = selectedOption.getAttribute('data-hq_id');
            region_id.value = selectedOption.getAttribute('data-region_id');
            zone_id.value = selectedOption.getAttribute('data-zone_id');
            var phoneNumber = selectedOption.getAttribute('data-phone');
            phoneInput.value = phoneNumber;
            var doctorName = selectedOption.getAttribute('data-doctor');
            doctorInput.value = doctorName;
            select.style.display = "none";
        }

        function checkDoctorName() {
            var doctorName = document.getElementById("doctorName").value;
            if (doctorName.trim() === "") {
                alert("Please select a patient with a doctor name.");
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
